/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vcenter.mo;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.ph.phservice.provider.common.PageUtil;
import com.vmware.ph.phservice.provider.common.QuerySchemaUtil;
import com.vmware.ph.phservice.provider.vcenter.mo.SingletonMoReader;
import com.vmware.ph.phservice.provider.vimcommon.VmodlTypeToQuerySchemaModelInfoConverter;
import com.vmware.ph.phservice.provider.vimcommon.VmodlUtil;
import com.vmware.ph.phservice.provider.vimcommon.util.VimDataProviderUtil;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.vim.binding.vim.InternalServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.vmomi.core.types.ComplexType;
import com.vmware.vim.vmomi.core.types.DataObjectType;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class InternalSingletonMoDataProvider
implements DataProvider {
    private final VcClient _vcClient;
    private final SingletonMoReader _internalMoReader;
    private final DataProvider[] _conflictingDataProviders;
    private QuerySchema _querySchema;

    public InternalSingletonMoDataProvider(VcClient vcClient, DataProvider ... conflictingDataProviders) {
        this(vcClient, SingletonMoReader.createInternalSingletonMoReader(vcClient), conflictingDataProviders);
    }

    InternalSingletonMoDataProvider(VcClient vcClient, SingletonMoReader internalMoReader, DataProvider ... conflictingDataProviders) {
        this._internalMoReader = internalMoReader;
        this._conflictingDataProviders = conflictingDataProviders;
        this._vcClient = vcClient;
    }

    public QuerySchema getSchema() {
        if (this._querySchema == null) {
            this._querySchema = this.createSchema();
        }
        return this._querySchema;
    }

    public ResultSet executeQuery(Query query) {
        List queryProperties = query.getProperties();
        List<String> nonQualifiedQueryProperties = QuerySchemaUtil.getNonQualifiedPropertyNames(queryProperties);
        VmodlType vmodlType = this.getVmodlType(query);
        ManagedObject managedObject = this._internalMoReader.getManagedObject(vmodlType);
        URI managedObjectModelKey = VimDataProviderUtil.createManagedObjectModelKey(managedObject);
        List<Object> propertyValues = VimDataProviderUtil.getPropertyValues(managedObject, managedObjectModelKey, nonQualifiedQueryProperties);
        propertyValues = PageUtil.pageItems(propertyValues, query.getOffset(), query.getLimit());
        ResultSet.Builder resultSetBuilder = ResultSet.Builder.properties((List)queryProperties);
        resultSetBuilder.item((Object)managedObjectModelKey, propertyValues);
        return resultSetBuilder.build();
    }

    private QuerySchema createSchema() {
        VmodlTypeMap vmodlTypeMap = this._vcClient.getVmodlContext().getVmodlTypeMap();
        VmodlVersion vmodlVersion = this._vcClient.getVmodlVersion();
        DataObjectType vmodlType = (DataObjectType)vmodlTypeMap.getVmodlType(InternalServiceInstanceContent.class);
        List<VmodlType> vmodlTypes = VmodlUtil.getManagedObjectReferenceVmodlTypesInParentTypeProperties((ComplexType)vmodlType);
        Map<String, QuerySchema.ModelInfo> internalMoSchemaModels = VmodlTypeToQuerySchemaModelInfoConverter.convertVmodlTypesToWsdlNameModelInfos(vmodlTypes, vmodlTypeMap, vmodlVersion);
        QuerySchema internalMoQuerySchema = QuerySchema.forModels(internalMoSchemaModels);
        return QuerySchemaUtil.resolveConflict(internalMoQuerySchema, this._conflictingDataProviders);
    }

    private VmodlType getVmodlType(Query query) {
        String moWsdlType = (String)query.getResourceModels().iterator().next();
        VmodlTypeMap vmodlTypeMap = this._vcClient.getVmodlContext().getVmodlTypeMap();
        return vmodlTypeMap.getVmodlType(moWsdlType);
    }
}

