/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vcenter.pc;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.ph.phservice.provider.common.Pair;
import com.vmware.ph.phservice.provider.common.QuerySchemaUtil;
import com.vmware.ph.phservice.provider.vcenter.pc.PcSchemaConverter;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.ph.phservice.provider.vimcommon.vc.pc.PcDataProviderUtil;
import com.vmware.ph.phservice.provider.vimcommon.vc.pc.PropertyCollectorReader;
import com.vmware.ph.phservice.provider.vimcommon.vc.pc.PropertyCollectorUtil;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.view.ContainerView;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.InvalidProperty;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PcDataProviderImpl
implements DataProvider {
    private static final Log _log = LogFactory.getLog(PcDataProviderImpl.class);
    private final VcClient _vcClient;
    private final VmodlTypeMap _vmodlTypeMap;
    private final PcSchemaConverter _pcSchemaConverter;
    private final PropertyCollectorReader _pcReader;
    private final DataProvider[] _conflictingDataProviders;
    private QuerySchema _querySchema;
    private QuerySchema _supportedQuerySchema;

    public PcDataProviderImpl(VcClient vcClient, DataProvider ... conflictingDataProviders) {
        this(vcClient, (PcSchemaConverter)null, conflictingDataProviders);
    }

    public PcDataProviderImpl(VcClient vcClient, PcSchemaConverter pcSchemaConverter, DataProvider ... conflictingDataProviders) {
        this._vcClient = vcClient;
        this._vmodlTypeMap = vcClient.getVmodlContext().getVmodlTypeMap();
        if (pcSchemaConverter == null) {
            pcSchemaConverter = new PcSchemaConverter(this._vmodlTypeMap);
        }
        this._pcSchemaConverter = pcSchemaConverter;
        this._supportedQuerySchema = this._pcSchemaConverter.convertSchema(this._vcClient.getVmodlVersion());
        this._conflictingDataProviders = conflictingDataProviders;
        this._pcReader = new PropertyCollectorReader(vcClient);
    }

    public ResultSet executeQuery(Query query) {
        Collection queryResourceModelTypes = query.getResourceModels();
        List queryPropertyNames = query.getProperties();
        String queryResourceModelType = (String)queryResourceModelTypes.iterator().next();
        ResultSet resultSet = this.processQuery(queryResourceModelType, queryPropertyNames, query.getOffset(), query.getLimit());
        return resultSet;
    }

    public QuerySchema getSchema() {
        if (this._querySchema == null) {
            QuerySchema allQuerySchema = this._pcSchemaConverter.convertSchema(null);
            this._querySchema = QuerySchemaUtil.resolveConflict(allQuerySchema, this._conflictingDataProviders);
        }
        return this._querySchema;
    }

    private ResultSet processQuery(String queryResourceModelType, List<String> queryPropertyNames, int offset, int limit) {
        List<String> supportedQueryPropertyNames = QuerySchemaUtil.getSupportedQueryPropertyNames(queryResourceModelType, queryPropertyNames, this._supportedQuerySchema);
        if (supportedQueryPropertyNames == null || supportedQueryPropertyNames.isEmpty()) {
            return ResultSet.Builder.properties(queryPropertyNames).build();
        }
        VmodlType pcModelType = this._vmodlTypeMap.getVmodlType(queryResourceModelType);
        List<String> pcPropertyNames = PcDataProviderUtil.convertQueryPropertiesToPcProperties(supportedQueryPropertyNames);
        List<PropertyCollectorReader.PcResourceItem> pcResourceItems = this.callPc(pcModelType, pcPropertyNames, offset, limit);
        ResultSet resultSet = PcDataProviderUtil.convertPcResourceItemsToQueryResultSet(supportedQueryPropertyNames, pcResourceItems);
        return resultSet;
    }

    private List<PropertyCollectorReader.PcResourceItem> callPc(VmodlType pcModelType, List<String> pcPropertyNames, int offset, int limit) {
        List<PropertyCollectorReader.PcResourceItem> pcResourceItems;
        block2: {
            pcResourceItems = new ArrayList<PropertyCollectorReader.PcResourceItem>();
            try {
                PropertyCollector.FilterSpec pcFilterSpec = this.createFilterSpec(pcModelType, pcPropertyNames);
                pcResourceItems = this._pcReader.retrieveContent(pcFilterSpec, pcPropertyNames, offset, limit);
            }
            catch (InvalidProperty e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Call to PropertyCollector returned InvalidProperty fault for property " + e.getName() + " :"), (Throwable)e);
            }
        }
        return pcResourceItems;
    }

    private PropertyCollector.FilterSpec createFilterSpec(VmodlType pcModelType, List<String> pcPropertyNames) {
        PropertyCollector.FilterSpec filterSpec = null;
        ManagedObjectReference startMoRef = null;
        ArrayList<Pair<VmodlType, String>> traversalChain = new ArrayList<Pair<VmodlType, String>>();
        VmodlType startVmodlType = null;
        Pair<VmodlType, String> retrievalRule = this._pcSchemaConverter.getRetrievalRule(pcModelType);
        startVmodlType = retrievalRule != null ? retrievalRule.getFirst() : pcModelType;
        if (startVmodlType.equals(this._vmodlTypeMap.getVmodlType(ServiceInstance.class))) {
            startMoRef = VcClient.SERVICE_INSTANCE_MOREF;
        } else {
            ManagedObjectReference containerViewMoRef;
            startMoRef = containerViewMoRef = this._pcReader.createContainerView();
            traversalChain.add(new Pair<VmodlType, String>(this._vmodlTypeMap.getVmodlType(ContainerView.class), "view"));
        }
        if (retrievalRule != null) {
            traversalChain.add(retrievalRule);
        }
        filterSpec = PropertyCollectorUtil.createTraversableFilterSpec(pcModelType, pcPropertyNames, startMoRef, traversalChain, this._vmodlTypeMap);
        return filterSpec;
    }
}

