/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vcenter.pc;

import com.vmware.cis.data.api.QuerySchema;
import com.vmware.ph.phservice.provider.common.Pair;
import com.vmware.ph.phservice.provider.vimcommon.VmodlTypeToQuerySchemaModelInfoConverter;
import com.vmware.ph.phservice.provider.vimcommon.VmodlUtil;
import com.vmware.ph.phservice.provider.vimcommon.vc.util.ManagedEntityReader;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PcSchemaConverter {
    protected final VmodlTypeMap _vmodlTypeMap;
    private Map<VmodlType, Pair<VmodlType, String>> _managedObjectToRetrievalRules;

    public PcSchemaConverter(VmodlTypeMap vmodlTypeMap) {
        this._vmodlTypeMap = vmodlTypeMap;
    }

    public QuerySchema convertSchema(VmodlVersion vmodlVersion) {
        LinkedHashMap<String, QuerySchema.ModelInfo> models = new LinkedHashMap<String, QuerySchema.ModelInfo>();
        models.putAll(VmodlTypeToQuerySchemaModelInfoConverter.convertVmodlTypesToWsdlNameModelInfos(this.getManagedObjectToRetrievalRules().keySet(), this._vmodlTypeMap, vmodlVersion));
        return QuerySchema.forModels(models);
    }

    public Pair<VmodlType, String> getRetrievalRule(VmodlType moVmodlType) {
        return this.getManagedObjectToRetrievalRules().get(moVmodlType);
    }

    protected Map<VmodlType, Pair<VmodlType, String>> loadManagedObjectToRetrievalRules() {
        LinkedHashMap<VmodlType, Pair<VmodlType, String>> retrievalRules = new LinkedHashMap<VmodlType, Pair<VmodlType, String>>();
        retrievalRules.putAll(this.getRetrievalRulesForServiceInstanceMOs());
        retrievalRules.putAll(this.getRetrievalRulesForInventoryMEs());
        return retrievalRules;
    }

    protected final Map<VmodlType, Pair<VmodlType, String>> getRetrievalRulesForServiceInstanceMOs() {
        VmodlType serviceInstanceVmodlType = this._vmodlTypeMap.getVmodlType(ServiceInstance.class);
        return VmodlUtil.getRetrievalRulesForRelatedManagedObjects(Arrays.asList(serviceInstanceVmodlType), this._vmodlTypeMap, null);
    }

    protected final Map<VmodlType, Pair<VmodlType, String>> getRetrievalRulesForInventoryMEs() {
        List<VmodlType> inventoryManagedEntityVmodlTypes = ManagedEntityReader.getInventoryManagedEntityVmodlTypes(this._vmodlTypeMap);
        return VmodlUtil.getRetrievalRulesForRelatedManagedObjects(inventoryManagedEntityVmodlTypes, this._vmodlTypeMap, null);
    }

    private Map<VmodlType, Pair<VmodlType, String>> getManagedObjectToRetrievalRules() {
        if (this._managedObjectToRetrievalRules == null) {
            this._managedObjectToRetrievalRules = this.loadManagedObjectToRetrievalRules();
        }
        return this._managedObjectToRetrievalRules;
    }
}

