/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vcenter.performance;

import com.vmware.ph.phservice.provider.vcenter.performance.PerfEntityMetrics;
import com.vmware.ph.phservice.provider.vcenter.performance.PerfMetadata;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PerfEntityMetricsUtil {
    private static final Log _log = LogFactory.getLog(PerfEntityMetricsUtil.class);
    static final List<Object[]> EMPTY_ENTITY_METRICS = Collections.emptyList();

    private PerfEntityMetricsUtil() {
    }

    public static List<PerfEntityMetrics> convertCsvEntityMetricToPerfMetrics(List<ManagedObjectReference> entityMoRefs, PerformanceManager.EntityMetricBase[] entityMetrics, PerfMetadata perfMetadata) {
        Map<ManagedObjectReference, PerfEntityMetrics> entityMoRefToPerfMetrics = PerfEntityMetricsUtil.createEmptyEntityMoRefToPerfMetrics(entityMoRefs);
        if (!ArrayUtils.isEmpty((Object[])entityMetrics)) {
            Map<ManagedObjectReference, PerfEntityMetrics> convertedEntityMoRefToPerfMetrics = PerfEntityMetricsUtil.convertEntityMetricCsvToPerfMetrics(entityMetrics, perfMetadata);
            entityMoRefToPerfMetrics.putAll(convertedEntityMoRefToPerfMetrics);
        }
        return new ArrayList<PerfEntityMetrics>(entityMoRefToPerfMetrics.values());
    }

    private static Map<ManagedObjectReference, PerfEntityMetrics> createEmptyEntityMoRefToPerfMetrics(List<ManagedObjectReference> entityMoRefs) {
        LinkedHashMap<ManagedObjectReference, PerfEntityMetrics> entityMoRefToPerfMetrics = new LinkedHashMap<ManagedObjectReference, PerfEntityMetrics>(entityMoRefs.size());
        for (ManagedObjectReference entityMoRef : entityMoRefs) {
            PerfEntityMetrics emptyEntityMetric = PerfEntityMetricsUtil.createEmptyEntityMetrics(entityMoRef);
            entityMoRefToPerfMetrics.put(entityMoRef, emptyEntityMetric);
        }
        return entityMoRefToPerfMetrics;
    }

    private static Map<ManagedObjectReference, PerfEntityMetrics> convertEntityMetricCsvToPerfMetrics(PerformanceManager.EntityMetricBase[] entityMetrics, PerfMetadata perfMetadata) {
        LinkedHashMap<ManagedObjectReference, PerfEntityMetrics> entityMetricsToPerfMetrics = new LinkedHashMap<ManagedObjectReference, PerfEntityMetrics>(entityMetrics.length);
        for (PerformanceManager.EntityMetricBase entityMetric : entityMetrics) {
            PerfEntityMetrics perfEntityMetric = PerfEntityMetricsUtil.convertEntityMetricCsvToPerfMetrics(perfMetadata, (PerformanceManager.EntityMetricCSV)entityMetric);
            entityMetricsToPerfMetrics.put(entityMetric.entity, perfEntityMetric);
        }
        return entityMetricsToPerfMetrics;
    }

    private static PerfEntityMetrics convertEntityMetricCsvToPerfMetrics(PerfMetadata performanceMetadata, PerformanceManager.EntityMetricCSV entityMetric) {
        String entityMoRefValue = entityMetric.entity.getValue();
        _log.trace((Object)String.format("Converting collected metrics for entity of type [%s] and value [%s]", entityMetric.entity.getType(), entityMoRefValue));
        if (StringUtils.isBlank((String)entityMetric.sampleInfoCSV)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("sampleInfo is null or empty for entity %s.", entityMetric.entity));
            }
            return PerfEntityMetricsUtil.createEmptyEntityMetrics(entityMetric.entity);
        }
        String[] sampleInfo = entityMetric.sampleInfoCSV.split(",");
        LinkedList<Object[]> perfMetrics = new LinkedList<Object[]>();
        for (PerformanceManager.MetricSeriesCSV csvMetric : entityMetric.value) {
            String counterName = performanceMetadata.getCounterNameForCounterKey(csvMetric.id.counterId);
            if (StringUtils.isBlank((String)csvMetric.value)) {
                if (!_log.isTraceEnabled()) continue;
                _log.trace((Object)String.format("Found null csvMetric.value for entity [%s] and counter [%s].", entityMoRefValue, counterName));
                continue;
            }
            String[] samples = csvMetric.value.split(",");
            String instance = csvMetric.id.instance == null ? "" : csvMetric.id.instance.trim();
            for (int i = 0; i < sampleInfo.length && i / 2 < samples.length; i += 2) {
                long sampleValue;
                int samplingPeriod;
                try {
                    samplingPeriod = Integer.valueOf(sampleInfo[i]);
                }
                catch (NumberFormatException e) {
                    if (!_log.isTraceEnabled()) continue;
                    _log.trace((Object)String.format("Found non-int sampling period [%s] while converting perf stats for entity [%s]", sampleInfo[i], entityMoRefValue));
                    continue;
                }
                try {
                    sampleValue = Long.valueOf(samples[i / 2]);
                }
                catch (NumberFormatException e) {
                    if (!_log.isTraceEnabled()) continue;
                    _log.trace((Object)String.format("Found non-long sample value [%s] while converting perf stats for counter [%s] of entity %s.", samples[i / 2], counterName, entityMoRefValue));
                    continue;
                }
                String timestamp = sampleInfo[i + 1];
                Object[] perfMetric = new Object[]{counterName, samplingPeriod, timestamp, sampleValue, instance};
                perfMetrics.add(perfMetric);
            }
        }
        return new PerfEntityMetrics(entityMetric.entity, perfMetrics);
    }

    private static PerfEntityMetrics createEmptyEntityMetrics(ManagedObjectReference entityMoRef) {
        return new PerfEntityMetrics(entityMoRef, EMPTY_ENTITY_METRICS);
    }
}

