/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vcenter.performance;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.ph.phservice.provider.common.QuerySchemaUtil;
import com.vmware.ph.phservice.provider.vcenter.performance.PerfEntityMetrics;
import com.vmware.ph.phservice.provider.vcenter.performance.PerfInterval;
import com.vmware.ph.phservice.provider.vcenter.performance.PerfMetricsReader;
import com.vmware.ph.phservice.provider.vimcommon.VmodlTypeToQuerySchemaModelInfoConverter;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.ph.phservice.provider.vimcommon.vc.util.ManagedEntityReader;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class PerfMetricsDataProvider
implements DataProvider {
    static final String PERF_COUNTERS_PROPERTY = "perfCounters";
    static final String PERF_ENTITY_METRICS_PROPERTY = "perfEntityMetrics";
    static final String PERF_INTERVAL_PROPERTY = "perfInterval";
    private final VmodlTypeMap _vmodlTypeMap;
    private final ManagedEntityReader _entityMoRefReader;
    private final PerfMetricsReader _perfMetricsReader;

    public PerfMetricsDataProvider(VcClient vcClient) {
        this._vmodlTypeMap = vcClient.getVmodlContext().getVmodlTypeMap();
        this._entityMoRefReader = new ManagedEntityReader(vcClient);
        this._perfMetricsReader = new PerfMetricsReader(vcClient);
    }

    PerfMetricsDataProvider(VmodlTypeMap vmodlTypeMap, ManagedEntityReader entityMoRefReader, PerfMetricsReader perfMetricsReader) {
        this._vmodlTypeMap = vmodlTypeMap;
        this._entityMoRefReader = entityMoRefReader;
        this._perfMetricsReader = perfMetricsReader;
    }

    public QuerySchema getSchema() {
        List<VmodlType> inventoryVmodlTypes = ManagedEntityReader.getInventoryManagedEntityVmodlTypes(this._vmodlTypeMap);
        List<String> propertyNames = Arrays.asList(PERF_ENTITY_METRICS_PROPERTY, PERF_COUNTERS_PROPERTY, PERF_INTERVAL_PROPERTY);
        HashMap<String, QuerySchema.ModelInfo> schemaModels = new HashMap<String, QuerySchema.ModelInfo>();
        for (VmodlType vmodlType : inventoryVmodlTypes) {
            QuerySchema.ModelInfo modelInfo = VmodlTypeToQuerySchemaModelInfoConverter.convertPropertyNamesToModelInfo(propertyNames);
            schemaModels.put(vmodlType.getWsdlName(), modelInfo);
        }
        QuerySchema querySchema = QuerySchema.forModels(schemaModels);
        return querySchema;
    }

    public ResultSet executeQuery(Query query) {
        List<ManagedObjectReference> managedEntityMoRefs = this.getManagedEntityMoRefs(query);
        List queryProperties = query.getProperties();
        Map<ManagedObjectReference, List<Object>> managedEntityMoRefToPropertyValues = this.getManagedEntitiesPropertyValues(managedEntityMoRefs, queryProperties, query.getFilter());
        ResultSet resultSet = PerfMetricsDataProvider.buildQueryResultSet(queryProperties, managedEntityMoRefs, managedEntityMoRefToPropertyValues);
        return resultSet;
    }

    private List<ManagedObjectReference> getManagedEntityMoRefs(Query query) {
        String resourceModel = (String)query.getResourceModels().iterator().next();
        VmodlType vmodlType = this._vmodlTypeMap.getVmodlType(resourceModel);
        List<ManagedObjectReference> managedEntityMoRefs = this._entityMoRefReader.getManagedEntityMoRefs(vmodlType, query.getOffset(), query.getLimit());
        return managedEntityMoRefs;
    }

    private Map<ManagedObjectReference, List<Object>> getManagedEntitiesPropertyValues(List<ManagedObjectReference> managedEntityMoRefs, List<String> queryProperties, Filter queryFilter) {
        List<String> nonQualifiedQueryProperties = QuerySchemaUtil.getNonQualifiedPropertyNames(queryProperties);
        Map<String, Object> filterProperties = PerfMetricsDataProvider.getFilterProperties(queryFilter.getCriteria());
        LinkedHashMap<ManagedObjectReference, List<Object>> moRefToPropertyValues = new LinkedHashMap<ManagedObjectReference, List<Object>>(managedEntityMoRefs.size());
        for (String queryProperty : nonQualifiedQueryProperties) {
            if (QuerySchemaUtil.isQueryPropertyModelKey(queryProperty)) continue;
            Map<ManagedObjectReference, Object> moRefToPropertyValue = this.getManagedEntitiesPropertyValue(managedEntityMoRefs, queryProperty, filterProperties);
            PerfMetricsDataProvider.mergePropertyValues(moRefToPropertyValues, moRefToPropertyValue);
        }
        return moRefToPropertyValues;
    }

    private static ResultSet buildQueryResultSet(List<String> queryProperties, List<ManagedObjectReference> managedEntityMoRefs, Map<ManagedObjectReference, List<Object>> managedEntityMoRefToPropertyValues) {
        ResultSet.Builder resultBuilder = ResultSet.Builder.properties(queryProperties);
        for (ManagedObjectReference managedEntityMoRef : managedEntityMoRefs) {
            List<Object> propertyValues = managedEntityMoRefToPropertyValues.get(managedEntityMoRef);
            propertyValues.add(0, managedEntityMoRef);
            resultBuilder.item((Object)managedEntityMoRef, propertyValues);
        }
        return resultBuilder.build();
    }

    private Map<ManagedObjectReference, Object> getManagedEntitiesPropertyValue(List<ManagedObjectReference> managedEntityMoRefs, String queryProperty, Map<String, Object> filterProperties) {
        switch (queryProperty) {
            case "perfEntityMetrics": {
                List<PerfEntityMetrics> entityMetrics = this.getManagedEntityMetrics(managedEntityMoRefs, filterProperties);
                return PerfMetricsDataProvider.convertToMetricsValues(entityMetrics);
            }
            case "perfInterval": {
                return PerfMetricsDataProvider.convertToIntervalValues(managedEntityMoRefs, filterProperties);
            }
            case "perfCounters": {
                return PerfMetricsDataProvider.convertToCounterValues(managedEntityMoRefs, filterProperties);
            }
        }
        return Collections.emptyMap();
    }

    private List<PerfEntityMetrics> getManagedEntityMetrics(List<ManagedObjectReference> managedEntityMoRefs, Map<String, Object> filterProperties) {
        if (managedEntityMoRefs.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> countersNames = PerfMetricsDataProvider.getPerfCountersNames(filterProperties, true);
        PerfInterval perfInterval = PerfMetricsDataProvider.getPerfInterval(filterProperties, true);
        return this._perfMetricsReader.collectPerformanceData(managedEntityMoRefs, countersNames, perfInterval);
    }

    private static Map<String, Object> getFilterProperties(List<PropertyPredicate> criteria) {
        TreeMap<String, Object> filterProperties = new TreeMap<String, Object>();
        for (PropertyPredicate propertyPredicate : criteria) {
            String propertyName = QuerySchemaUtil.getActualPropertyName(propertyPredicate.getProperty());
            filterProperties.put(propertyName, propertyPredicate.getComparableValue());
        }
        return filterProperties;
    }

    private static void mergePropertyValues(Map<ManagedObjectReference, List<Object>> moRefToCurrentPropertyValues, Map<ManagedObjectReference, Object> moRefToPropertyValue) {
        for (Map.Entry<ManagedObjectReference, Object> propertyValueEntry : moRefToPropertyValue.entrySet()) {
            ManagedObjectReference moRef = propertyValueEntry.getKey();
            List<Object> propertyValues = moRefToCurrentPropertyValues.get(moRef);
            if (propertyValues == null) {
                propertyValues = new LinkedList<Object>();
            }
            propertyValues.add(propertyValueEntry.getValue());
            moRefToCurrentPropertyValues.put(moRef, propertyValues);
        }
    }

    private static Map<ManagedObjectReference, Object> convertToMetricsValues(List<PerfEntityMetrics> entityMetrics) {
        LinkedHashMap<ManagedObjectReference, Object> moRefToEntityMetrics = new LinkedHashMap<ManagedObjectReference, Object>(entityMetrics.size());
        for (PerfEntityMetrics entityMetric : entityMetrics) {
            ManagedObjectReference entityMoRef = entityMetric.getEntityMoRef();
            List<Object[]> metricsForMoRef = entityMetric.getEntityMetrics();
            moRefToEntityMetrics.put(entityMoRef, metricsForMoRef);
        }
        return moRefToEntityMetrics;
    }

    private static Map<ManagedObjectReference, Object> convertToIntervalValues(List<ManagedObjectReference> managedEntityMoRefs, Map<String, Object> filterProperties) {
        PerfInterval perfInterval = PerfMetricsDataProvider.getPerfInterval(filterProperties, false);
        return PerfMetricsDataProvider.convertToSameValueMap(managedEntityMoRefs, (Object)perfInterval);
    }

    private static Map<ManagedObjectReference, Object> convertToCounterValues(List<ManagedObjectReference> managedEntityMoRefs, Map<String, Object> filterProperties) {
        List<String> countersNames = PerfMetricsDataProvider.getPerfCountersNames(filterProperties, false);
        return PerfMetricsDataProvider.convertToSameValueMap(managedEntityMoRefs, countersNames);
    }

    private static List<String> getPerfCountersNames(Map<String, Object> filterProperties, boolean isPerfCountersRequired) {
        Object perfCounters = filterProperties.get(PERF_COUNTERS_PROPERTY);
        if (perfCounters != null && perfCounters instanceof List) {
            return (List)perfCounters;
        }
        if (isPerfCountersRequired) {
            throw new IllegalArgumentException(String.format("Rrequired [%s] property should contain list of counter names.", PERF_COUNTERS_PROPERTY));
        }
        return null;
    }

    private static PerfInterval getPerfInterval(Map<String, Object> filterProperties, boolean isPerfIntervalRequired) {
        Object perfInterval = filterProperties.get(PERF_INTERVAL_PROPERTY);
        if (perfInterval != null) {
            return PerfInterval.parse((String)perfInterval);
        }
        if (isPerfIntervalRequired) {
            throw new IllegalArgumentException(String.format("Missing value for required [%s] property. Supported values are %s.", PERF_INTERVAL_PROPERTY, Arrays.toString((Object[])PerfInterval.values())));
        }
        return null;
    }

    private static Map<ManagedObjectReference, Object> convertToSameValueMap(List<ManagedObjectReference> managedEntityMoRefs, Object value) {
        LinkedHashMap<ManagedObjectReference, Object> moRefToSameValues = new LinkedHashMap<ManagedObjectReference, Object>(managedEntityMoRefs.size());
        for (ManagedObjectReference managedEntityRef : managedEntityMoRefs) {
            moRefToSameValues.put(managedEntityRef, value);
        }
        return moRefToSameValues;
    }
}

