/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vcenter.performance;

import com.vmware.ph.phservice.provider.vcenter.performance.PerfEntityMetrics;
import com.vmware.ph.phservice.provider.vcenter.performance.PerfEntityMetricsUtil;
import com.vmware.ph.phservice.provider.vcenter.performance.PerfInterval;
import com.vmware.ph.phservice.provider.vcenter.performance.PerfMetadata;
import com.vmware.ph.phservice.provider.vcenter.performance.PerfMetadataBuilder;
import com.vmware.ph.phservice.provider.vcenter.performance.PerfQuerySpecUtil;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.vim.binding.vim.HistoricalInterval;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.List;

public class PerfMetricsReader {
    private final Object _lock = new Object();
    private final VcClient _vcClient;
    private volatile PerformanceManager _perfManager;
    private volatile PerfMetadata _perfMetadata;

    public PerfMetricsReader(VcClient vcClient) {
        this._vcClient = vcClient;
    }

    public List<PerfEntityMetrics> collectPerformanceData(List<ManagedObjectReference> entityMoRefs, List<String> countersNames, PerfInterval perfInterval) {
        this.initializePerfManagerOnce();
        this.initializePerfMetdataOnce();
        PerformanceManager.QuerySpec[] querySpecs = PerfQuerySpecUtil.createPerfQuerySpec(entityMoRefs, countersNames, perfInterval, this._perfMetadata);
        PerformanceManager.EntityMetricBase[] entityMetrics = this._perfManager.queryStats(querySpecs);
        List<PerfEntityMetrics> perfEntityMetrics = PerfEntityMetricsUtil.convertCsvEntityMetricToPerfMetrics(entityMoRefs, entityMetrics, this._perfMetadata);
        return perfEntityMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePerfManagerOnce() {
        if (this._perfManager != null) {
            return;
        }
        Object object = this._lock;
        synchronized (object) {
            if (this._perfManager != null) {
                return;
            }
            ManagedObjectReference perfManagerMoRef = this._vcClient.getServiceInstanceContent().getPerfManager();
            this._perfManager = (PerformanceManager)this._vcClient.createMo(perfManagerMoRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PerfMetadata initializePerfMetdataOnce() {
        if (this._perfMetadata != null) {
            return this._perfMetadata;
        }
        Object object = this._lock;
        synchronized (object) {
            if (this._perfMetadata != null) {
                return this._perfMetadata;
            }
            PerformanceManager.CounterInfo[] counterInfos = this._perfManager.getPerfCounter();
            HistoricalInterval[] historicalIntervals = this._perfManager.getHistoricalInterval();
            this._perfMetadata = PerfMetadataBuilder.buildPerfMetadata(counterInfos, historicalIntervals);
            return this._perfMetadata;
        }
    }
}

