/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vcenter.performance;

import com.vmware.ph.phservice.provider.vcenter.performance.PerfInterval;
import com.vmware.ph.phservice.provider.vcenter.performance.PerfMetadata;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;

public final class PerfQuerySpecUtil {
    private static final String INSTANCE_PROPERTY_VALUE = "*";

    private PerfQuerySpecUtil() {
    }

    public static PerformanceManager.QuerySpec[] createPerfQuerySpec(List<ManagedObjectReference> entityMoRefs, List<String> countersNames, PerfInterval perfInterval, PerfMetadata perfMetadata) {
        PerformanceManager.QuerySpec[] perfQueries = new PerformanceManager.QuerySpec[entityMoRefs.size()];
        Iterator<ManagedObjectReference> entityMoRefsIterator = entityMoRefs.iterator();
        int i = 0;
        while (entityMoRefsIterator.hasNext()) {
            PerformanceManager.QuerySpec perfQuery;
            ManagedObjectReference entityMoRef = entityMoRefsIterator.next();
            perfQueries[i] = perfQuery = PerfQuerySpecUtil.createPerfQuerySpec(entityMoRef, countersNames, perfInterval, perfMetadata);
            ++i;
        }
        return perfQueries;
    }

    private static PerformanceManager.QuerySpec createPerfQuerySpec(ManagedObjectReference entityMoRef, List<String> countersNames, PerfInterval perfInterval, PerfMetadata perfMetadata) {
        int samplingPeriod = perfMetadata.getSamplingPeriodForInterval(perfInterval);
        Calendar startTime = PerfQuerySpecUtil.getIntervalStartTime(perfInterval);
        ArrayList<PerformanceManager.MetricId> metricId = new ArrayList<PerformanceManager.MetricId>(countersNames.size());
        for (String counterName : countersNames) {
            int counterKey = perfMetadata.getCounterKeyForCounterName(counterName);
            metricId.add(new PerformanceManager.MetricId(counterKey, INSTANCE_PROPERTY_VALUE));
        }
        PerformanceManager.QuerySpec spec = new PerformanceManager.QuerySpec();
        spec.intervalId = samplingPeriod;
        spec.startTime = startTime;
        spec.format = PerformanceManager.Format.csv.name();
        spec.entity = entityMoRef;
        spec.metricId = metricId.toArray(new PerformanceManager.MetricId[metricId.size()]);
        return spec;
    }

    private static Calendar getIntervalStartTime(PerfInterval perfInterval) {
        if (perfInterval == PerfInterval.REALTIME) {
            return null;
        }
        int amountInDays = 0;
        switch (perfInterval) {
            case DAILY: {
                amountInDays = -1;
                break;
            }
            case WEEKLY: {
                amountInDays = -7;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Supported values for historical interval are [%s] and [%s]", new Object[]{PerfInterval.DAILY, PerfInterval.WEEKLY}));
            }
        }
        Calendar startTime = Calendar.getInstance(DateUtils.UTC_TIME_ZONE);
        startTime.add(5, amountInDays);
        return startTime;
    }
}

