/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vcenter.resourcemodel;

import com.vmware.ph.phservice.provider.common.Pair;
import com.vmware.ph.phservice.provider.vcenter.pc.PcSchemaConverter;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class PcResourceModelSchemaConverter
extends PcSchemaConverter {
    private static final List<String> SERVICE_INSTANCE_RELATED_MANAGED_OBJECTS = Arrays.asList("CustomFieldsManager", "ServiceInstance");
    private static final List<String> INVENTORY_RELATED_MANAGED_OBJECTS_RULES = Arrays.asList("HostAuthenticationManager", "HostCacheConfigurationManager", "HostCertificateManager", "HostCpuSchedulerSystem", "HostDatastoreSystem", "HostDiagnosticSystem", "HostEsxAgentHostManager", "HostFirewallSystem", "HostNetworkSystem", "HostPciPassthruSystem", "HostPowerSystem", "HostStorageSystem", "HostProfile", "ScheduledTask", "EnvironmentBrowser", "VirtualMachineSnapshot");

    public PcResourceModelSchemaConverter(VmodlTypeMap vmodlTypeMap) {
        super(vmodlTypeMap);
    }

    @Override
    protected Map<VmodlType, Pair<VmodlType, String>> loadManagedObjectToRetrievalRules() {
        Map<VmodlType, Pair<VmodlType, String>> managedObjectToRetrievalRules = super.loadManagedObjectToRetrievalRules();
        LinkedHashMap<VmodlType, Pair<VmodlType, String>> filteredManagedObjectToRetrievalRule = new LinkedHashMap<VmodlType, Pair<VmodlType, String>>();
        VmodlType serviceInstanceVmodlType = this._vmodlTypeMap.getVmodlType(ServiceInstance.class);
        for (Map.Entry<VmodlType, Pair<VmodlType, String>> moToRetrievalRule : managedObjectToRetrievalRules.entrySet()) {
            VmodlType moVmodlType = moToRetrievalRule.getKey();
            Pair<VmodlType, String> retrievalRule = moToRetrievalRule.getValue();
            if (retrievalRule == null) {
                filteredManagedObjectToRetrievalRule.put(moVmodlType, retrievalRule);
                continue;
            }
            VmodlType startMoVmodlType = retrievalRule.getFirst();
            if (startMoVmodlType.equals(serviceInstanceVmodlType)) {
                if (!SERVICE_INSTANCE_RELATED_MANAGED_OBJECTS.contains(moVmodlType.getWsdlName())) continue;
                filteredManagedObjectToRetrievalRule.put(moVmodlType, retrievalRule);
                continue;
            }
            if (!INVENTORY_RELATED_MANAGED_OBJECTS_RULES.contains(moVmodlType.getWsdlName())) continue;
            filteredManagedObjectToRetrievalRule.put(moVmodlType, retrievalRule);
        }
        return filteredManagedObjectToRetrievalRule;
    }
}

