/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vcenter.resourcemodel;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.adapters.vmomi.impl.VmomiDataProviderConnection;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RiseResourceModelDataProviderImpl
implements DataProvider {
    private static final Log _logger = LogFactory.getLog(RiseResourceModelDataProviderImpl.class);
    private final VcClient _vcClient;
    private final VmomiDataProviderConnection _resourceModelVmomiDataProviderConnection;
    private final Object _authenticationLock = new Object();
    private volatile boolean _isVcClientAuthenticated = false;

    public RiseResourceModelDataProviderImpl(VcClient vcClient) {
        this._vcClient = vcClient;
        this._resourceModelVmomiDataProviderConnection = new VmomiDataProviderConnection(vcClient.getVlsiClient());
    }

    public ResultSet executeQuery(Query query) {
        this.authenticateVcClientIfNecessary();
        return this._resourceModelVmomiDataProviderConnection.executeQuery(query);
    }

    public QuerySchema getSchema() {
        this.authenticateVcClientIfNecessary();
        return this._resourceModelVmomiDataProviderConnection.getSchema();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void authenticateVcClientIfNecessary() {
        if (!this._isVcClientAuthenticated) {
            Object object = this._authenticationLock;
            synchronized (object) {
                if (!this._isVcClientAuthenticated) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)"Attempting to login to VC");
                    }
                    ManagedObjectReference serviceInstanceMoRef = new ManagedObjectReference("ServiceInstance", "ServiceInstance");
                    ServiceInstance serviceInstance = (ServiceInstance)this._vcClient.createMo(serviceInstanceMoRef);
                    serviceInstance.currentTime();
                    if (_logger.isInfoEnabled()) {
                        _logger.info((Object)"Successfully logged into VC");
                    }
                    this._isVcClientAuthenticated = true;
                }
            }
        }
    }
}

