/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vimcommon;

import com.vmware.ph.phservice.ciscommon.lookup.LookupClient;
import com.vmware.ph.phservice.ciscommon.lookup.LookupClientBuilder;
import com.vmware.ph.phservice.ciscommon.lookup.ServiceLocatorUtil;
import com.vmware.ph.phservice.ciscommon.sso.SsoTokenProvider;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClientBuilder;
import com.vmware.vim.binding.cis.data.provider.version.internal.version1;
import com.vmware.vim.binding.cis.data.provider.version.internal.version12;
import com.vmware.vim.binding.lookup.LookupService;
import com.vmware.vim.binding.lookup.SearchCriteria;
import com.vmware.vim.binding.lookup.Service;
import com.vmware.vim.binding.lookup.ServiceEndpoint;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.lookup.fault.ServiceFault;
import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vim.binding.vim.version.internal.version10;
import com.vmware.vim.binding.vim.version.internal.version5;
import com.vmware.vim.binding.vim.version.internal.version6;
import com.vmware.vim.binding.vim.version.internal.version7;
import com.vmware.vim.binding.vim.version.internal.version8;
import com.vmware.vim.binding.vim.version.internal.version9;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.util.concurrent.Executors;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VimContext {
    private static final Log _log = LogFactory.getLog(VimContext.class);
    private static final URI LS1_VC_SERVICE_TYPE;
    private static final ServiceRegistration.ServiceType LS2_VC_SERVICE_TYPE;
    private static final ServiceRegistration.EndpointType LS2_VC_SDK_ENDPOINT_TYPE;
    private static final Class<?> DEFAULT_VC_VERSION_CLASS;
    private final KeyStore _vimTrustStore;
    private ThumbprintVerifier _vimThumbprintVerifier;
    private URI _lookupSdkUri;
    private LookupClientBuilder _lookupClientBuilder;
    private SsoTokenProvider _ssoTokenProvider;
    private String _vcInstanceUuid;
    private URI _vcSdkUri;
    private String _vcNodeId;
    private Class<?> _vcVersionClass;
    private String _legacyVcUsername;
    private char[] _legacyVcPassword;
    private final boolean _isLegacyVim;

    public VimContext(KeyStore vimTrustStore, URI lookupSdkUri, LookupClientBuilder lookupClientBuilder, SsoTokenProvider ssoTokenProvider, String vcInstanceUuid, URI vcSdkUri, String vcNodeId) {
        this._vimTrustStore = vimTrustStore;
        this._lookupSdkUri = lookupSdkUri;
        this._lookupClientBuilder = lookupClientBuilder;
        this._ssoTokenProvider = ssoTokenProvider;
        this._vcInstanceUuid = vcInstanceUuid;
        this._vcSdkUri = vcSdkUri;
        this._vcNodeId = vcNodeId;
        this._isLegacyVim = false;
    }

    public VimContext(KeyStore vimTrustStore, URI vcSdkUri, String legacyVcUsername, char[] legacyVcPassword) {
        this._vimTrustStore = vimTrustStore;
        this._vcSdkUri = vcSdkUri;
        this._legacyVcUsername = legacyVcUsername;
        this._legacyVcPassword = legacyVcPassword;
        this._isLegacyVim = true;
    }

    public void setVimThumbprintVerifier(ThumbprintVerifier vimThumbprintVerifier) {
        this._vimThumbprintVerifier = vimThumbprintVerifier;
    }

    public void setVcVersionClass(Class<?> vcVersionClass) {
        this._vcVersionClass = vcVersionClass;
    }

    public SsoTokenProvider getSsoTokenProvider() {
        return this._ssoTokenProvider;
    }

    public LookupClientBuilder getLookupClientBuilder(boolean tryToDetermineSuitableVersion) {
        if (this._isLegacyVim) {
            return null;
        }
        if (!tryToDetermineSuitableVersion) {
            return this._lookupClientBuilder;
        }
        LookupClientBuilder lookupClientBuilder = LookupClientBuilder.forLookupVersion(LookupClientBuilder.LATEST_LOOKUP_VERSION_CLASS, Executors.newSingleThreadExecutor()).withTrust(this._vimTrustStore, this._vimThumbprintVerifier).withLookupSdkUri(this._lookupSdkUri);
        try (LookupClient lookupClient = lookupClientBuilder.build();){
            boolean isSupported = true;
            try {
                ServiceRegistration sr = lookupClient.getServiceRegistration();
                if (sr == null) {
                    isSupported = false;
                }
            }
            catch (Exception e) {
                isSupported = false;
            }
            if (!isSupported) {
                lookupClientBuilder = this._lookupClientBuilder;
            }
        }
        return lookupClientBuilder;
    }

    public VcClientBuilder getVcClientBuilder() {
        return this.getVcClientBuilder(false);
    }

    public VcClientBuilder getVcClientBuilder(boolean tryToDetermineSuitableVersion) {
        Class<?> vcVersionClass = this._vcVersionClass;
        if (vcVersionClass == null) {
            vcVersionClass = DEFAULT_VC_VERSION_CLASS;
        }
        VcClientBuilder vcClientBuilder = VcClientBuilder.forVcVersion(vcVersionClass, Executors.newSingleThreadExecutor()).withTrust(this._vimTrustStore, this._vimThumbprintVerifier).withVcSdkUri(this.getVcSdkUri());
        if (tryToDetermineSuitableVersion) {
            try (VcClient vcClient = vcClientBuilder.build();){
                Class<?> desiredVersionClass = VimContext.getDesiredVersionClass(vcClient);
                if (!desiredVersionClass.equals(vcClient.getVmodlVersion().getClass())) {
                    vcClientBuilder = VcClientBuilder.forVcVersion(desiredVersionClass, Executors.newSingleThreadExecutor()).withTrust(this._vimTrustStore, this._vimThumbprintVerifier).withVcSdkUri(this.getVcSdkUri());
                }
            }
        }
        if (this._ssoTokenProvider != null) {
            vcClientBuilder.withSsoTokenProvider(this._ssoTokenProvider);
        } else if (this._legacyVcUsername != null) {
            vcClientBuilder.withVcCredentials(this._legacyVcUsername, this._legacyVcPassword);
        }
        return vcClientBuilder;
    }

    public String getVcInstanceUuid() {
        if (this._vcInstanceUuid == null) {
            this.initLookupVcService();
        }
        return this._vcInstanceUuid;
    }

    public URI getVcSdkUri() {
        if (this._vcSdkUri == null) {
            this.initLookupVcService();
        }
        return this._vcSdkUri;
    }

    public URI getLookupSdkUri() {
        return this._lookupSdkUri;
    }

    public KeyStore getVimTrustedStore() {
        return this._vimTrustStore;
    }

    public ThumbprintVerifier getThumprintVerifier() {
        return this._vimThumbprintVerifier;
    }

    private void initLookupVcService() {
        ServiceRegistration.Info serviceInfo;
        Service vcService;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("Attempt to lookup VC service with the following VC service coordinates: vcSdkUri: %s, vcInstanceUuid: %s, vcNodeId: %s", this._vcSdkUri, this._vcInstanceUuid, this._vcNodeId));
        }
        if ((vcService = this.lookupVcService()) != null) {
            ServiceEndpoint[] endpoints;
            this._vcInstanceUuid = vcService.getServiceId();
            String viSite = vcService.getViSite();
            String prefix = viSite + ":";
            if (this._vcInstanceUuid.startsWith(prefix)) {
                int actualInstanceIdStartIndex = prefix.length();
                this._vcInstanceUuid = this._vcInstanceUuid.substring(actualInstanceIdStartIndex);
            }
            for (ServiceEndpoint serviceEndpoint : endpoints = vcService.getEndpoints()) {
                if (!serviceEndpoint.getUrl().toString().endsWith("/sdk") || !serviceEndpoint.getProtocol().equals("vmomi")) continue;
                this._vcSdkUri = serviceEndpoint.getUrl();
                break;
            }
        } else if (this._vcNodeId != null && (serviceInfo = this.lookupVcServiceForNodeId()) != null) {
            this._vcInstanceUuid = serviceInfo.getServiceId();
            this._vcSdkUri = serviceInfo.getServiceEndpoints()[0].getUrl();
        }
        if ((this._vcSdkUri == null || this._vcInstanceUuid == null) && _log.isDebugEnabled()) {
            _log.debug((Object)"VC service was not discovered. VimContext instance is not operational.");
        }
    }

    private Service lookupVcService() {
        if (this._isLegacyVim) {
            return null;
        }
        Service vcService = null;
        if (this._vcInstanceUuid != null || this._vcSdkUri != null) {
            try (LookupClient lookupClient = this._lookupClientBuilder.build();){
                if (this._vcInstanceUuid != null) {
                    vcService = VimContext.getVcServiceForServiceId(this._vcInstanceUuid, lookupClient);
                } else if (this._vcSdkUri != null) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)"Getting VC serice UUID from VC aboutInfo");
                    }
                    VcClient vcClient = this.getVcClientBuilder(false).build();
                    String vcInstanceUuid = vcClient.getServiceInstanceContent().getAbout().getInstanceUuid();
                    vcService = VimContext.getVcServiceForServiceId(vcInstanceUuid, lookupClient);
                }
            }
        }
        return vcService;
    }

    private static Service getVcServiceForServiceId(String vcServiceId, LookupClient lookupClient) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Looking for VC service by its UUID via LS1 API.");
        }
        try {
            LookupService lookupService = lookupClient.getLookupService();
            SearchCriteria searchCriteria = VimContext.createVcServiceSearchCriteria(lookupService);
            return VimContext.findVcServiceById(vcServiceId, lookupService, searchCriteria);
        }
        catch (ServiceFault e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Looking for VC service by its UUID via LS1 API failed.", (Throwable)e);
            }
            return null;
        }
    }

    private static Service findVcServiceById(String vcServiceId, LookupService lookupService, SearchCriteria searchCriteria) throws ServiceFault {
        Service[] services;
        Validate.notNull((Object)vcServiceId);
        Validate.notNull((Object)lookupService);
        Validate.notNull((Object)searchCriteria);
        for (Service service : services = lookupService.find(searchCriteria)) {
            if (!service.getServiceId().endsWith(vcServiceId)) continue;
            return service;
        }
        return null;
    }

    private ServiceRegistration.Info lookupVcServiceForNodeId() {
        LookupClientBuilder lookupClientBuilder;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Looking for VC service by nodeId via LS2 API.");
        }
        if ((lookupClientBuilder = this._lookupClientBuilder) == null || lookupClientBuilder.getVersion() == LookupClientBuilder.LEGACY_LOOKUP_VERSION_CLASS) {
            lookupClientBuilder = LookupClientBuilder.forLookupVersion(LookupClientBuilder.LATEST_LOOKUP_VERSION_CLASS, Executors.newSingleThreadExecutor()).withLookupSdkUri(this._lookupSdkUri).withTrust(this._vimTrustStore, this._vimThumbprintVerifier);
        }
        try (LookupClient lookupClient = lookupClientBuilder.build();){
            ServiceRegistration.Info info = VimContext.getVcServiceForNodeId(this._vcNodeId, lookupClient);
            return info;
        }
    }

    private static ServiceRegistration.Info getVcServiceForNodeId(String vcNodeId, LookupClient lookupClient) {
        ServiceRegistration.Endpoint[] endpoints;
        ServiceRegistration.Info[] serviceInfo = ServiceLocatorUtil.findServiceByServiceAndEndpointType(lookupClient, LS2_VC_SERVICE_TYPE, LS2_VC_SDK_ENDPOINT_TYPE, vcNodeId);
        if (serviceInfo != null && serviceInfo.length == 1 && (endpoints = serviceInfo[0].getServiceEndpoints()) != null && endpoints.length == 1) {
            return serviceInfo[0];
        }
        return null;
    }

    private static SearchCriteria createVcServiceSearchCriteria(LookupService lookupService) throws ServiceFault {
        SearchCriteria searchCriteria = new SearchCriteria();
        searchCriteria.setViSite(lookupService.getViSite());
        searchCriteria.setServiceType(LS1_VC_SERVICE_TYPE);
        return searchCriteria;
    }

    private static Class<?> getDesiredVersionClass(VcClient vcClient) {
        AboutInfo aboutInfo = vcClient.getServiceInstanceContent().getAbout();
        if (aboutInfo.getVersion().startsWith("4.0")) {
            return version5.class;
        }
        if (aboutInfo.getVersion().startsWith("4.1")) {
            return version6.class;
        }
        if (aboutInfo.getVersion().startsWith("5.0")) {
            return version7.class;
        }
        if (aboutInfo.getVersion().startsWith("5.1")) {
            return version8.class;
        }
        if (aboutInfo.getVersion().startsWith("5.5")) {
            return version9.class;
        }
        if (aboutInfo.getVersion().startsWith("6.0")) {
            return version10.class;
        }
        if (aboutInfo.getVersion().startsWith("6.5")) {
            return version1.class;
        }
        return version12.class;
    }

    static {
        try {
            LS1_VC_SERVICE_TYPE = new URI("urn:vc");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        LS2_VC_SERVICE_TYPE = new ServiceRegistration.ServiceType("com.vmware.cis", "vcenterserver");
        LS2_VC_SDK_ENDPOINT_TYPE = new ServiceRegistration.EndpointType("vmomi", "com.vmware.vim");
        DEFAULT_VC_VERSION_CLASS = version5.class;
    }
}

