/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vimcommon;

import com.vmware.ph.phservice.provider.common.Pair;
import com.vmware.vim.vmomi.core.types.ComplexType;
import com.vmware.vim.vmomi.core.types.ComplexTypeField;
import com.vmware.vim.vmomi.core.types.DataObjectType;
import com.vmware.vim.vmomi.core.types.ManagedMethod;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.ManagedProperty;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmodlUtil {
    public static final String PROPERTY_PATH_SEPARATOR = ".";
    private static final int DEFAULT_REFLECTION_LEVEL = 4;
    private static final Log _log = LogFactory.getLog(VmodlUtil.class);

    public static List<VmodlType> getVmodlTypesAssignableFromClass(Class<?> typeClass, VmodlTypeMap vmodlTypeMap) {
        ArrayList<VmodlType> resultVmodlTypes = new ArrayList<VmodlType>();
        for (VmodlType vmodlType : vmodlTypeMap.getVmodlTypes()) {
            if (!typeClass.isAssignableFrom(vmodlType.getTypeClass())) continue;
            resultVmodlTypes.add(vmodlType);
        }
        return resultVmodlTypes;
    }

    public static Map<VmodlType, Pair<VmodlType, String>> getRetrievalRulesForRelatedManagedObjects(List<VmodlType> startManagedObjectVmodlTypes, VmodlTypeMap vmodlTypeMap, VmodlVersion vmodlVersion) {
        LinkedHashMap<VmodlType, Pair<VmodlType, String>> managedObjectTypeToManagedEntityRule = new LinkedHashMap<VmodlType, Pair<VmodlType, String>>();
        for (VmodlType startManagedObjectVmodlType : startManagedObjectVmodlTypes) {
            managedObjectTypeToManagedEntityRule.put(startManagedObjectVmodlType, null);
            Map<VmodlType, String> managedObjectTypeToPath = VmodlUtil.getRelatedManagedObjectVmodlTypesAndPropertyPaths((ManagedObjectType)startManagedObjectVmodlType, 4, vmodlTypeMap, vmodlVersion);
            for (Map.Entry<VmodlType, String> entry : managedObjectTypeToPath.entrySet()) {
                VmodlType moType = entry.getKey();
                String path = entry.getValue();
                if (startManagedObjectVmodlTypes.contains(moType)) continue;
                managedObjectTypeToManagedEntityRule.put(moType, new Pair<VmodlType, String>(startManagedObjectVmodlType, path));
            }
        }
        return managedObjectTypeToManagedEntityRule;
    }

    public static List<VmodlType> getManagedObjectReferenceVmodlTypesInParentTypeProperties(ComplexType parentVmodlType) {
        LinkedList<VmodlType> vmodlTypes = new LinkedList<VmodlType>();
        for (ComplexTypeField declaredProperty : parentVmodlType.getDeclaredProperties()) {
            VmodlType propertyVmodlType = declaredProperty.getType();
            VmodlType.Kind propertyVmodlKind = propertyVmodlType.getKind();
            if (propertyVmodlKind != VmodlType.Kind.MOREF) continue;
            ManagedObjectType managedObjectType = (ManagedObjectType)declaredProperty.getManagedObjectType();
            vmodlTypes.add((VmodlType)managedObjectType);
        }
        return vmodlTypes;
    }

    public static Map<VmodlType, String> getRelatedManagedObjectVmodlTypesAndPropertyPaths(ManagedObjectType startManagedObjectVmodlType, int maxLevel, VmodlTypeMap vmodlTypeMap, VmodlVersion vmodlVersion) {
        return VmodlUtil.getRelatedManagedObjectTypeAndPropertyPathsInt((VmodlType)startManagedObjectVmodlType, null, 0, maxLevel, vmodlTypeMap, vmodlVersion);
    }

    public static List<ManagedMethod> getManagedMethods(ManagedObjectType managedObjectType, VmodlVersion vmodlVersion) {
        ManagedMethod[] objectMethods;
        LinkedList<ManagedMethod> managedMethods;
        block4: {
            managedMethods = new LinkedList<ManagedMethod>();
            objectMethods = null;
            try {
                objectMethods = managedObjectType.getMethods(false);
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block4;
                String msg = String.format("Error happened when processing all methods for %s", managedObjectType.getTypeName().toString());
                _log.debug((Object)msg, (Throwable)e);
            }
        }
        if (objectMethods == null) {
            return Collections.emptyList();
        }
        for (ManagedMethod managedMethod : objectMethods) {
            boolean isMethodSupported;
            boolean bl = isMethodSupported = vmodlVersion == null || vmodlVersion.isCompatible(managedMethod.getVersion());
            if (!isMethodSupported) continue;
            managedMethods.add(managedMethod);
        }
        return managedMethods;
    }

    public static List<String> getProperties(VmodlType vmodlType, int maxLevel, VmodlTypeMap vmodlTypeMap, VmodlVersion vmodlVersion) {
        return VmodlUtil.getPropertiesInt(vmodlType, null, 1, maxLevel, vmodlTypeMap, vmodlVersion);
    }

    private static Map<VmodlType, String> getRelatedManagedObjectTypeAndPropertyPathsInt(VmodlType vmodlType, String parentPropertyPath, int currentLevel, int maxLevel, VmodlTypeMap vmodlTypeMap, VmodlVersion vmodlVersion) {
        LinkedHashMap<VmodlType, String> resultProperties = new LinkedHashMap<VmodlType, String>();
        if (currentLevel == maxLevel) {
            return resultProperties;
        }
        ManagedProperty[] propertyFields = null;
        if (vmodlType instanceof ManagedObjectType) {
            ManagedObjectType moType = (ManagedObjectType)vmodlType;
            propertyFields = moType.getManagedProperties();
        } else if (vmodlType instanceof DataObjectType) {
            DataObjectType doType = (DataObjectType)vmodlType;
            propertyFields = doType.getProperties();
        }
        if (propertyFields == null) {
            return resultProperties;
        }
        for (ManagedProperty propertyField : propertyFields) {
            if (vmodlVersion != null && !vmodlVersion.isCompatible(propertyField.getVersion())) continue;
            String propertyPath = propertyField.getName();
            if (parentPropertyPath != null) {
                propertyPath = parentPropertyPath + PROPERTY_PATH_SEPARATOR + propertyPath;
            }
            VmodlType propertyVmodlType = null;
            if (propertyField instanceof ComplexTypeField) {
                try {
                    propertyVmodlType = ((ComplexTypeField)propertyField).getManagedObjectType();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (propertyVmodlType == null) {
                VmodlType vmodlType2 = propertyVmodlType = propertyField.isLink() ? propertyField.getLinkType() : propertyField.getType();
            }
            if (propertyVmodlType instanceof ManagedObjectType) {
                resultProperties.put(propertyVmodlType, propertyPath);
                continue;
            }
            Map<VmodlType, String> subProperies = VmodlUtil.getRelatedManagedObjectTypeAndPropertyPathsInt(propertyVmodlType, propertyPath, currentLevel + 1, maxLevel, vmodlTypeMap, vmodlVersion);
            resultProperties.putAll(subProperies);
        }
        return resultProperties;
    }

    private static List<String> getPropertiesInt(VmodlType vmodlType, String parentProperty, int currentLevel, int maxLevel, VmodlTypeMap vmodlTypeMap, VmodlVersion vmodlVersion) {
        LinkedList<String> resultProperties;
        block8: {
            resultProperties = new LinkedList<String>();
            try {
                ManagedProperty[] propertyFields = null;
                if (vmodlType instanceof ManagedObjectType) {
                    ManagedObjectType moType = (ManagedObjectType)vmodlType;
                    propertyFields = moType.getManagedProperties();
                } else if (vmodlType instanceof DataObjectType) {
                    DataObjectType daType = (DataObjectType)vmodlType;
                    propertyFields = daType.getProperties();
                }
                if (propertyFields == null) {
                    return Collections.emptyList();
                }
                for (ManagedProperty propertyField : propertyFields) {
                    if (vmodlVersion != null && !vmodlVersion.isCompatible(propertyField.getVersion())) continue;
                    String propertyName = propertyField.getName();
                    if (parentProperty != null) {
                        propertyName = parentProperty + "/" + propertyName;
                    }
                    resultProperties.add(propertyName);
                    if (currentLevel >= maxLevel) continue;
                    VmodlType propertyVmodlType = propertyField.isLink() ? propertyField.getLinkType() : propertyField.getType();
                    List<String> subProperies = VmodlUtil.getPropertiesInt(propertyVmodlType, propertyName, currentLevel + 1, maxLevel, vmodlTypeMap, vmodlVersion);
                    resultProperties.addAll(subProperies);
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block8;
                String msg = String.format("Error happened when processing all properties for %s", vmodlType.getTypeName().toString());
                _log.debug((Object)msg, (Throwable)e);
            }
        }
        Collections.sort(resultProperties);
        return resultProperties;
    }
}

