/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vimcommon.mo;

import com.vmware.ph.phservice.provider.common.QuerySchemaUtil;
import java.util.ArrayList;
import java.util.List;

public final class MethodNameToQueryPropertyConverter {
    private static final String NOT_METHOD_QUERY_PROPERTY_ERR_MSG = "The given argument [%s] is not a method property.";
    private static final String METHOD_QUERY_PROPERTY_PREFIX = "m_";
    private static final int METHOD_PROPERTY_PREFIX_LENGTH = "m_".length();

    private MethodNameToQueryPropertyConverter() {
    }

    public static String toMethodQueryProperty(String methodName) {
        return METHOD_QUERY_PROPERTY_PREFIX + methodName;
    }

    public static List<String> toMethodNames(List<String> queryProperties) {
        ArrayList<String> methodNames = new ArrayList<String>(queryProperties.size());
        for (String queryProperty : queryProperties) {
            if (QuerySchemaUtil.isQueryPropertyModelKey(queryProperty)) continue;
            methodNames.add(MethodNameToQueryPropertyConverter.toMethodName(queryProperty));
        }
        return methodNames;
    }

    public static String toMethodName(String methodQueryProperty) {
        if (!MethodNameToQueryPropertyConverter.isMethodQueryProperty(methodQueryProperty)) {
            throw new IllegalArgumentException(String.format(NOT_METHOD_QUERY_PROPERTY_ERR_MSG, methodQueryProperty));
        }
        return methodQueryProperty.substring(METHOD_PROPERTY_PREFIX_LENGTH);
    }

    public static boolean isMethodQueryProperty(String property) {
        return property.startsWith(METHOD_QUERY_PROPERTY_PREFIX) && property.length() > METHOD_PROPERTY_PREFIX_LENGTH;
    }
}

