/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vimcommon.util;

import com.vmware.cis.data.api.ResultSet;
import com.vmware.ph.phservice.provider.common.DataRetriever;
import com.vmware.ph.phservice.provider.common.QuerySchemaUtil;
import com.vmware.ph.phservice.provider.vimcommon.VimResourceItem;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VimDataProviderUtil {
    private static final Log log = LogFactory.getLog(VimDataProviderUtil.class);
    private static final String MODEL_KEY_PATTERN = "%s:%s";
    private static final String MODEL_KEY_PREFIX = "@";

    public static List<VimResourceItem> getVimResourceItems(List<String> propertiesNames, DataRetriever dataRetriever) {
        List<Object> vimDataList = dataRetriever.retrieveData();
        List<String> nonQualifiedProperties = QuerySchemaUtil.getNonQualifiedPropertyNames(propertiesNames);
        return VimDataProviderUtil.getVimResourceItems(vimDataList, nonQualifiedProperties, dataRetriever);
    }

    public static List<VimResourceItem> getVimResourceItems(List<Object> vimDataList, List<String> supportedNonQualifiedQueryProperties, DataRetriever dataRetriever) {
        ArrayList<VimResourceItem> retrievedResourceItemList = new ArrayList<VimResourceItem>();
        for (Object data : vimDataList) {
            ArrayList<Object> propertyValues = new ArrayList<Object>();
            URI objectUri = VimDataProviderUtil.createModelKey(data.getClass(), dataRetriever.getKey(data));
            propertyValues.add(objectUri);
            for (String property : supportedNonQualifiedQueryProperties) {
                if (property.startsWith(MODEL_KEY_PREFIX)) continue;
                Object propertyValue = VimDataProviderUtil.getPropertyValue(data, property);
                propertyValues.add(propertyValue);
            }
            VimResourceItem item = new VimResourceItem(propertyValues);
            retrievedResourceItemList.add(item);
        }
        return retrievedResourceItemList;
    }

    public static ResultSet convertVimResourceItemsToResultSet(List<VimResourceItem> vimResourceItems, List<String> queryPropertyNames) {
        ResultSet.Builder resultSetBuilder = ResultSet.Builder.properties(queryPropertyNames);
        for (VimResourceItem vimResourceItem : vimResourceItems) {
            List<Object> vimResItemPropValues = vimResourceItem.getPropertyValues();
            if (queryPropertyNames.size() != vimResItemPropValues.size()) {
                throw new IllegalArgumentException("Invalid query properties.");
            }
            Object key = vimResItemPropValues.get(0);
            resultSetBuilder.item(key, vimResItemPropValues);
        }
        ResultSet resultSet = resultSetBuilder.build();
        return resultSet;
    }

    public static ResultSet convertVimResourceItemsToResultSet(List<VimResourceItem> vimResourceItems, List<String> queryPropertyNames, List<String> supportedNonQualifiedQueryProperties) {
        ResultSet.Builder resultSetBuilder = ResultSet.Builder.properties(queryPropertyNames);
        for (VimResourceItem vimResourceItem : vimResourceItems) {
            List<Object> vimResItemPropValues = vimResourceItem.getPropertyValues();
            if (supportedNonQualifiedQueryProperties.size() != vimResItemPropValues.size()) {
                throw new IllegalArgumentException("Invalid query properties.");
            }
            ArrayList<Object> queryResultItem = new ArrayList<Object>();
            int supportedPropertyIndex = 0;
            for (String queryPropertyName : queryPropertyNames) {
                if (!supportedNonQualifiedQueryProperties.contains(QuerySchemaUtil.getActualPropertyName(queryPropertyName))) {
                    queryResultItem.add(null);
                    continue;
                }
                queryResultItem.add(vimResItemPropValues.get(supportedPropertyIndex));
                ++supportedPropertyIndex;
            }
            Object key = queryResultItem.get(0);
            resultSetBuilder.item(key, queryResultItem);
        }
        ResultSet resultSet = resultSetBuilder.build();
        return resultSet;
    }

    public static URI createModelKey(Class<?> objectClass, String objectKey) {
        String modelKey = String.format(MODEL_KEY_PATTERN, objectClass.getSimpleName(), objectKey);
        String validModelKey = VimDataProviderUtil.convertToValidModelKey(modelKey);
        return URI.create(validModelKey);
    }

    public static URI createModelKey(String objectType, String objectKey) {
        String modelKey = String.format(MODEL_KEY_PATTERN, objectType, objectKey);
        String validModelKey = VimDataProviderUtil.convertToValidModelKey(modelKey);
        return URI.create(validModelKey);
    }

    public static URI createManagedObjectModelKey(ManagedObject managedObject) {
        ManagedObjectReference moRef = managedObject._getRef();
        return VimDataProviderUtil.createModelKey(moRef.getType(), moRef.getServerGuid());
    }

    public static Map<String, Object> getMethodInvocationReturnValues(Object targetObject, List<String> methodsToInvoke) {
        HashMap<String, Object> methodValues = new HashMap<String, Object>();
        for (String methodName : methodsToInvoke) {
            try {
                Method method = targetObject.getClass().getMethod(methodName, new Class[0]);
                Object invocationResult = method.invoke(targetObject, new Object[0]);
                methodValues.put(methodName, invocationResult);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException(e);
            }
        }
        return methodValues;
    }

    public static List<Object> getPropertyValuesForPropertiesOfKind(Object object, VmodlTypeMap vmodlTypeMap, VmodlType.Kind vmodlKind) {
        Field[] declaredFields;
        LinkedList<Object> propertyValues = new LinkedList<Object>();
        for (Field declaredField : declaredFields = object.getClass().getDeclaredFields()) {
            VmodlType fieldVmodlType = vmodlTypeMap.getVmodlType(declaredField.getType());
            if (fieldVmodlType.getKind() != vmodlKind) continue;
            Object propertyValue = VimDataProviderUtil.getPropertyValue(object, declaredField.getName());
            propertyValues.add(propertyValue);
        }
        return propertyValues;
    }

    public static List<Object> getPropertyValues(Object vmodlObject, Object objectModelKey, List<String> properties) {
        ArrayList<Object> propertyValues = new ArrayList<Object>(properties.size());
        propertyValues.add(objectModelKey);
        for (String property : properties) {
            if (property.startsWith(MODEL_KEY_PREFIX)) continue;
            Object propertyValue = VimDataProviderUtil.getPropertyValue(vmodlObject, property);
            propertyValues.add(propertyValue);
        }
        return propertyValues;
    }

    public static Object getPropertyValue(Object vmodlObject, String propertyName) {
        String className = vmodlObject.getClass().getSimpleName();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Getting property : " + propertyName + " from " + className + " object"));
        }
        int index = propertyName.indexOf("/");
        try {
            if (index != -1) {
                String basePropertyName = propertyName.substring(0, index);
                Object basePropertyValue = VimDataProviderUtil.getPropertyValueViaAccessor(vmodlObject, basePropertyName);
                if (basePropertyValue != null) {
                    String subPropertyName = propertyName.substring(index + 1);
                    return VimDataProviderUtil.getPropertyValue(basePropertyValue, subPropertyName);
                }
                return null;
            }
            Object result = VimDataProviderUtil.getPropertyValueViaAccessor(vmodlObject, propertyName);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Got property : " + propertyName + " from " + className + " object"));
            }
            return result;
        }
        catch (IllegalArgumentException | SecurityException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error occured while trying to get " + propertyName + " from " + className + " object."));
                log.debug((Object)e.getMessage());
            }
            return null;
        }
    }

    private static Object getPropertyValueViaAccessor(Object vmodlObject, String propertyName) {
        Object propertyValue;
        block7: {
            String capitalizedPropertyName = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
            String[] possibleMethodNames = new String[]{"get" + capitalizedPropertyName, "is" + capitalizedPropertyName};
            Method accessorMethod = null;
            for (String possibleMethodName : possibleMethodNames) {
                try {
                    accessorMethod = vmodlObject.getClass().getMethod(possibleMethodName, new Class[0]);
                    break;
                }
                catch (NoSuchMethodException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("No accessor method could be found for property " + propertyName), (Throwable)e);
                }
                catch (SecurityException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Security restrictions do not allow accessor method discovery for object " + vmodlObject.getClass().getName()), (Throwable)e);
                }
            }
            propertyValue = null;
            if (accessorMethod != null) {
                try {
                    propertyValue = accessorMethod.invoke(vmodlObject, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug((Object)("Failed to invoke accessor method for property " + propertyName), (Throwable)e);
                }
            }
        }
        return propertyValue;
    }

    private static String convertToValidModelKey(String modelKey) {
        return modelKey.replaceAll("[^a-zA-Z0-9-]+", ":");
    }
}

