/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vimcommon.vc;

import com.vmware.ph.phservice.ciscommon.sso.SsoTokenProvider;
import com.vmware.ph.phservice.provider.common.Builder;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.ph.phservice.provider.vimcommon.vc.impl.VcClientFactoryImpl;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import java.net.URI;
import java.security.KeyStore;
import java.util.concurrent.ExecutorService;

public class VcClientBuilder
implements Builder<VcClient> {
    private final VcClientFactoryImpl _vcClientFactory;
    private URI _vcSdkEndpoint;
    private SsoTokenProvider _ssoTokenProvider;
    private String _vcUsername;
    private char[] _vcPassword;

    public static VcClientBuilder forVcVersion(Class<?> versionClass, ExecutorService threadPool) {
        return new VcClientBuilder(versionClass, threadPool);
    }

    private VcClientBuilder(Class<?> versionClass, ExecutorService threadPool) {
        this._vcClientFactory = new VcClientFactoryImpl("vim25", versionClass, threadPool);
        this._vcClientFactory.setTimeoutMs(180000);
    }

    public VcClientBuilder withVcSdkUri(URI vcSdkUri) {
        this._vcSdkEndpoint = vcSdkUri;
        return this;
    }

    public VcClientBuilder withTrust(KeyStore trustStore, ThumbprintVerifier thumbprintVerifier) {
        this._vcClientFactory.setTrustStore(trustStore);
        this._vcClientFactory.setThumbprintVerifier(thumbprintVerifier);
        return this;
    }

    public VcClientBuilder withSsoTokenProvider(SsoTokenProvider ssoTokenProvider) {
        this._ssoTokenProvider = ssoTokenProvider;
        return this;
    }

    public VcClientBuilder withVcCredentials(String vcUsername, char[] vcPassword) {
        this._vcUsername = vcUsername;
        this._vcPassword = vcPassword;
        return this;
    }

    @Override
    public VcClient build() {
        VcClient vcClient = null;
        vcClient = this._ssoTokenProvider != null ? this._vcClientFactory.connectVcWithSamlToken(this._vcSdkEndpoint, this._ssoTokenProvider, null) : (this._vcUsername != null ? this._vcClientFactory.connectVcAsUser(this._vcSdkEndpoint, this._vcUsername, this._vcPassword, null) : this._vcClientFactory.connectVcAnnonymous(this._vcSdkEndpoint, null));
        return vcClient;
    }
}

