/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vimcommon.vc.impl;

import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.vim.binding.vim.InternalServiceInstanceContent;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.SessionManager;
import com.vmware.vim.binding.vim.fault.NotAuthenticated;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.VmomiService;
import com.vmware.vim.vmomi.core.types.impl.VmomiServiceImpl;
import java.net.URI;

public class VcClientImpl
implements VcClient {
    private final Client _vmomiClient;
    private final Class<?> _versionClass;
    private final VmodlContext _vmodlContext;
    private VmomiService _vmomiService;
    private final Object _lock = new Object();
    private ServiceInstanceContent _serviceInstanceContent;
    private InternalServiceInstanceContent _internalServiceInstanceContent;

    VcClientImpl(Client vmomiClient, String namespace, Class<?> versionClass, VmodlContext vmodlContext) {
        this._vmomiClient = vmomiClient;
        this._versionClass = versionClass;
        if (namespace != null) {
            this._vmomiService = new VmomiServiceImpl("service-" + namespace, namespace);
        }
        this._vmodlContext = vmodlContext;
    }

    @Override
    public Client getVlsiClient() {
        return this._vmomiClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            try {
                this.getSessionManager().logout();
            }
            catch (NotAuthenticated notAuthenticated) {
                // empty catch block
            }
        }
        finally {
            this._vmomiClient.shutdown();
        }
    }

    @Override
    public VmodlVersion getVmodlVersion() {
        return this._vmodlContext.getVmodlVersionMap().getVersion(this._versionClass);
    }

    @Override
    public VmodlContext getVmodlContext() {
        return this._vmodlContext;
    }

    @Override
    public URI getServiceUri() {
        return this._vmomiClient.getBinding().getEndpointUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceInstanceContent getServiceInstanceContent() {
        Object object = this._lock;
        synchronized (object) {
            if (this._serviceInstanceContent == null) {
                ServiceInstance serviceInstance = this.createServiceInstanceStub();
                this._serviceInstanceContent = serviceInstance.retrieveContent();
            }
        }
        return this._serviceInstanceContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalServiceInstanceContent getInternalServiceInstanceContent() {
        Object object = this._lock;
        synchronized (object) {
            if (this._internalServiceInstanceContent == null) {
                ServiceInstance serviceInstance = this.createServiceInstanceStub();
                this._internalServiceInstanceContent = serviceInstance.retrieveInternalContent();
            }
        }
        return this._internalServiceInstanceContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionManager getSessionManager() {
        SessionManager sessionManager = null;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            sessionManager = (SessionManager)this._vmomiClient.createStub(SessionManager.class, this.getServiceInstanceContent().getSessionManager());
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return sessionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ManagedObject> T createMo(ManagedObjectReference moRef) {
        VmodlType vmodlType = null;
        vmodlType = this._vmomiService != null ? this._vmodlContext.getVmodlTypeMap().getVmodlType(moRef.getType(), this._vmomiService) : this._vmodlContext.getVmodlTypeMap().getVmodlType(moRef.getType());
        Class typeClass = vmodlType.getTypeClass();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            ManagedObject managedObject = this._vmomiClient.createStub(typeClass, moRef);
            return (T)managedObject;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceInstance createServiceInstanceStub() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            ServiceInstance serviceInstance = (ServiceInstance)this._vmomiClient.createStub(ServiceInstance.class, SERVICE_INSTANCE_MOREF);
            return serviceInstance;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }
}

