/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.proxy;

import com.vmware.ph.client.api.util.Util;
import com.vmware.ph.common.net.HttpConnectionConfig;
import com.vmware.ph.common.net.ProxySettings;
import com.vmware.ph.common.net.ProxySettingsProvider;
import com.vmware.ph.phservice.proxy.INIConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VsanProxySettingsProvider
implements ProxySettingsProvider {
    private static final Log _log = LogFactory.getLog(VsanProxySettingsProvider.class);

    public ProxySettings getProxySettings(HttpConnectionConfig connConfig) {
        ProxySettings proxySettings;
        String vsanCfgFilePath = VsanProxySettingsProvider.getVsanConfigFilePath();
        if (vsanCfgFilePath == null) {
            _log.warn((Object)"Unable to locate VSAN config file!");
            return null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Reading VSAN config file from following location: " + vsanCfgFilePath));
        }
        if ((proxySettings = VsanProxySettingsProvider.loadProxySettingsFromConfigFile(vsanCfgFilePath)) == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"No VSAN proxy settings found!");
            }
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)("Found VSAN proxy settings: " + proxySettings));
        }
        return proxySettings;
    }

    static final String getVsanConfigFilePath() {
        String configDirPath = null;
        if (SystemUtils.IS_OS_WINDOWS) {
            String cisCfgDir = System.getenv("VMWARE_CFG_DIR");
            if (!Util.isBlank((CharSequence)cisCfgDir)) {
                configDirPath = Paths.get(cisCfgDir, "vsan-health").toString();
            } else {
                _log.warn((Object)"Missing VMWARE_CFG_DIR environment variable!");
            }
        } else {
            configDirPath = "/etc/vmware-vsan-health";
        }
        String vsanCfgFilePath = null;
        if (configDirPath != null) {
            vsanCfgFilePath = Paths.get(configDirPath, "config.conf").toString();
        }
        return vsanCfgFilePath;
    }

    static final ProxySettings loadProxySettingsFromConfigFile(String configFilePath) {
        ProxySettings proxySettings = null;
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(new File(configFilePath)), StandardCharsets.UTF_8);){
            proxySettings = VsanProxySettingsProvider.loadProxySettingsFromConfigFileReader(reader);
        }
        catch (IOException e) {
            _log.warn((Object)"Unable to load vsan proxy settings!");
        }
        return proxySettings;
    }

    static final ProxySettings loadProxySettingsFromConfigFileReader(Reader reader) throws IOException {
        INIConfiguration iniConfiguration = new INIConfiguration();
        iniConfiguration.load(reader);
        ProxySettings proxySettings = VsanProxySettingsProvider.loadProxySettingsFromINIConfiguration(iniConfiguration);
        return proxySettings;
    }

    static final ProxySettings loadProxySettingsFromINIConfiguration(INIConfiguration iniConfiguration) {
        String proxyHost = iniConfiguration.getValue("PhoneHome", "proxyHost");
        String proxyPort = iniConfiguration.getValue("PhoneHome", "proxyPort");
        String proxyUser = iniConfiguration.getValue("PhoneHome", "proxyUser");
        String proxyPassword = iniConfiguration.getValue("PhoneHome", "proxyPassword");
        if (Util.isBlank((CharSequence)proxyHost) || Util.isBlank((CharSequence)proxyPort)) {
            return null;
        }
        int port = 0;
        try {
            port = Integer.parseInt(proxyPort);
        }
        catch (NumberFormatException e) {
            _log.warn((Object)("Incorrect port specified in vsan proxy settings: " + proxyPort + "!"));
            return null;
        }
        ProxySettings proxySettings = new ProxySettings(proxyHost, port, proxyUser, proxyPassword);
        return proxySettings;
    }
}

