/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.vapicommon.util;

import java.net.URI;
import org.apache.commons.lang.StringUtils;

public final class VapiUriSchemeUtil {
    private static final String URI_PREFIX = "urn:vapi:";
    private static final char PACKAGE_SEPARATOR = '.';
    private static final char TYPE_SEPARATOR = ':';

    public static URI createUri(String type, String id) {
        if (StringUtils.isBlank((String)type)) {
            throw new IllegalArgumentException("Resource type must not be null or empty");
        }
        if (type.indexOf(58) >= 0) {
            throw new IllegalArgumentException(String.format("Resource type must not contain colons: '%s'", type));
        }
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("vAPI ID must not be null or empty");
        }
        if (type.indexOf(46) <= 0) {
            throw new IllegalArgumentException(String.format("Cannot create an URI resource reference for a VMODL1 resource type (i.e. resource type is not qualified with package name): '%s'", type));
        }
        return URI.create(URI_PREFIX + type + ':' + id);
    }

    public static String getId(URI uri) {
        VapiUriSchemeUtil.validateVapiUri(uri);
        String uriString = uri.toString();
        int typeSeparatorIndex = VapiUriSchemeUtil.getTypeSeparatorIndex(uriString);
        return uriString.substring(typeSeparatorIndex + 1);
    }

    public static String getType(URI uri) {
        VapiUriSchemeUtil.validateVapiUri(uri);
        String uriString = uri.toString();
        int typeSeparatorIndex = VapiUriSchemeUtil.getTypeSeparatorIndex(uriString);
        return uriString.substring(URI_PREFIX.length(), typeSeparatorIndex);
    }

    public static boolean isVapiUri(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI must not be null");
        }
        return uri.toString().startsWith(URI_PREFIX);
    }

    private static void validateVapiUri(URI uri) {
        if (!VapiUriSchemeUtil.isVapiUri(uri)) {
            throw new IllegalArgumentException("Not a vAPI URI: " + uri.toString());
        }
    }

    private static int getTypeSeparatorIndex(String vapiUriString) {
        int typeSeparatorIndex = vapiUriString.indexOf(58, URI_PREFIX.length());
        if (typeSeparatorIndex < 0 || typeSeparatorIndex >= vapiUriString.length() - 1) {
            throw new IllegalArgumentException("Invalid vAPI URI: " + vapiUriString);
        }
        return typeSeparatorIndex;
    }
}

