/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.vmomicommon;

import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.util.HashSet;
import java.util.Set;

public class VersionFinder {
    private final VmodlContext _vmodlContext;

    public VersionFinder(VmodlContext vmodlContext) {
        this._vmodlContext = vmodlContext;
    }

    public VmodlVersion findVersion(Class<?> versionType) {
        return this._vmodlContext.getVmodlVersionMap().getVersion(versionType);
    }

    public Set<VmodlVersion> getCompatible(VmodlVersion vmodlVersion) {
        return this.getCompatible(vmodlVersion, vmodlVersion.getNamespace());
    }

    private Set<VmodlVersion> getCompatible(VmodlVersion vmodlVersion, String versionNamespace) {
        HashSet<VmodlVersion> compatibleVersions = new HashSet<VmodlVersion>();
        VmodlVersion internalVmodlVersion = null;
        if (!vmodlVersion.isInternal()) {
            String internalClassName = String.format("%1$s.internal.%2$s", vmodlVersion.getVersionClass().getPackage().getName(), vmodlVersion.getVersionClass().getSimpleName());
            try {
                Class<?> internalVersionType = Class.forName(internalClassName);
                internalVmodlVersion = this.findVersion(internalVersionType);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (vmodlVersion.getNamespace().equals(versionNamespace)) {
            compatibleVersions.add(vmodlVersion);
            if (internalVmodlVersion != null) {
                compatibleVersions.add(internalVmodlVersion);
            }
            Set vmodlParents = vmodlVersion.getParentVersion();
            for (VmodlVersion parent : vmodlParents) {
                compatibleVersions.addAll(this.getCompatible(parent, versionNamespace));
            }
        }
        return compatibleVersions;
    }
}

