/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.vmomicommon.client.impl;

import com.vmware.ph.phservice.vmomicommon.client.AuthenticationHelper;
import com.vmware.ph.phservice.vmomicommon.client.VmomiClient;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.VmomiService;
import com.vmware.vim.vmomi.core.types.impl.VmomiServiceImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Objects;

public class VmomiClientImpl
implements VmomiClient {
    private final Class<?> _versionClass;
    private final VmodlContext _vmodlContext;
    private final AuthenticationHelper _authenticationHelper;
    private final VmomiService _vmomiService;
    private final Client _vmomiClient;

    public VmomiClientImpl(URI endpointUri, Class<?> versionClass, HttpClientConfiguration httpClientConfiguration, VmodlContext vmodlContext) {
        this(endpointUri, versionClass, httpClientConfiguration, vmodlContext, null);
    }

    public VmomiClientImpl(URI endpointUri, Class<?> versionClass, HttpClientConfiguration httpClientConfiguration, VmodlContext vmodlContext, String namespace) {
        this(endpointUri, versionClass, httpClientConfiguration, vmodlContext, namespace, null);
    }

    public VmomiClientImpl(URI endpointUri, Class<?> versionClass, HttpClientConfiguration httpClientConfiguration, VmodlContext vmodlContext, String namespace, AuthenticationHelper authenticationHelper) {
        Objects.requireNonNull(endpointUri);
        this._versionClass = Objects.requireNonNull(versionClass);
        Objects.requireNonNull(httpClientConfiguration);
        this._vmodlContext = Objects.requireNonNull(vmodlContext);
        this._vmomiService = namespace != null ? new VmomiServiceImpl("service-" + namespace, namespace) : null;
        this._vmomiClient = Client.Factory.createClient((URI)endpointUri, versionClass, (VmodlContext)vmodlContext, (ClientConfiguration)httpClientConfiguration);
        this._authenticationHelper = authenticationHelper;
    }

    @Override
    public Client getVlsiClient() {
        return this._vmomiClient;
    }

    @Override
    public void close() {
        this._vmomiClient.shutdown();
    }

    @Override
    public VmodlVersion getVmodlVersion() {
        return this._vmodlContext.getVmodlVersionMap().getVersion(this._versionClass);
    }

    @Override
    public VmodlContext getVmodlContext() {
        return this._vmodlContext;
    }

    @Override
    public URI getServiceUri() {
        return this._vmomiClient.getBinding().getEndpointUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ManagedObject> T createStub(ManagedObjectReference moRef) throws Exception {
        VmodlType vmodlType = null;
        vmodlType = this._vmomiService != null ? this._vmodlContext.getVmodlTypeMap().getVmodlType(moRef.getType(), this._vmomiService) : this._vmodlContext.getVmodlTypeMap().getVmodlType(moRef.getType());
        Class typeClass = vmodlType.getTypeClass();
        ManagedObject mo = null;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            mo = this._vmomiClient.createStub(typeClass, moRef);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        mo = VmomiClientImpl.decorateStubWithAuthentication(mo, typeClass, this._authenticationHelper);
        return (T)mo;
    }

    private static <T extends ManagedObject> T decorateStubWithAuthentication(T originalStub, Class<T> stubTypeClass, AuthenticationHelper authenticationHelper) {
        Object decoratedStub = originalStub;
        if (authenticationHelper != null) {
            AuthenicatedStubInvocationHandler stubInvocationHandler = new AuthenicatedStubInvocationHandler((Stub)originalStub, authenticationHelper);
            decoratedStub = (ManagedObject)Proxy.newProxyInstance(stubTypeClass.getClassLoader(), new Class[]{stubTypeClass}, (InvocationHandler)stubInvocationHandler);
        }
        return decoratedStub;
    }

    private static class AuthenicatedStubInvocationHandler
    implements InvocationHandler {
        private final Stub _stub;
        private final AuthenticationHelper _authenticationHelper;

        public AuthenicatedStubInvocationHandler(Stub stub, AuthenticationHelper authenticationHelper) {
            this._stub = Objects.requireNonNull(stub);
            this._authenticationHelper = Objects.requireNonNull(authenticationHelper);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            this._authenticationHelper.addAuthenticationContext(this._stub);
            Object invoationResult = method.invoke((Object)this._stub, args);
            return invoationResult;
        }
    }
}

