/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcaddons.impl;

import com.vmware.vim.binding.vim.Extension;
import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.XMLUtil;
import com.vmware.vsphere.client.vcaddons.model.HostLogInfo;
import com.vmware.vsphere.client.vcaddons.model.SysLogCollectorConfiguration;
import com.vmware.vsphere.client.vcaddons.util.Util;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SysLogCollectorPropertyProviderImpl
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(SysLogCollectorPropertyProviderImpl.class);

    @type(value="Folder")
    public SysLogCollectorConfiguration getSysLogCollectorConfiguration(ManagedObjectReference serverObj) {
        String sysLogModifiedURL = null;
        URL sysLogURL = null;
        String serverGuid = serverObj.getServerGuid();
        Extension.ServerInfo si = Util.getServerInfo(serverGuid, "com.vmware.syslog");
        if (si == null) {
            _logger.error((Object)("Missing com.vmware.vim.viClientScripts serverInfo in SysLogCollector extension for server " + serverGuid));
            return null;
        }
        sysLogModifiedURL = si.getUrl().replace("extension.xml", "");
        try {
            sysLogURL = new URL(sysLogModifiedURL);
        }
        catch (MalformedURLException e) {
            _logger.error((Object)e);
            return null;
        }
        String response = Util.executeRequest(sysLogURL, null, null, null);
        return this.parseSysLogCollectorConfiguration(response);
    }

    @type(value="Folder")
    public Boolean getSysLogCollectorExtensionInstalled(ManagedObjectReference serverObj) {
        String serverGuid = serverObj.getServerGuid();
        return Util.isExtensionInstalled(serverGuid, "com.vmware.syslog");
    }

    private SysLogCollectorConfiguration parseSysLogCollectorConfiguration(String sysLogCollectorConfigXmlStr) {
        SysLogCollectorConfiguration sysLogCollectorConfig = new SysLogCollectorConfiguration();
        Document xmlDocument = null;
        xmlDocument = XMLUtil.parseXml((String)sysLogCollectorConfigXmlStr);
        if (xmlDocument == null) {
            return null;
        }
        Element root = xmlDocument.getDocumentElement();
        NodeList children = root.getChildNodes();
        ArrayList<KeyValue> propertyList = new ArrayList<KeyValue>();
        ArrayList<KeyValue> listeningPorts = new ArrayList<KeyValue>();
        ArrayList<HostLogInfo> hostLoggingInfoList = new ArrayList<HostLogInfo>();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals("property")) {
                String propertyName = XMLUtil.getChildTagValue((Node)child, (String)"name");
                String propertyValue = XMLUtil.getChildTagValue((Node)child, (String)"value");
                KeyValue kvi = new KeyValue();
                kvi.key = propertyName;
                kvi.value = propertyValue;
                propertyList.add(kvi);
                continue;
            }
            if (child.getNodeType() == 1 && child.getNodeName().equals("listeningonport")) {
                List portElements = XMLUtil.getChildTags((Node)child, (String)"port");
                int k = portElements.size();
                for (int j = 0; j < k; ++j) {
                    Node port = (Node)portElements.get(j);
                    String portName = XMLUtil.getChildTagValue((Node)port, (String)"name");
                    String portValue = XMLUtil.getChildTagValue((Node)port, (String)"value");
                    KeyValue kvi = new KeyValue();
                    kvi.key = portName;
                    kvi.value = portValue;
                    listeningPorts.add(kvi);
                }
                continue;
            }
            if (child.getNodeType() != 1 || !child.getNodeName().equals("hostlogs")) continue;
            List hostlogElements = XMLUtil.getChildTags((Node)child, (String)"hostlog");
            int k = hostlogElements.size();
            for (int j = 0; j < k; ++j) {
                Node hostInfo = (Node)hostlogElements.get(j);
                String hostAddress = XMLUtil.getChildTagValue((Node)hostInfo, (String)"host");
                String logLocation = XMLUtil.getChildTagValue((Node)hostInfo, (String)"loglocation");
                String logSize = XMLUtil.getChildTagValue((Node)hostInfo, (String)"logsize");
                HostLogInfo hli = new HostLogInfo();
                hli.hostAddress = hostAddress;
                hli.logLocation = logLocation;
                hli.logSize = logSize;
                hostLoggingInfoList.add(hli);
            }
        }
        sysLogCollectorConfig.propertyList = propertyList.toArray(new KeyValue[propertyList.size()]);
        sysLogCollectorConfig.listeningPorts = listeningPorts.toArray(new KeyValue[listeningPorts.size()]);
        sysLogCollectorConfig.hostLoggingInfoList = hostLoggingInfoList.toArray(new HostLogInfo[hostLoggingInfoList.size()]);
        return sysLogCollectorConfig;
    }
}

