/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.impl;

import com.vmware.opsmgmt.client.alarms.AlarmAcknowledgementSpec;
import com.vmware.opsmgmt.client.alarms.AlarmStatusSpec;
import com.vmware.opsmgmt.client.alarms.EnableAlarmActionsSpec;
import com.vmware.opsmgmt.client.alarms.NewAlarmDefinitionSpec;
import com.vmware.opsmgmt.client.alarms.RemoveAlarmDefinitionSpec;
import com.vmware.opsmgmt.client.alarms.util.AlarmUtil;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.alarm.Alarm;
import com.vmware.vim.binding.vim.alarm.AlarmManager;
import com.vmware.vim.binding.vim.alarm.AlarmSpec;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.liveupdates.LiveUpdatesUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.messaging.MutationOperationUpdatePublisher;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.commons.messaging.PartialUpdateItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlarmMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(AlarmMutationProvider.class);
    private ConfigurationService _configurationService;
    private MutationOperationUpdatePublisher _mutationOperationUpdatePublisher;

    public void setConfigurationService(ConfigurationService configurationService) {
        this._configurationService = configurationService;
    }

    public void setMutationOperationUpdatePublisher(MutationOperationUpdatePublisher mutationOperationUpdatePublisher) {
        this._mutationOperationUpdatePublisher = mutationOperationUpdatePublisher;
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, AlarmAcknowledgementSpec alarmAcknowledgementSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            _logger.info((Object)"Set alarm acknowledged state.");
            AlarmManager alarmManager = this.getAlarmManager(managedObjectReference.getServerGuid());
            ManagedObjectReference managedObjectReference2 = alarmAcknowledgementSpec.alarm;
            alarmManager.acknowledgeAlarm(managedObjectReference2, managedObjectReference);
            this.publishOperationUpdateIfNeeded(alarmManager, managedObjectReference, managedObjectReference2);
        }
        catch (Exception exception) {
            operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
            _logger.error((Object)("Unable to set the alarm's acknowledged state " + exception));
        }
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, AlarmStatusSpec alarmStatusSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            _logger.info((Object)("Set alarm status " + alarmStatusSpec.status));
            AlarmManager alarmManager = this.getAlarmManager(managedObjectReference.getServerGuid());
            ManagedObjectReference managedObjectReference2 = alarmStatusSpec.alarm;
            alarmManager.setAlarmStatus(managedObjectReference2, managedObjectReference, alarmStatusSpec.status);
            this.publishOperationUpdateIfNeeded(alarmManager, managedObjectReference, managedObjectReference2);
        }
        catch (Exception exception) {
            operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
            _logger.error((Object)("Unable to set the alarm status " + exception));
        }
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, AlarmSpec alarmSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            _logger.info((Object)("Reconfigure alarm " + alarmSpec.name));
            Alarm alarm = (Alarm)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
            alarm.reconfigure(alarmSpec);
        }
        catch (Exception exception) {
            operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
            _logger.error((Object)("Unable to reconfigure alarm " + exception));
        }
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, EnableAlarmActionsSpec enableAlarmActionsSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            _logger.info((Object)("Set enabled alarms state to " + enableAlarmActionsSpec.enabled));
            AlarmManager alarmManager = this.getAlarmManager(managedObjectReference.getServerGuid());
            alarmManager.setAlarmActionsEnabled(managedObjectReference, enableAlarmActionsSpec.enabled);
        }
        catch (Exception exception) {
            operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
            _logger.error((Object)("Unable to set the enabled alarm state. " + exception.getMessage()));
        }
        return operationResult;
    }

    public OperationResult add(NewAlarmDefinitionSpec newAlarmDefinitionSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = newAlarmDefinitionSpec.context;
        try {
            _logger.info((Object)("Create mew Alarm " + newAlarmDefinitionSpec.alarmSpec.name));
            AlarmManager alarmManager = this.getAlarmManager(newAlarmDefinitionSpec.context.getServerGuid());
            alarmManager.create(newAlarmDefinitionSpec.context, newAlarmDefinitionSpec.alarmSpec);
        }
        catch (Exception exception) {
            operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
            _logger.error((Object)("Unable to crate a new alarm " + exception.getMessage()));
        }
        return operationResult;
    }

    public OperationResult remove(ManagedObjectReference managedObjectReference, RemoveAlarmDefinitionSpec removeAlarmDefinitionSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            _logger.info((Object)("Remove alarm " + managedObjectReference));
            Alarm alarm = (Alarm)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
            alarm.remove();
        }
        catch (Exception exception) {
            operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
            _logger.error((Object)("Unable to remove alarm " + exception.getMessage()));
        }
        return operationResult;
    }

    private void publishOperationUpdateIfNeeded(AlarmManager alarmManager, ManagedObjectReference managedObjectReference, ManagedObjectReference managedObjectReference2) {
        String string = managedObjectReference.getServerGuid();
        boolean bl = VcServiceUtil.is65VcOrLaterByServerGuid((String)string);
        if (bl || !LiveUpdatesUtil.alarmsEnabled((ConfigurationService)this._configurationService) || LiveUpdatesUtil.alarmsPcBasedUpdateEnabled((ConfigurationService)this._configurationService)) {
            return;
        }
        if (this._mutationOperationUpdatePublisher == null) {
            _logger.warn((Object)"The mutation publisher is not initialized.");
            return;
        }
        try {
            PartialUpdate partialUpdate = alarmManager.getAlarmState(managedObjectReference);
            if (partialUpdate == null) {
                return;
            }
            PartialUpdateItem partialUpdateItem = null;
            for (AlarmState alarmState : partialUpdate) {
                if (!alarmState.alarm.equals((Object)managedObjectReference2)) continue;
                if (alarmState.overallStatus.equals((Object)ManagedEntity.Status.green)) {
                    partialUpdateItem = PartialUpdateItem.deltaOf(null, (Object)alarmState.key);
                    break;
                }
                if (!alarmState.acknowledged.booleanValue()) break;
                partialUpdateItem = PartialUpdateItem.deltaOf((Object)alarmState, (Object)alarmState.alarm);
                break;
            }
            if (partialUpdateItem == null) {
                return;
            }
            AlarmUtil.assignMetadata(partialUpdateItem, "objUpdateGuid", string);
            PartialUpdate partialUpdate2 = PartialUpdate.empty();
            partialUpdate2.updates.add(partialUpdateItem);
            partialUpdate2.setDestination("/topic/alarms");
            this._mutationOperationUpdatePublisher.publish(partialUpdate2);
        }
        catch (Exception exception) {
            _logger.error((Object)"Failed to publish operation update.", (Throwable)exception);
        }
    }

    private AlarmManager getAlarmManager(String string) throws Exception {
        ManagedObjectReference managedObjectReference = VimSessionUtil.getService((String)string).getServiceInstance().getContent().alarmManager;
        return (AlarmManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
    }
}

