/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.util;

import com.vmware.vim.binding.vim.alarm.AlarmState;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlarmStateFilter {
    private static final Log _logger = LogFactory.getLog(AlarmStateFilter.class);
    private static final String ALARM_ISSUE_TYPE = "AlarmIssue";
    private static final String GENERIC_ISSUE_TYPE = "Issue";

    public List<AlarmState> filterByIssueType(List<AlarmState> list, String string) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        if (ALARM_ISSUE_TYPE.equals(string)) {
            return list;
        }
        if (GENERIC_ISSUE_TYPE.equals(string)) {
            return this.filterAlarms(list, false);
        }
        _logger.warn((Object)String.format("Unexpected target type: %s", string));
        return list;
    }

    private List<AlarmState> filterAlarms(List<AlarmState> list, boolean bl) {
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            AlarmState alarmState = list.get(i);
            if (alarmState.acknowledged != bl) continue;
            if (n != i) {
                list.set(n, alarmState);
            }
            ++n;
        }
        if (n != list.size()) {
            return list.subList(0, n);
        }
        return list;
    }
}

