/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.vmware.opsmgmt.client.alarms.ServiceAlarmInfo;
import com.vmware.opsmgmt.client.alarms.util.Util;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventManager;
import com.vmware.vim.binding.vim.event.HealthStatusChangedEvent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.GlobalObjectUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceAlarmInfoRetriever {
    private static final String EVENT_MANAGER_KEY = "EventManager";
    private static final String SERVICES_PROPERTY_NAME = "vsphere:serviceList";
    private static final String ALARMS_UTIL_SYNC_OBJECT_KEY = "com.vmware.opsmgmt.client.alarms.util.ALARMS_UTIL_SYNC_OBJECT_KEY";
    private static final int MAX_EVENTS_QUERY_SIZE = 1000;
    private static final Log _logger = LogFactory.getLog(ServiceAlarmInfoRetriever.class);
    private static final Log _performanceLogger = LogFactory.getLog((String)"PerformanceAuditingLogger");
    private DataService _dataService;
    private Cache<Pair<String, String>, URI> _cachedServiceUrisMap = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).maximumSize(1024L).build();
    private ReentrantLock _uriLock = new ReentrantLock();
    private Cache<URI, String> _cachedServiceNamesMap = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).maximumSize(1024L).build();
    private Lock _namesLock = new ReentrantLock();
    private Cache<String, Object> _cachedEvents = CacheBuilder.newBuilder().expireAfterWrite(12L, TimeUnit.HOURS).maximumSize(2048L).build();
    private Lock _eventsLock = new ReentrantLock();
    private static final Object NON_HEALTH_STATUS_EVENT = new Object();

    public ServiceAlarmInfoRetriever(DataService dataService) {
        this._dataService = dataService;
    }

    public Map<String, ServiceAlarmInfo> retrieve(List<AlarmState> list, String string) {
        Map<String, HealthStatusChangedEvent> map;
        Set<String> set;
        HashMap<String, ServiceAlarmInfo> hashMap = new HashMap<String, ServiceAlarmInfo>();
        ArrayList<AlarmState> arrayList = new ArrayList<AlarmState>();
        for (AlarmState alarmState : list) {
            if (alarmState.alarm == null || alarmState.alarm.getServerGuid() == null || alarmState.eventKey == null) continue;
            arrayList.add(alarmState);
        }
        if (arrayList.size() == 0) {
            return hashMap;
        }
        boolean bl = _performanceLogger.isInfoEnabled();
        long l = 0L;
        long l2 = 0L;
        if (bl) {
            l = System.currentTimeMillis();
        }
        Map<String, List<HealthStatusChangedEvent>> map2 = this.getEventMap(arrayList);
        if (bl) {
            l2 = System.currentTimeMillis();
            _performanceLogger.info((Object)String.format("%s: EventMap (part of ServiceAlarmInfos retrieval) retrieved in %d ms.", string, l2 - l));
        }
        if ((set = (map = this.getServiceEventsMap(map2, arrayList)).keySet()).isEmpty()) {
            return hashMap;
        }
        Map<URI, String> map3 = this.getServiceReferencesMap(map2, map, string);
        if (map3.isEmpty()) {
            ListIterator<AlarmState> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                AlarmState alarmState = (AlarmState)listIterator.next();
                String string2 = Util.buildAlarmKey(alarmState);
                if (!set.contains(string2)) continue;
                listIterator.remove();
            }
            return hashMap;
        }
        Map<String, String> map4 = this.getServiceNamesMap(map3, string);
        for (Map.Entry<URI, String> entry : map3.entrySet()) {
            URI uRI = entry.getKey();
            String string3 = entry.getValue();
            String string4 = map4.get(string3);
            HealthStatusChangedEvent healthStatusChangedEvent = map.get(string3);
            ServiceAlarmInfo serviceAlarmInfo = this.createServiceAlarmInfo(healthStatusChangedEvent, string4, uRI);
            hashMap.put(string3, serviceAlarmInfo);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<HealthStatusChangedEvent>> getEventMap(List<AlarmState> list) {
        HashMap<String, List<HealthStatusChangedEvent>> hashMap = new HashMap<String, List<HealthStatusChangedEvent>>();
        Map<String, Set<Integer>> map = this.getEventKeyMap(list);
        for (String string : map.keySet()) {
            Set<Integer> set = map.get(string);
            if (set == null || set.isEmpty()) continue;
            ArrayList<HealthStatusChangedEvent> arrayList = new ArrayList<HealthStatusChangedEvent>();
            this._eventsLock.lock();
            try {
                List<Integer[]> list2;
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                for (Integer n : set) {
                    list2 = this._cachedEvents.getIfPresent((Object)(string + ':' + n));
                    if (list2 != null) {
                        if (list2 == NON_HEALTH_STATUS_EVENT) continue;
                        arrayList.add((HealthStatusChangedEvent)list2);
                        continue;
                    }
                    arrayList2.add(n);
                }
                if (arrayList2.isEmpty()) {
                    hashMap.put(string, arrayList);
                    continue;
                }
                EventManager eventManager = this.getEventManager(string);
                if (eventManager == null) {
                    _logger.error((Object)String.format("Unable to get event manager. Server GUID: %s", string));
                    continue;
                }
                Integer[] integerArray = arrayList2.toArray(new Integer[0]);
                list2 = ServiceAlarmInfoRetriever.split(integerArray, 1000);
                for (Integer[] integerArray2 : list2) {
                    int[] nArray = new int[integerArray2.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = integerArray2[i];
                    }
                    Event[] eventArray = eventManager.queryEventsById(nArray);
                    if (eventArray == null) continue;
                    for (Event event : eventArray) {
                        if (event instanceof HealthStatusChangedEvent) {
                            this._cachedEvents.put((Object)(string + ':' + event.key), (Object)event);
                            arrayList.add((HealthStatusChangedEvent)event);
                            continue;
                        }
                        this._cachedEvents.put((Object)(string + ':' + event.key), NON_HEALTH_STATUS_EVENT);
                    }
                }
            }
            finally {
                this._eventsLock.unlock();
                continue;
            }
            hashMap.put(string, arrayList);
        }
        return hashMap;
    }

    private Map<String, Set<Integer>> getEventKeyMap(List<AlarmState> list) {
        HashMap<String, Set<Integer>> hashMap = new HashMap<String, Set<Integer>>();
        for (AlarmState alarmState : list) {
            String string = alarmState.alarm.getServerGuid();
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, new HashSet());
            }
            ((Set)hashMap.get(string)).add(alarmState.eventKey);
        }
        return hashMap;
    }

    private Map<String, HealthStatusChangedEvent> getServiceEventsMap(Map<String, List<HealthStatusChangedEvent>> map, List<AlarmState> list) {
        HashMap<String, HealthStatusChangedEvent> hashMap = new HashMap<String, HealthStatusChangedEvent>();
        block0: for (AlarmState alarmState : list) {
            List<HealthStatusChangedEvent> list2 = map.get(alarmState.alarm.getServerGuid());
            if (list2 == null || list2.isEmpty()) continue;
            for (HealthStatusChangedEvent healthStatusChangedEvent : list2) {
                if (healthStatusChangedEvent.key != alarmState.eventKey) continue;
                hashMap.put(Util.buildAlarmKey(alarmState), healthStatusChangedEvent);
                continue block0;
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventManager getEventManager(String string) {
        VcService vcService = VimSessionUtil.getService((String)string);
        if (vcService == null) {
            return null;
        }
        HttpSession httpSession = SessionUtil.getHttpSession();
        if (httpSession == null) {
            return null;
        }
        Object object = SessionUtil.getSyncObject((String)ALARMS_UTIL_SYNC_OBJECT_KEY, (HttpSession)httpSession);
        HashMap<String, Object> hashMap = null;
        Object object2 = object;
        synchronized (object2) {
            hashMap = (HashMap<String, Object>)SessionUtil.getData((String)EVENT_MANAGER_KEY, (HttpSession)httpSession);
            if (hashMap == null) {
                hashMap = new HashMap<String, Object>();
                SessionUtil.setData((String)EVENT_MANAGER_KEY, hashMap);
            }
            if (hashMap.containsKey(string)) {
                return (EventManager)hashMap.get(string);
            }
        }
        object2 = null;
        try {
            object2 = (EventManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vcService.getServiceInstanceContent().eventManager);
        }
        catch (Exception exception) {
            _logger.error((Object)("Failed to retrieve event manager for serverGUID: " + string), (Throwable)exception);
            return null;
        }
        Object object3 = object;
        synchronized (object3) {
            hashMap.put(string, object2);
        }
        return object2;
    }

    private ServiceAlarmInfo createServiceAlarmInfo(HealthStatusChangedEvent healthStatusChangedEvent, String string, URI uRI) {
        ServiceAlarmInfo serviceAlarmInfo = new ServiceAlarmInfo();
        serviceAlarmInfo.serviceName = string;
        serviceAlarmInfo.service = uRI;
        serviceAlarmInfo.message = healthStatusChangedEvent.fullFormattedMessage;
        return serviceAlarmInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<URI, String> getServiceReferencesMap(Map<String, List<HealthStatusChangedEvent>> map, Map<String, HealthStatusChangedEvent> map2, String string) {
        Pair pair;
        Object object2;
        HashMap<URI, String> uRIArray = new HashMap<URI, String>();
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string2 : map.keySet()) {
            object2 = map.get(string2);
            Iterator<HealthStatusChangedEvent> iterator = object2.iterator();
            while (iterator.hasNext()) {
                HealthStatusChangedEvent healthStatusChangedEvent = iterator.next();
                String string3 = null;
                for (String string4 : map2.keySet()) {
                    if (healthStatusChangedEvent.key != map2.get((Object)string4).key) continue;
                    string3 = string4;
                    break;
                }
                if (string3 == null) {
                    _logger.error((Object)"Events and Service based alarms don't match!");
                    return uRIArray;
                }
                pair = new Pair((Object)healthStatusChangedEvent.serviceId, (Object)string2);
                URI object3 = (URI)this._cachedServiceUrisMap.getIfPresent((Object)pair);
                if (object3 == null) {
                    arrayList.add(pair);
                    arrayList2.add(string3);
                    continue;
                }
                uRIArray.put(object3, string3);
            }
        }
        if (!arrayList.isEmpty()) {
            this._uriLock.lock();
            try {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string2;
                    string2 = (Pair)arrayList.get(i);
                    object2 = (URI)this._cachedServiceUrisMap.getIfPresent((Object)string2);
                    if (object2 == null) continue;
                    uRIArray.put((URI)object2, (String)arrayList2.get(i));
                    arrayList.remove(i);
                    arrayList2.remove(i);
                    --i;
                }
                if (arrayList2.isEmpty()) {
                    HashMap<URI, String> uRIArray2 = uRIArray;
                    return uRIArray2;
                }
                QuerySpec querySpec = this.buildServiceReferencesQuery(arrayList.toArray(new Object[0]));
                boolean bl = _performanceLogger.isInfoEnabled();
                long l = 0L;
                long l2 = 0L;
                if (bl) {
                    l = System.currentTimeMillis();
                }
                pair = QueryUtil.getData((DataService)this._dataService, (QuerySpec)querySpec);
                if (bl) {
                    l2 = System.currentTimeMillis();
                    _performanceLogger.info((Object)String.format("%s: ServiceReferences (part of ServiceAlarmInfos retrieval) retrieved in: %d ms.", string, l2 - l));
                }
                if (pair == null) {
                    _logger.error((Object)"Data service returned null result for service URI query");
                    HashMap<URI, String> hashMap = uRIArray;
                    return hashMap;
                }
                if (pair.error != null || ArrayUtil.isNullOrEmpty((Object[])pair.items)) {
                    _logger.warn((Object)"URIs for requested services are not found!", (Throwable)pair.error);
                    HashMap<URI, String> hashMap = uRIArray;
                    return hashMap;
                }
                URI[] uRIArray2 = (URI[])pair.items[0].properties[0].value;
                for (int i = 0; i < uRIArray2.length; ++i) {
                    this._cachedServiceUrisMap.put(arrayList.get(i), (Object)uRIArray2[i]);
                    uRIArray.put(uRIArray2[i], (String)arrayList2.get(i));
                }
            }
            catch (Exception exception) {
                _logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
            finally {
                this._uriLock.unlock();
            }
        }
        return uRIArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getServiceNamesMap(Map<URI, String> map, String string) {
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<Map.Entry<URI, String>> arrayList = new ArrayList<Map.Entry<URI, String>>();
        for (Map.Entry<URI, String> entry : map.entrySet()) {
            object = (String)this._cachedServiceNamesMap.getIfPresent((Object)entry.getKey());
            if (object != null) {
                hashMap.put(entry.getValue(), (String)object);
                continue;
            }
            arrayList.add(entry);
        }
        if (!arrayList.isEmpty()) {
            this._namesLock.lock();
            try {
                int n;
                ArrayList arrayList2 = new ArrayList();
                for (n = 0; n < arrayList.size(); ++n) {
                    object = (Map.Entry)arrayList.get(n);
                    URI uRI = (URI)object.getKey();
                    String string2 = (String)this._cachedServiceNamesMap.getIfPresent((Object)uRI);
                    if (string2 != null) {
                        hashMap.put((String)object.getValue(), string2);
                        arrayList.remove(n);
                        --n;
                        continue;
                    }
                    arrayList2.add(uRI);
                }
                if (arrayList2.isEmpty()) {
                    HashMap<String, String> hashMap2 = hashMap;
                    return hashMap2;
                }
                n = _performanceLogger.isInfoEnabled() ? 1 : 0;
                long l = 0L;
                long l2 = 0L;
                if (n != 0) {
                    l = System.currentTimeMillis();
                }
                PropertyValue[] propertyValueArray = QueryUtil.getProperty((DataService)this._dataService, (Object[])arrayList2.toArray(new URI[0]), (String)"name");
                if (n != 0) {
                    l2 = System.currentTimeMillis();
                    _performanceLogger.info((Object)String.format("%s: ServiceNames (part of ServiceAlarmInfos retrieval) retrieved in %d ms.", string, l2 - l));
                }
                if (propertyValueArray != null) {
                    for (PropertyValue propertyValue : propertyValueArray) {
                        URI uRI = (URI)propertyValue.resourceObject;
                        String string3 = (String)propertyValue.value;
                        this._cachedServiceNamesMap.put((Object)uRI, (Object)string3);
                        String string4 = map.get(uRI);
                        if (string4 == null) {
                            _logger.error((Object)("Cannot match name for service uri:" + uRI));
                            continue;
                        }
                        hashMap.put(string4, string3);
                    }
                }
            }
            catch (Exception exception) {
                _logger.error((Object)"Failed to retrieve service names", (Throwable)exception);
            }
            finally {
                this._namesLock.unlock();
            }
        }
        return hashMap;
    }

    private QuerySpec buildServiceReferencesQuery(Object[] objectArray) {
        QuerySpec querySpec = new QuerySpec();
        ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
        objectIdentityConstraint.target = GlobalObjectUtil.getVSphereClientInstance();
        ResourceSpec resourceSpec = new ResourceSpec();
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.propertyNames = new String[]{SERVICES_PROPERTY_NAME};
        ParameterSpec parameterSpec = new ParameterSpec();
        parameterSpec.propertyName = SERVICES_PROPERTY_NAME;
        parameterSpec.parameter = objectArray;
        propertySpec.parameters = new ParameterSpec[]{parameterSpec};
        resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
        resourceSpec.constraint = objectIdentityConstraint;
        querySpec.resourceSpec = resourceSpec;
        return querySpec;
    }

    private static <T> List<T[]> split(T[] TArray, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid argument: n");
        }
        if (TArray == null) {
            return Collections.emptyList();
        }
        LinkedList<T[]> linkedList = new LinkedList<T[]>();
        int n2 = 0;
        while (n2 < TArray.length) {
            int n3 = n2 + Math.min(n, TArray.length - n2);
            T[] TArray2 = Arrays.copyOfRange(TArray, n2, n3);
            linkedList.add(TArray2);
            n2 = n3;
        }
        return linkedList;
    }
}

