/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.soap.impl.unmarshaller;

import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.vmomi.core.exception.UnexpectedTypeException;
import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.soap.Constants;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.ArrayStackContext;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.ComplexStackContext;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.EnumStackContext;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.Environment;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.FaultStackContext;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.ManagedObjectStackContext;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.MoRefStackContext;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.PrimitiveStackContext;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.StackContext;
import com.vmware.vim.vmomi.core.types.VmodlArrayType;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.impl.VmodlFieldImpl;
import com.vmware.vim.vmomi.core.types.impl.VmomiServiceImpl;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class StackContextFactory {
    private static Log _logger = LogFactory.getLog(StackContextFactory.class);

    StackContextFactory() {
    }

    public static StackContext newContext(StackContext parent, VmodlField field, QName name2, Map<QName, String> attrs, NamespaceContext namespaces, Environment env) throws UnmarshallException {
        VmodlType type = null;
        if (field == null) {
            type = StackContextFactory.getType(field, attrs, namespaces, env);
            if (type == null) {
                throw new UnmarshallException("Unable to create stack context: insufficient type information");
            }
            VmodlFieldImpl fieldImpl = new VmodlFieldImpl(env.getContext());
            fieldImpl.setLink(false);
            fieldImpl.setLinkable(false);
            fieldImpl.setName(name2.getLocalPart());
            fieldImpl.setOptional(false);
            fieldImpl.setSecret(false);
            fieldImpl.setCollectionType(VmodlField.CollectionType.NONE);
            fieldImpl.setType(env.getTypeMap().getVmodlType(Object.class));
            fieldImpl.setVersion(type.getVersion());
            fieldImpl.setWsdlName(name2.getLocalPart());
            field = fieldImpl;
        }
        if (!name2.getLocalPart().equals(field.getName())) {
            throw new UnmarshallException(String.format("local name and field name mismatch: '%1$s' - '%2$s'", name2.getLocalPart(), field.getName()));
        }
        if (field.getType().getKind() == VmodlType.Kind.ARRAY) {
            VmodlArrayType arrType = (VmodlArrayType)field.getType();
            return new ArrayStackContext(field, arrType, parent, env);
        }
        if (type == null) {
            type = StackContextFactory.getType(field, attrs, namespaces, env);
        }
        switch (type.getKind()) {
            case MANAGED_OBJECT: {
                if (parent != null && env.getTypeMap().getVmodlType("ManagedObjectNotFound", new VmomiServiceImpl(null, "vim25")).getTypeClass().isInstance(parent.getValue())) {
                    return new MoRefStackContext(field, type, parent, attrs, env);
                }
                return new ManagedObjectStackContext(field, type, parent, attrs, env);
            }
            case MOREF: {
                return new MoRefStackContext(field, type, parent, attrs, env);
            }
            case ARRAY: {
                return new ArrayStackContext(field, type, parent, env);
            }
            case FAULT: {
                if (parent == null || !(parent instanceof FaultStackContext)) {
                    return new FaultStackContext(field, type, parent, env);
                }
            }
            case DATA_OBJECT: {
                return new ComplexStackContext(field, type, parent, env);
            }
            case ENUM: {
                return new EnumStackContext(field, type, parent);
            }
            case ANY: {
                throw new UnmarshallException("Unsupported type: ANY type is not supported");
            }
        }
        return new PrimitiveStackContext(field, type, parent, attrs, env);
    }

    public static VmodlType getType(VmodlField field, Map<QName, String> attrs, NamespaceContext namespaces, Environment env) throws UnmarshallException {
        String typeName = attrs.get(Constants.XSI_TYPE_QNAME);
        VmodlTypeMap typemap = env.getTypeMap();
        VmodlType type = null;
        String namespaceURI = null;
        if (typeName != null) {
            if (typeName.contains(":")) {
                String[] split = typeName.split(":");
                namespaceURI = namespaces.getNamespaceURI(split[0]);
                if ("".equals(split[0])) {
                    throw new UnmarshallException("Empty namespace prefix used for type - \"" + typeName + "\"");
                }
                if (namespaceURI == null && _logger.isErrorEnabled()) {
                    _logger.error((Object)("Missing namespace definition detected for namespace prefix " + split[0]));
                }
                typeName = split[1];
            }
            if (namespaceURI != null) {
                if (env.isQSFormat() && "urn:vmware:queryservice".equals(namespaceURI)) {
                    if (typeName.equals("ManagedObjectLink")) {
                        type = typemap.getVmodlType("ManagedObjectReference");
                    } else if (typeName.equals("Link")) {
                        type = typemap.getVmodlType("anyURI");
                    }
                } else if (!"http://www.w3.org/2001/XMLSchema".equals(namespaceURI)) {
                    if (!namespaceURI.startsWith("urn:")) {
                        throw new UnmarshallException("Invalid namespace definition found in the parsed XML: " + namespaceURI);
                    }
                    String namespace = namespaceURI.substring("urn:".length());
                    VmomiServiceImpl svc = new VmomiServiceImpl("", namespace);
                    type = typemap.getVmodlType(typeName, svc);
                }
            }
            if (type == null) {
                type = typemap.getVmodlType(typeName);
            }
        } else if (field != null) {
            typeName = field.getName();
            type = field.getType();
        }
        if (type == null) {
            throw new UnexpectedTypeException("Type " + typeName + " not found in VMODL context");
        }
        if (env.isResolveMoType() && type.getKind() == VmodlType.Kind.MOREF) {
            type = typemap.getVmodlType(ManagedObject.class);
        }
        return type;
    }
}

