/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.types;

import com.vmware.vim.binding.impl.vmodl.MethodNameImpl;
import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vmodl.MethodName;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vim.binding.vmodl.list;
import com.vmware.vim.binding.vmodl.map;
import com.vmware.vim.binding.vmodl.set;
import com.vmware.vim.vmomi.core.exception.UnexpectedTypeException;
import com.vmware.vim.vmomi.core.types.ManagedMethod;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.util.Validate;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

public class Util {
    public static TypeName createTypeName(Object obj) {
        return Util.createTypeName(obj, VmodlContext.getContext());
    }

    public static TypeName createTypeName(Object obj, VmodlContext context) {
        VmodlType type = context.getVmodlTypeMap().getVmodlType((String)obj);
        if (type != null) {
            return type.getTypeName();
        }
        return new TypeNameImpl((String)obj);
    }

    public static MethodName createMethodName(Object obj) {
        return Util.createMethodName(obj, VmodlContext.getContext());
    }

    public static MethodName createMethodName(Object obj, VmodlContext context) {
        ManagedMethod method = context.getVmodlTypeMap().getManagedMethod((String)obj);
        if (method != null) {
            return method.getMethodName();
        }
        return new MethodNameImpl((String)obj);
    }

    public static HashMap<Class, Annotation> mapAnnotations(Annotation[] annos) {
        HashMap<Class, Annotation> map2 = new HashMap<Class, Annotation>();
        for (Annotation annotation : annos) {
            map2.put(annotation.annotationType(), annotation);
        }
        return map2;
    }

    public static VmodlField.CollectionType computeCollectionType(Map<Class, Annotation> annotationMap) {
        if (annotationMap.get(list.class) != null) {
            return VmodlField.CollectionType.LIST;
        }
        if (annotationMap.get(map.class) != null) {
            return VmodlField.CollectionType.MAP;
        }
        if (annotationMap.get(set.class) != null) {
            return VmodlField.CollectionType.SET;
        }
        return VmodlField.CollectionType.NONE;
    }

    public static VmodlType getVmodlObjectType(Object obj, VmodlContext context) {
        Validate.notNull("Object is required", obj);
        Validate.notNull("VMODL context is required", context);
        VmodlType dynamicType = context.getVmodlTypeMap().getDynamicVmodlType(obj);
        if (dynamicType == null) {
            throw new UnexpectedTypeException(String.format("Unable to determine dynamic type of '%1$s'", obj.getClass()));
        }
        return dynamicType;
    }
}

