/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dscluster.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.cluster.RuleInfo;
import com.vmware.vim.binding.vim.storageDrs.VmConfigInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.drs.model.VmMonitorTargetData;
import com.vmware.vsphere.client.dscluster.model.configuration.SdrsRuleListItemData;
import com.vmware.vsphere.client.dscluster.model.configuration.SdrsRuleVmData;
import com.vmware.vsphere.client.dscluster.util.SdrsRulesUtil;
import com.vmware.vsphere.client.storagedrs.rules.SdrsRuleInfo;
import com.vmware.vsphere.client.storagedrs.rules.SdrsRulesBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class DsClusterRulesPropertyProvider {
    public static final String PROPERTY_SDRS_POD_CONFIG_RULES = "podStorageDrsEntry/storageDrsConfig/podConfig/rule";
    public static final String PROPERTY_SDRS_VM_CONFIG_RULES = "podStorageDrsEntry/storageDrsConfig/vmConfig";
    private final QueryService _queryService;
    private final QueryBindingService _queryBindingService;

    public DsClusterRulesPropertyProvider(QueryService queryService, QueryBindingService queryBindingService) {
        this._queryService = queryService;
        this._queryBindingService = queryBindingService;
    }

    @PropertyProvider(value="StoragePod/computedSdrsRules")
    public Collection<SdrsRuleListItemData[]> getComputedSdrsRules(Collection<ManagedObjectReference> objects) {
        if (objects == null || objects.size() != 1) {
            throw new IllegalArgumentException("getComputedSdrsRules accepts only a single Storage parameter.");
        }
        return this.getSdrsRuleListItems(objects);
    }

    @PropertyProvider(value="VirtualMachine/computedSdrsRuleVmDetails")
    public Collection<SdrsRuleVmData> getComputedSdrsRuleVmDetails(Collection<ManagedObjectReference> objects) {
        return this._queryBindingService.prepare(SdrsRuleVmData.class).fetch(objects);
    }

    private Collection<SdrsRuleListItemData[]> getSdrsRuleListItems(Collection<ManagedObjectReference> objects) {
        HashMap<ManagedObjectReference, VmMonitorTargetData> vmsByRef;
        List<SdrsRuleInfo> sdrsRuleInfoList = this.getSdrsRulesInfo(objects);
        HashSet<ManagedObjectReference> ruleVms = new HashSet<ManagedObjectReference>();
        for (SdrsRuleInfo sdrsRuleInfo : sdrsRuleInfoList) {
            if (sdrsRuleInfo.vm == null) continue;
            ruleVms.add(sdrsRuleInfo.vm);
        }
        if (!ruleVms.isEmpty()) {
            Collection vmsResultSet = this._queryBindingService.prepare(VmMonitorTargetData.class).fetch(ruleVms);
            vmsByRef = SdrsRulesUtil.getVmsMapByRef(vmsResultSet);
        } else {
            vmsByRef = new HashMap();
        }
        ArrayList<SdrsRuleListItemData> sdrsRuleListItems = new ArrayList<SdrsRuleListItemData>();
        for (SdrsRuleInfo sdrsRuleInfo : sdrsRuleInfoList) {
            sdrsRuleListItems.add(SdrsRulesUtil.createSdrsRuleListItem(sdrsRuleInfo, vmsByRef));
        }
        return Collections.singleton(sdrsRuleListItems.toArray(new SdrsRuleListItemData[0]));
    }

    private List<SdrsRuleInfo> getSdrsRulesInfo(Collection<ManagedObjectReference> objects) {
        List intraVmAntiAffinityRules;
        ResultSet rulesResultSet = this._queryService.select(new String[]{PROPERTY_SDRS_POD_CONFIG_RULES, PROPERTY_SDRS_VM_CONFIG_RULES}).from(new String[]{StoragePod.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, objects)}).fetch();
        ResourceItem resourceItem = (ResourceItem)rulesResultSet.getItems().get(0);
        RuleInfo[] sdrsPodRules = (RuleInfo[])resourceItem.get(PROPERTY_SDRS_POD_CONFIG_RULES);
        VmConfigInfo[] sdrsVmRules = (VmConfigInfo[])resourceItem.get(PROPERTY_SDRS_VM_CONFIG_RULES);
        ArrayList<SdrsRuleInfo> sdrsRuleInfoList = new ArrayList<SdrsRuleInfo>();
        if (sdrsPodRules != null) {
            intraVmAntiAffinityRules = SdrsRulesBuilder.buildVmAntiAffinityRules((ManagedObjectReference)objects.iterator().next(), (RuleInfo[])sdrsPodRules);
            sdrsRuleInfoList.addAll(intraVmAntiAffinityRules);
        }
        if (sdrsVmRules != null) {
            intraVmAntiAffinityRules = SdrsRulesBuilder.buildIntraVmAntiAffinityRules((ManagedObjectReference)objects.iterator().next(), (VmConfigInfo[])sdrsVmRules);
            sdrsRuleInfoList.addAll(intraVmAntiAffinityRules);
        }
        return sdrsRuleInfoList;
    }
}

