/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client.impl;

import com.vmware.identity.cdc.CdcDCEntry;
import com.vmware.identity.cdc.CdcFactory;
import com.vmware.identity.cdc.CdcSession;
import com.vmware.identity.cdc.CdcState;
import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.sso.client.exception.ServerCommunicationException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SiteAffinityServiceDiscovery {
    private final SecurityTokenServiceConfig.ConnectionConfig connConfig;
    private static final int FLAGS = 0;
    private static final Logger log = LoggerFactory.getLogger(SiteAffinityServiceDiscovery.class);

    public SiteAffinityServiceDiscovery(SecurityTokenServiceConfig.ConnectionConfig connConfig) {
        this.connConfig = connConfig;
    }

    public URL getServiceLocation() {
        try {
            if (this.connConfig.isSiteAffinityUsed()) {
                return this.getServiceLocationInternal();
            }
            return this.connConfig.getUrl();
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            this.logWarning(String.format("CDC not configured %s", e.toString()));
            return this.connConfig.getUrl();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URL getServiceLocationInternal() {
        try (CdcSession cdcSession = CdcFactory.createCdcSessionViaIPC();){
            boolean isSiteAffinityDisabled;
            boolean bl = isSiteAffinityDisabled = cdcSession.getCdcState() == CdcState.CDC_STATE_DISABLED;
            if (isSiteAffinityDisabled) {
                this.logInfo("Site affinity is disabled");
                URL uRL2 = this.connConfig.getUrl();
                return uRL2;
            }
            URL uRL = this.getDomainController(cdcSession);
            return uRL;
        }
        catch (ServerCommunicationException e) {
            log.error("Failed to create affinitized URL %s", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.logWarning(String.format("Failed to create affinitized URL %s", e.toString()));
            return this.connConfig.getUrl();
        }
    }

    private URL getDomainController(CdcSession cdcSession) {
        try {
            CdcDCEntry domainController = cdcSession.getAffinitizedDC(null, 0);
            URL connConfigURL = this.connConfig.getUrl();
            this.logInfo(String.format("Site affinity DC name: %s", domainController.dcName));
            URL affinitizedUrl = new URL(connConfigURL.getProtocol(), domainController.dcName, connConfigURL.getPort(), connConfigURL.getFile());
            return affinitizedUrl;
        }
        catch (Exception e) {
            throw new ServerCommunicationException("Failed to create affinitized URL", e);
        }
    }

    private void logInfo(String message) {
        if (log.isInfoEnabled()) {
            log.info(message);
        }
    }

    private void logWarning(String message) {
        if (log.isWarnEnabled()) {
            log.warn(message);
        }
    }
}

