/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.provisioning.ovf.impl;

import com.vmware.vapi.bindings.DynamicStructure;
import com.vmware.vapi.bindings.Structure;
import com.vmware.vapi.bindings.client.AsyncCallback;
import com.vmware.vapi.std.errors.InvalidArgument;
import com.vmware.vapi.std.errors.NotFound;
import com.vmware.vcenter.ovf.ImportSession;
import com.vmware.vcenter.ovf.ImportSessionTypes;
import com.vmware.vcenter.ovf.OvfFileInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.cis.CisIdConverter;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.concurrent.BlockingUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vsphere.client.provisioning.ovf.OvfDeployService;
import com.vmware.vsphere.client.provisioning.ovf.OvfErrorFormatter;
import com.vmware.vsphere.client.provisioning.ovf.OvfFileInfoResult;
import com.vmware.vsphere.client.provisioning.ovf.OvfParametersUtil;
import com.vmware.vsphere.client.provisioning.ovf.OvfQueryResult;
import com.vmware.vsphere.client.provisioning.ovf.OvfSessionError;
import com.vmware.vsphere.client.provisioning.ovf.impl.DeploySession;
import com.vmware.vsphere.client.provisioning.ovf.impl.ResourcePoolDeploySession;
import com.vmware.vsphere.client.util.uri.UriSchemeUtil;
import com.vmware.vsphere.client.util.vapi.VapiUtil;
import com.vmware.vsphere.client.vapi.tasks.VapiAsyncCallback;
import com.vmware.vsphere.client.vapi.tasks.VapiTaskMonitor;
import com.vmware.vsphere.client.vcde.util.VcdeI18nUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OvfDeployServiceImpl
implements OvfDeployService {
    private static final Log _logger = LogFactory.getLog(OvfDeployServiceImpl.class);
    private static final long CREATE_SESSION_POLL_INTERVAL = 200L;
    private static final long CREATE_SESSION_POLL_TIMEOUT = 900000L;
    private static final List<OvfFileInfo.FileType> RESOURCE_FILE_TYPES = Arrays.asList(OvfFileInfo.FileType.DISK, OvfFileInfo.FileType.CONTENT, OvfFileInfo.FileType.OVA);
    private Set<Class<? extends Structure>> _supportedOvfParameterTypes;
    private final ImportSession _importSession;
    private final OvfErrorFormatter _errorFormatter;
    private final VapiTaskMonitor _vapiTaskMonitor;

    public OvfDeployServiceImpl(ImportSession importSession, VapiTaskMonitor vapiTaskMonitor, OvfErrorFormatter errorFormatter) {
        Validate.notNull((Object)importSession, (String)"importSession param is not specified.");
        Validate.notNull((Object)errorFormatter, (String)"errorFormatter param is not specified.");
        Validate.notNull((Object)vapiTaskMonitor, (String)"vapiTaskMonitor param is not specified.");
        this._importSession = importSession;
        this._vapiTaskMonitor = vapiTaskMonitor;
        this._errorFormatter = errorFormatter;
    }

    public void setSupportedOvfParameterTypes(Set<Class<? extends Structure>> types) {
        this._supportedOvfParameterTypes = types;
    }

    public List<Object> newRpContext(URI source, ImportSessionTypes.SourceType sourceType, ImportSessionTypes.PushSourceContentType pushContentType, ImportSessionTypes.PushSourceOvfOption pushOvfOption, ManagedObjectReference rp, ManagedObjectReference host, ManagedObjectReference folder, List<Object> additionalParameters) {
        ResourcePoolDeploySession session = (ResourcePoolDeploySession)OvfDeployServiceImpl.newSession(source, sourceType, rp);
        session.host = host;
        session.folder = folder;
        session.pushContentType = pushContentType;
        session.pushOvfOption = pushOvfOption;
        return OvfDeployServiceImpl.newContext(session, additionalParameters);
    }

    public OvfFileInfoResult queryFileInfo(List<Object> deploymentContext) {
        DeploySession session = OvfDeployServiceImpl.getSession(deploymentContext);
        OvfFileInfoResult result = new OvfFileInfoResult();
        try {
            if (session.sessionId == null) {
                session.sessionId = this.createSession(session);
            }
            ImportSessionTypes.Info sessionInfo = this._importSession.get(session.sessionId);
            for (OvfFileInfo fileInfo : sessionInfo.getFiles()) {
                if (fileInfo.getFileType().equals((Object)OvfFileInfo.FileType.MANIFEST)) {
                    result.manifestURI = fileInfo.getFileUrl();
                    continue;
                }
                if (fileInfo.getFileType().equals((Object)OvfFileInfo.FileType.CERT)) {
                    result.certificateURI = fileInfo.getFileUrl();
                    continue;
                }
                if (fileInfo.getFileType().equals((Object)OvfFileInfo.FileType.OVF)) {
                    result.descriptorURI = fileInfo.getFileUrl();
                    continue;
                }
                if (fileInfo.getFileType().equals((Object)OvfFileInfo.FileType.OVA)) {
                    result.descriptorURI = fileInfo.getFileUrl();
                    continue;
                }
                _logger.warn((Object)("Unexpected file type returned :" + fileInfo.getFileType()));
            }
            result.newContext = this.setSession(deploymentContext, session);
        }
        catch (OvfSessionError sessionError) {
            _logger.error((Object)"OVF import session entered ERROR state.", (Throwable)sessionError);
            throw sessionError;
        }
        catch (Error vapiError) {
            _logger.error((Object)"Unexpected server error occurred while trying to query OVF.", (Throwable)vapiError);
            throw vapiError;
        }
        catch (TimeoutException e) {
            _logger.error((Object)"Timed out while executing CL session operations", (Throwable)e);
            throw new RuntimeException(VcdeI18nUtil.text("ovfQuery.genericError", new String[0]), e);
        }
        return result;
    }

    public OvfQueryResult queryOvf(List<Object> deploymentContext) {
        DeploySession session = OvfDeployServiceImpl.getSession(deploymentContext);
        OvfQueryResult result = null;
        try {
            if (session.sessionId == null) {
                session.sessionId = this.createSession(session);
            }
            List<Structure> ovfParameters = this.convertToApiParameters(deploymentContext);
            ImportSessionTypes.OvfValidationResult tryResult = this.tryInstantiate(session, ovfParameters);
            result = this.createQueryResult(tryResult, deploymentContext);
        }
        catch (OvfSessionError sessionError) {
            _logger.error((Object)"OVF import session entered ERROR state.", (Throwable)sessionError);
            throw sessionError;
        }
        catch (Error vapiError) {
            _logger.error((Object)"Unexpected server error occurred while trying to query OVF.", (Throwable)vapiError);
            throw vapiError;
        }
        catch (Exception genericError) {
            _logger.error((Object)"Unable to query OVF.", (Throwable)genericError);
            throw new RuntimeException(VcdeI18nUtil.text("ovfQuery.genericError", new String[0]), genericError);
        }
        return result;
    }

    public OvfFileInfoResult deployOvf(List<Object> deploymentContext) {
        DeploySession session = OvfDeployServiceImpl.getSession(deploymentContext);
        OvfFileInfoResult result = new OvfFileInfoResult();
        try {
            List<Structure> ovfParameters = this.convertToApiParameters(deploymentContext);
            result.task = this.instantiate(session, ovfParameters);
            if (session.sourceType.equals((Object)ImportSessionTypes.SourceType.PUSH_SOURCE)) {
                ImportSessionTypes.Info sessionInfo = this.waitForSession(session.sessionId, ImportSessionTypes.State.IMPORT_FILE_TRANSFER, 200L, 900000L);
                if (ImportSessionTypes.State.IMPORT_ERROR.equals((Object)sessionInfo.getState())) {
                    List errors = sessionInfo.getErrors();
                    throw new OvfSessionError(this._errorFormatter.format(errors), errors);
                }
                _logger.debug((Object)(session.sessionId + " entered IMPORT_FILE_TRANSFER state"));
                result.fileByUri = this.extractFiles(sessionInfo);
            }
        }
        catch (OvfSessionError sessionError) {
            _logger.error((Object)"OVF import session entered ERROR state.", (Throwable)sessionError);
            throw sessionError;
        }
        catch (Error vapiError) {
            _logger.error((Object)"Unexpected server error occurred while trying to query OVF.", (Throwable)vapiError);
            throw vapiError;
        }
        catch (Exception genericError) {
            _logger.error((Object)"Unable to deploy OVF.", (Throwable)genericError);
            throw new RuntimeException(VcdeI18nUtil.text("ovfDeploy.genericError", new String[0]), genericError);
        }
        return result;
    }

    public List<String> checkOvfReferences(String[] references, String descriptorContents) {
        ArrayList<String> missingFiles = new ArrayList<String>();
        byte[] bytes = descriptorContents.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayOutputStream str = new ByteArrayOutputStream(bytes.length);
             GZIPOutputStream compressorStream = new GZIPOutputStream(str);){
            compressorStream.write(bytes);
            compressorStream.close();
            byte[] compressed = str.toByteArray();
            String encodedOvf = new String(Base64.encodeBase64((byte[])compressed));
            ImportSessionTypes.Preview preview = this._importSession.preview(encodedOvf);
            for (ImportSessionTypes.PreviewFile file : preview.getFiles()) {
                boolean found = false;
                for (String reference : references) {
                    if (reference.equalsIgnoreCase(file.getName())) {
                        found = true;
                        break;
                    }
                    String strNormalizedNFC = Normalizer.normalize(reference, Normalizer.Form.NFC);
                    String strNormalizedNFKC = Normalizer.normalize(reference, Normalizer.Form.NFKC);
                    if (!strNormalizedNFC.equals(file.getName()) && !strNormalizedNFKC.equals(file.getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                missingFiles.add(file.getName());
            }
        }
        catch (InvalidArgument invalidArgument) {
            _logger.error((Object)"Failed to preview OVF descriptor", (Throwable)invalidArgument);
            throw invalidArgument;
        }
        catch (IOException e) {
            _logger.error((Object)"Failed to preview OVF descriptor", (Throwable)e);
        }
        return missingFiles;
    }

    private Map<String, URI> extractFiles(ImportSessionTypes.Info sessionInfo) {
        HashMap<String, URI> result = new HashMap<String, URI>();
        for (OvfFileInfo fileInfo : sessionInfo.getFiles()) {
            if (!RESOURCE_FILE_TYPES.contains(fileInfo.getFileType()) || fileInfo.getBytesTransferred() > 0L) continue;
            result.put(fileInfo.getName(), fileInfo.getFileUrl());
        }
        return result;
    }

    private String createSession(DeploySession session) throws OvfSessionError, TimeoutException {
        ImportSessionTypes.CreateSpec parameters = new ImportSessionTypes.CreateSpec();
        parameters.setSourceType(session.sourceType);
        ImportSessionTypes.State requiredState = ImportSessionTypes.State.IMPORT_SELECTING_OVF_PARAMS;
        if (session.sourceType.equals((Object)ImportSessionTypes.SourceType.PULL_SOURCE)) {
            parameters.setPullSource(session.source);
        } else if (session.sourceType.equals((Object)ImportSessionTypes.SourceType.CONTENT_LIBRARY_SOURCE)) {
            parameters.setContentLibraryItem(UriSchemeUtil.getId((URI)session.source));
        } else if (session.sourceType.equals((Object)ImportSessionTypes.SourceType.PUSH_SOURCE)) {
            ImportSessionTypes.PushSourceContentType contentType = session.pushContentType;
            parameters.setPushSourceContentType(contentType);
            if (session.pushContentType != ImportSessionTypes.PushSourceContentType.OVA_SOURCE) {
                ImportSessionTypes.PushSourceOvfOption ovfOption = session.pushOvfOption;
                parameters.setPushSourceOvfOption(ovfOption);
            }
            requiredState = ImportSessionTypes.State.IMPORT_OVF_TRANSFER;
        }
        parameters.setLocale(ResourceUtil.getLocale().toString());
        parameters.setImportFlags(new ArrayList());
        String sessionId = null;
        ImportSessionTypes.Info sessionInfo = null;
        session.clientToken = VapiUtil.newClientToken();
        try {
            _logger.debug((Object)("Creating ovf import session. Client token: " + session.clientToken));
            if (session instanceof ResourcePoolDeploySession) {
                ResourcePoolDeploySession rpss = (ResourcePoolDeploySession)session;
                sessionId = this._importSession.createForResourcePool(session.clientToken, OvfDeployServiceImpl.getManagedObjectId(rpss.provisioningTarget), OvfDeployServiceImpl.getManagedObjectId(rpss.host), OvfDeployServiceImpl.getManagedObjectId(rpss.folder), (Structure)parameters, VapiUtil.newInvocationConfig((String)session.clientToken));
            }
            if (ImportSessionTypes.State.IMPORT_ERROR.equals((Object)(sessionInfo = this.waitForSession(sessionId, requiredState, 200L, 900000L)).getState())) {
                List errors = sessionInfo.getErrors();
                throw new OvfSessionError(this._errorFormatter.format(errors), errors);
            }
            _logger.debug((Object)String.format("Successfully created OVF import session. Client token: %s. Session id %s", session.clientToken, sessionId));
        }
        catch (TimeoutException error) {
            _logger.error((Object)String.format("Failed to create OVF import session.\nClient token: %s\nSession id: %s\nSession info: %s\n", session.clientToken, sessionId, sessionInfo), (Throwable)error);
            if (sessionId != null) {
                this.deleteSession(sessionId);
            }
            throw error;
        }
        return sessionId;
    }

    private ImportSessionTypes.OvfValidationResult tryInstantiate(DeploySession session, List<Structure> ovfParameters) throws Exception {
        ImportSessionTypes.OvfValidationResult tryResult = null;
        try {
            if (session.sourceType.equals((Object)ImportSessionTypes.SourceType.PUSH_SOURCE)) {
                _logger.debug((Object)"waiting for session state to be ready to call tryInstantiate()");
                ImportSessionTypes.Info sessionInfo = this.waitForSession(session.sessionId, ImportSessionTypes.State.IMPORT_SELECTING_OVF_PARAMS, 200L, 900000L);
                if (ImportSessionTypes.State.IMPORT_ERROR.equals((Object)sessionInfo.getState())) {
                    List errors = sessionInfo.getErrors();
                    throw new OvfSessionError(this._errorFormatter.format(errors), errors);
                }
                _logger.debug((Object)"session state is ready...about to call tryInstantiate()");
            }
            _logger.debug((Object)String.format("Invoking try-instantiate with parameters:\n%s", ObjectUtil.prettyPrint(ovfParameters)));
            tryResult = this._importSession.tryInstantiate(session.sessionId, ovfParameters);
        }
        catch (NotFound nf) {
            session.sessionId = this.createSession(session);
            tryResult = this._importSession.tryInstantiate(session.sessionId, ovfParameters);
        }
        _logger.debug((Object)String.format("Finished try-instantiate. Result:\n%s", ObjectUtil.prettyPrint((Object)tryResult)));
        return tryResult;
    }

    private ManagedObjectReference instantiate(DeploySession session, List<Structure> ovfParameters) throws Exception {
        _logger.debug((Object)String.format("Invoking instantiate with parameters:\n%s", ObjectUtil.prettyPrint(ovfParameters)));
        boolean newSessionRequired = false;
        try {
            ImportSessionTypes.Info nfo = this._importSession.get(session.sessionId);
            newSessionRequired = ImportSessionTypes.State.IMPORT_ERROR.equals((Object)nfo.getState());
        }
        catch (NotFound nf) {
            newSessionRequired = true;
        }
        if (newSessionRequired) {
            session.sessionId = this.createSession(session);
        }
        VapiAsyncCallback asyncCallback = new VapiAsyncCallback(session.clientToken, this._vapiTaskMonitor);
        this._importSession.instantiate(session.sessionId, ovfParameters, (AsyncCallback)asyncCallback);
        ManagedObjectReference result = asyncCallback.waitForActivationTask();
        return result;
    }

    private void deleteSession(String sessionId) {
        try {
            if (sessionId != null) {
                this._importSession.delete(sessionId);
            }
        }
        catch (Exception error) {
            _logger.error((Object)"Unable to destroy session.", (Throwable)error);
        }
    }

    private boolean isTypeSupported(Class<?> parameterType) {
        return this._supportedOvfParameterTypes != null && this._supportedOvfParameterTypes.contains(parameterType);
    }

    private ImportSessionTypes.Info waitForSession(String sessionId, ImportSessionTypes.State expectedState, long pollInterval, long pollTimeout) throws TimeoutException {
        ImportSessionTypes.Info refreshedSession;
        boolean isReady = false;
        long timeToWait = pollTimeout;
        do {
            BlockingUtil.sleep((long)pollInterval);
            refreshedSession = this._importSession.get(sessionId);
            timeToWait -= pollInterval;
            if (ImportSessionTypes.State.IMPORT_ERROR.equals((Object)refreshedSession.getState())) {
                _logger.warn((Object)("waitForSession : reached terminal state ERROR while waiting for " + expectedState.toString()));
                return refreshedSession;
            }
            if (!ImportSessionTypes.State.IMPORT_COMPLETED.equals((Object)refreshedSession.getState())) continue;
            _logger.debug((Object)("waitForSession : reached terminal state COMPLETED while waiting for " + expectedState.toString()));
            return refreshedSession;
        } while (!(isReady = expectedState.equals((Object)refreshedSession.getState())) && timeToWait > 0L);
        if (!isReady) {
            throw new TimeoutException("Session did not enter state: " + expectedState.getEnumValue().toString());
        }
        return refreshedSession;
    }

    private static String getManagedObjectId(Object obj) {
        String id = null;
        if (obj instanceof ManagedObjectReference) {
            ManagedObjectReference mor = (ManagedObjectReference)obj;
            id = CisIdConverter.toGlobalCisId((ManagedObjectReference)mor, (String)mor.getServerGuid());
        }
        return id;
    }

    private List<Structure> convertToApiParameters(List<Object> parameters) {
        ArrayList<Structure> apiParams = new ArrayList<Structure>();
        if (parameters == null) {
            return apiParams;
        }
        for (Object param : parameters) {
            if (!(param instanceof Structure) || !this.isTypeSupported(((Structure)param).getClass())) continue;
            DynamicStructure dynamicStructure = OvfParametersUtil.toDynamicStructure((Structure)((Structure)param));
            apiParams.add((Structure)dynamicStructure);
        }
        return apiParams;
    }

    private OvfQueryResult createQueryResult(ImportSessionTypes.OvfValidationResult tryResult, List<Object> oldContext) {
        OvfQueryResult ovfResult = new OvfQueryResult();
        List newParameters = OvfParametersUtil.convertToStaticStructureParams((List)tryResult.getParameters(), this._supportedOvfParameterTypes);
        ArrayList<Object> contextCopy = new ArrayList<Object>(oldContext);
        ArrayList oldParameters = new ArrayList();
        for (Object e : contextCopy) {
            if (!this.isTypeSupported(e.getClass())) continue;
            oldParameters.add(e);
        }
        contextCopy.removeAll(oldParameters);
        contextCopy.addAll(newParameters);
        ovfResult.newContext = contextCopy;
        ovfResult.errors = tryResult.getErrors();
        ovfResult.warnings = tryResult.getWarnings();
        ovfResult.infos = tryResult.getInformation();
        return ovfResult;
    }

    private static DeploySession getSession(List<Object> deploymentContext) {
        DeploySession session = null;
        if (deploymentContext != null && deploymentContext.size() > 0) {
            for (Object obj : deploymentContext) {
                if (!(obj instanceof DeploySession)) continue;
                session = (DeploySession)((Object)obj);
                break;
            }
        }
        if (session == null) {
            throw new IllegalArgumentException("DeploySession not found in deploymentContext.");
        }
        return session;
    }

    private List<Object> setSession(List<Object> deploymentContext, DeploySession newSession) {
        DeploySession existingSession = null;
        if (deploymentContext != null && deploymentContext.size() > 0) {
            ArrayList<Object> result = new ArrayList<Object>(deploymentContext);
            for (Object e : result) {
                if (!(e instanceof DeploySession)) continue;
                existingSession = (DeploySession)((Object)e);
            }
            if (existingSession != null) {
                result.remove((Object)existingSession);
            }
            result.add((Object)newSession);
            return result;
        }
        throw new IllegalArgumentException("Passed an invalid deployment context");
    }

    private static DeploySession newSession(URI source, ImportSessionTypes.SourceType sourceType, Object provisioningTarget) {
        OvfDeployServiceImpl.validateSessionParameters(source, sourceType, provisioningTarget);
        ResourcePoolDeploySession session = new ResourcePoolDeploySession();
        session.source = source;
        session.sourceType = sourceType;
        session.provisioningTarget = provisioningTarget;
        return session;
    }

    private static List<Object> newContext(DeploySession session, List<Object> additionalParameters) {
        ArrayList<Object> newContext = new ArrayList<Object>();
        newContext.add((Object)session);
        if (additionalParameters != null && additionalParameters.size() > 0) {
            newContext.addAll(additionalParameters);
        }
        return newContext;
    }

    private static void validateSessionParameters(URI source, ImportSessionTypes.SourceType sourceType, Object provisioningTarget) {
        if (provisioningTarget == null) {
            throw new IllegalArgumentException("provisioningTarget not set.");
        }
        if (source == null) {
            throw new IllegalArgumentException("source not set.");
        }
        if (sourceType == null) {
            throw new IllegalArgumentException("sourceType not set.");
        }
        if (!(sourceType.equals((Object)ImportSessionTypes.SourceType.PULL_SOURCE) || sourceType.equals((Object)ImportSessionTypes.SourceType.PUSH_SOURCE) || sourceType.equals((Object)ImportSessionTypes.SourceType.CONTENT_LIBRARY_SOURCE))) {
            throw new IllegalArgumentException("Unsupported sourceType: " + sourceType.toString());
        }
    }
}

