/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.configissues.impl;

import com.vmware.opsmgmt.client.commons.util.EventMessageFormatter;
import com.vmware.opsmgmt.client.event.impl.i18n.MessageParser;
import com.vmware.opsmgmt.client.event.util.Util;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.event.ClientEventInfo;
import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.type;
import com.vmware.vise.messaging.amf.DataObjectProxy;
import com.vmware.vsphere.client.issue.impl.IssueAdapterBase;

@type(value="Issue,ConfigIssue")
public class ConfigIssueAdapter
extends IssueAdapterBase {
    private static final String CONFIG_ISSUE_TYPE = "ConfigIssue";
    private static final String CONFIG_ISSUE_PROPERTY_NAME = "clientConfigIssue";
    private static final String ISSUE_KEY_FORMAT = "configIssue-%d";
    private DataService _dataService;

    public ConfigIssueAdapter(DataService dataService) {
        super(CONFIG_ISSUE_TYPE);
        this._dataService = dataService;
    }

    protected IssueAdapterBase.IssueData[] getIssues(QuerySpec querySpec, IssueAdapterBase.RequestContext requestContext) {
        ClientEventInfo[] clientEventInfoArray;
        Object object = this.extractEntityFromQuerySpec(querySpec);
        if (!(object instanceof ManagedObjectReference)) {
            return new IssueAdapterBase.IssueData[0];
        }
        try {
            clientEventInfoArray = (ClientEventInfo[])QueryUtil.getProperty((DataService)this._dataService, (Object)object, (String)CONFIG_ISSUE_PROPERTY_NAME);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        IssueAdapterBase.IssueData[] issueDataArray = ConfigIssueAdapter.convertToConfigIssues(object, clientEventInfoArray);
        return issueDataArray;
    }

    private static IssueAdapterBase.IssueData[] convertToConfigIssues(Object object, ClientEventInfo[] clientEventInfoArray) {
        if (clientEventInfoArray == null || clientEventInfoArray.length == 0) {
            return new IssueAdapterBase.IssueData[0];
        }
        IssueAdapterBase.IssueData[] issueDataArray = new IssueAdapterBase.IssueData[clientEventInfoArray.length];
        for (int i = 0; i < clientEventInfoArray.length; ++i) {
            Event event = (Event)clientEventInfoArray[i].serverEvent;
            issueDataArray[i] = new IssueAdapterBase.IssueData();
            issueDataArray[i].key = String.format(ISSUE_KEY_FORMAT, i);
            issueDataArray[i].issueInfo = new IssueInfo();
            issueDataArray[i].issueInfo.entity = object;
            issueDataArray[i].issueInfo.typeDisplayName = Util.getLocalizedString("configIssue.displayName");
            issueDataArray[i].issueInfo.timestamp = event.createdTime.getTime();
            EventMessageFormatter eventMessageFormatter = new EventMessageFormatter(event, clientEventInfoArray[i].eventDetail.makeEventDetail(), (ManagedObjectReference)object);
            MessageParser messageParser = new MessageParser(new DataObjectProxy((Object)event), event);
            String string = eventMessageFormatter.getFullMessage();
            messageParser.parse(string);
            issueDataArray[i].issueInfo.description = messageParser.getFullFormattedMessage();
            issueDataArray[i].issueInfo.details = event;
        }
        return issueDataArray;
    }
}

