/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.classification;

import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public abstract class EventClassificationAdapterBase
implements DataProviderAdapter {
    public Response getData(RequestSpec requestSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{requestSpec});
        QuerySpec[] querySpecArray = requestSpec.querySpec;
        ResultSet[] resultSetArray = new ResultSet[querySpecArray.length];
        for (int i = 0; i < querySpecArray.length; ++i) {
            resultSetArray[i] = this.processQuerySpec(querySpecArray[i]);
        }
        Response response = new Response();
        response.resultSet = resultSetArray;
        return response;
    }

    protected abstract String getUriId();

    protected abstract Map<String, Set<String>> getEventClassification();

    protected abstract Set<String> getEventClassification(String var1);

    private ResultSet processQuerySpec(QuerySpec querySpec) {
        if (querySpec == null || querySpec.resourceSpec == null || querySpec.resourceSpec.constraint == null) {
            throw new IllegalArgumentException("Invalid query spec");
        }
        ResultSet resultSet = this.buildResultSet(querySpec);
        return resultSet;
    }

    private ResultSet buildResultSet(QuerySpec querySpec) {
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = DefaultUriSchemeUtil.createUri((String)"EventClassification", (String)this.getUriId());
        resultItem.properties = this.buildResultProperties(querySpec);
        ResultSet resultSet = new ResultSet();
        resultSet.queryName = querySpec.name;
        resultSet.totalMatchedObjectCount = 1;
        resultSet.items = new ResultItem[]{resultItem};
        return resultSet;
    }

    private PropertyValue[] buildResultProperties(QuerySpec querySpec) {
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        if (this.allEventsAreRequested(querySpec)) {
            arrayList.add(this.buildAllEventsProperty());
        }
        if (this.eventsByMoTypeAreRequested(querySpec)) {
            arrayList.add(this.buildEventsByTypeProperty(querySpec));
        }
        return arrayList.toArray(new PropertyValue[arrayList.size()]);
    }

    private boolean allEventsAreRequested(QuerySpec querySpec) {
        if (ArrayUtil.isNullOrEmpty((Object[])querySpec.resourceSpec.propertySpecs)) {
            return false;
        }
        for (PropertySpec propertySpec : querySpec.resourceSpec.propertySpecs) {
            for (String string : propertySpec.propertyNames) {
                if (!"allEvents".equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean eventsByMoTypeAreRequested(QuerySpec querySpec) {
        if (ArrayUtil.isNullOrEmpty((Object[])querySpec.resourceSpec.propertySpecs)) {
            return false;
        }
        for (PropertySpec propertySpec : querySpec.resourceSpec.propertySpecs) {
            for (String string : propertySpec.propertyNames) {
                if (!"eventsByObjectType".equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private PropertyValue buildAllEventsProperty() {
        Map<String, Set<String>> map = this.getEventClassification();
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.propertyName = "allEvents";
        propertyValue.value = map;
        return propertyValue;
    }

    private PropertyValue buildEventsByTypeProperty(QuerySpec querySpec) {
        Set<String> set = null;
        String string = this.getObjectType(querySpec);
        if (string != null) {
            set = this.getEventClassification(string);
        }
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.propertyName = "eventsByObjectType";
        propertyValue.value = set;
        return propertyValue;
    }

    private String getObjectType(QuerySpec querySpec) {
        if (!(querySpec.resourceSpec.constraint instanceof PropertyConstraint)) {
            return null;
        }
        PropertyConstraint propertyConstraint = (PropertyConstraint)querySpec.resourceSpec.constraint;
        if (!propertyConstraint.propertyName.equals("objectType")) {
            throw new IllegalArgumentException("Invalid constraint: property " + propertyConstraint.propertyName + " not supported");
        }
        if (!Comparator.EQUALS.equals((Object)propertyConstraint.comparator)) {
            throw new IllegalArgumentException("Invalid constraint: comparator " + propertyConstraint.comparator + " not supported");
        }
        if (propertyConstraint.comparableValue == null) {
            throw new IllegalArgumentException("Invalid constraint: null comparable value");
        }
        return propertyConstraint.comparableValue.toString();
    }
}

