/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.impl;

import com.vmware.opsmgmt.client.event.impl.EventsTransformer;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.Network;
import com.vmware.vim.binding.vim.OpaqueNetwork;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.event.ClientEventInfo;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.DerivedPropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vsphere.client.mixed.ManagedEntityParentLocator;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientConfigIssuePropertyProviderAdapter
implements DerivedPropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(ClientConfigIssuePropertyProviderAdapter.class);
    private static final String[] MO_TYPES = new String[]{VmwareDistributedVirtualSwitch.class.getSimpleName(), DistributedVirtualSwitch.class.getSimpleName(), Folder.class.getSimpleName(), Datacenter.class.getSimpleName(), ComputeResource.class.getSimpleName(), HostSystem.class.getSimpleName(), VirtualMachine.class.getSimpleName(), VirtualApp.class.getSimpleName(), ClusterComputeResource.class.getSimpleName(), ResourcePool.class.getSimpleName(), Network.class.getSimpleName(), DistributedVirtualPortgroup.class.getSimpleName(), Datastore.class.getSimpleName(), StoragePod.class.getSimpleName(), OpaqueNetwork.class.getSimpleName()};
    private static final String CONFIG_ISSUE_PROP = "configIssue";
    private static final String CLIENT_CONFIG_ISSUE_PROP = "clientConfigIssue";
    private DataService _dataService;
    private final ManagedEntityParentLocator _locator;

    public ClientConfigIssuePropertyProviderAdapter(DataService dataService, ManagedEntityParentLocator managedEntityParentLocator, DataServiceExtensionRegistry dataServiceExtensionRegistry) {
        this._dataService = dataService;
        this._locator = managedEntityParentLocator;
        dataServiceExtensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequestSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequestSpec});
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequestSpec.derivedPropertyData});
        Object[] objectArray = propertyRequestSpec.objects;
        Object[] objectArray2 = propertyRequestSpec.properties;
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray) || ArrayUtil.isNullOrEmpty((Object[])objectArray2)) {
            throw new IllegalArgumentException("Invalid input parameters.");
        }
        Map map = propertyRequestSpec.derivedPropertyData.getSourcePropertyValuesByObject();
        ResultSet resultSet = new ResultSet();
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        for (Object object : objectArray) {
            Object object2;
            Map map2 = (Map)map.get(object);
            if (map2 == null || !(object instanceof ManagedObjectReference)) continue;
            Object v = map2.get(CONFIG_ISSUE_PROP);
            if (!(v instanceof Event[])) {
                object2 = String.format("'configIssue' property of managed object {0} is not of type Event[]", object);
                if (_logger.isDebugEnabled()) {
                    _logger.debug(object2);
                }
                throw new IllegalArgumentException((String)object2);
            }
            object2 = (Event[])v;
            ManagedObjectReference managedObjectReference = (ManagedObjectReference)object;
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = object;
            PropertyValue[] propertyValueArray = this.calculateClientConfigIssue(managedObjectReference, (Event[])object2);
            resultItem.properties = propertyValueArray;
            arrayList.add(resultItem);
        }
        resultSet.items = arrayList.toArray(new ResultItem[0]);
        return resultSet;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        ArrayList<TypeInfo> arrayList = new ArrayList<TypeInfo>();
        for (String string : MO_TYPES) {
            TypeInfo typeInfo = new TypeInfo();
            typeInfo.type = string;
            typeInfo.properties = new String[]{CLIENT_CONFIG_ISSUE_PROP};
            DerivedPropertyInfo derivedPropertyInfo = new DerivedPropertyInfo();
            derivedPropertyInfo.propertyName = CLIENT_CONFIG_ISSUE_PROP;
            derivedPropertyInfo.sourcePropertyNames = new String[]{CONFIG_ISSUE_PROP};
            typeInfo.derivedProperties = new DerivedPropertyInfo[]{derivedPropertyInfo};
            arrayList.add(typeInfo);
        }
        return arrayList.toArray(new TypeInfo[0]);
    }

    private PropertyValue[] calculateClientConfigIssue(ManagedObjectReference managedObjectReference, Event[] eventArray) {
        ClientEventInfo[] clientEventInfoArray;
        block2: {
            clientEventInfoArray = new ClientEventInfo[]{};
            try {
                clientEventInfoArray = EventsTransformer.transformToClientEvents(this._dataService, eventArray, managedObjectReference.getServerGuid(), this._locator, null);
            }
            catch (Exception exception) {
                if (!_logger.isErrorEnabled()) break block2;
                _logger.error((Object)"Cannot compute clientConfigIssue.", (Throwable)exception);
            }
        }
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.propertyName = CLIENT_CONFIG_ISSUE_PROP;
        propertyValue.value = clientEventInfoArray;
        propertyValue.resourceObject = managedObjectReference;
        return new PropertyValue[]{propertyValue};
    }
}

