/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.impl;

import com.vmware.opsmgmt.client.event.util.Util;
import com.vmware.vim.binding.vim.event.EventFilterSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.util.ArrayUtil;
import java.util.Calendar;
import java.util.Date;

public class EventFilter {
    public static int DEFAULT_MAX_COUNT = 100;
    int count;
    EventFilterSpec eventFilterSpec;
    public String serverGuid;
    int requestedPage;
    boolean migrationHistoryRequest = false;
    public ManagedObjectReference[] migrationHistoryList;
    public boolean requestingPrevPage = true;

    public EventFilter(QuerySpec querySpec) {
        this.count = !this.requiresAllResults(querySpec.resultSpec.maxResultCount) ? querySpec.resultSpec.maxResultCount : DEFAULT_MAX_COUNT;
        this.eventFilterSpec = new EventFilterSpec();
        Constraint constraint = querySpec.resourceSpec.constraint;
        if (constraint != null) {
            Constraint[] constraintArray;
            if (constraint instanceof PropertyConstraint) {
                constraintArray = new PropertyConstraint[]{(PropertyConstraint)constraint};
            } else if (constraint instanceof CompositeConstraint) {
                constraintArray = ((CompositeConstraint)constraint).nestedConstraints;
            } else {
                String string = "Invalid query constraint for BaseEventProcessor: " + constraint.getClass().getName();
                throw new IllegalArgumentException(string);
            }
            for (Constraint constraint2 : constraintArray) {
                Object object;
                if (!(constraint2 instanceof PropertyConstraint) || !((PropertyConstraint)constraint2).comparator.equals((Object)Comparator.EQUALS)) continue;
                Object object2 = ((PropertyConstraint)constraint2).comparableValue;
                String string = ((PropertyConstraint)constraint2).propertyName;
                if ("info.initiator".equals(string)) {
                    if (this.eventFilterSpec.userName == null) {
                        this.eventFilterSpec.userName = new EventFilterSpec.ByUsername();
                    }
                    this.eventFilterSpec.userName = (EventFilterSpec.ByUsername)object2;
                    continue;
                }
                if ("info.entity".equals(string)) {
                    if (this.eventFilterSpec.entity == null) {
                        this.eventFilterSpec.entity = new EventFilterSpec.ByEntity();
                    }
                    object = (ManagedObjectReference)object2;
                    this.eventFilterSpec.entity.entity = object;
                    if (this.serverGuid != null) continue;
                    this.serverGuid = object.getServerGuid();
                    continue;
                }
                if ("info.recursion".equals(string)) {
                    if (this.eventFilterSpec.entity == null) {
                        this.eventFilterSpec.entity = new EventFilterSpec.ByEntity();
                    }
                    object = (String)object2;
                    this.eventFilterSpec.entity.recursion = this.getRecursionOption((String)object);
                    continue;
                }
                if ("info.maxResultsPerSource".equals(string)) {
                    this.count = (Integer)object2;
                    continue;
                }
                if ("info.category".equals(string)) {
                    this.eventFilterSpec.category = this.createStringArray((Object[])object2);
                    continue;
                }
                if ("info.systemUser".equals(string)) {
                    if (this.eventFilterSpec.userName == null) {
                        this.eventFilterSpec.userName = new EventFilterSpec.ByUsername();
                    }
                    this.eventFilterSpec.userName.systemUser = (Boolean)object2;
                    continue;
                }
                if ("info.userList".equals(string)) {
                    if (this.eventFilterSpec.userName == null) {
                        this.eventFilterSpec.userName = new EventFilterSpec.ByUsername();
                    }
                    this.eventFilterSpec.userName.userList = this.createStringArray((Object[])object2);
                    continue;
                }
                if ("beginTime".equals(string)) {
                    if (this.eventFilterSpec.time == null) {
                        this.eventFilterSpec.time = new EventFilterSpec.ByTime();
                    }
                    object = Calendar.getInstance();
                    ((Calendar)object).setTime((Date)object2);
                    this.eventFilterSpec.time.beginTime = object;
                    continue;
                }
                if ("endTime".equals(string)) {
                    if (this.eventFilterSpec.time == null) {
                        this.eventFilterSpec.time = new EventFilterSpec.ByTime();
                    }
                    object = Calendar.getInstance();
                    ((Calendar)object).setTime((Date)object2);
                    this.eventFilterSpec.time.endTime = object;
                    continue;
                }
                if ("info.eventChainId".equals(string)) {
                    if (object2 instanceof Double) {
                        this.eventFilterSpec.eventChainId = ((Double)object2).intValue();
                        continue;
                    }
                    this.eventFilterSpec.eventChainId = (Integer)object2;
                    continue;
                }
                if ("info.serverGuid".equals(string)) {
                    this.serverGuid = (String)object2;
                    continue;
                }
                if ("info.currentPage".equals(string)) {
                    this.requestedPage = (Integer)object2;
                    continue;
                }
                if (string.equals(Util.MIGRATION_HISTORY_LIST)) {
                    this.migrationHistoryList = this.createMORArray((Object[])object2);
                    continue;
                }
                if (string.equals("requestingPrevPage")) {
                    this.requestingPrevPage = (Boolean)object2;
                    continue;
                }
                throw new IllegalArgumentException("Invalid property constraint " + string);
            }
            Constraint[] constraintArray2 = querySpec.resourceSpec.propertySpecs;
            for (int i = 0; i < constraintArray2.length; ++i) {
                String[] stringArray = constraintArray2[i].propertyNames;
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!stringArray[j].equals(Util.MIGRATION_HISTORY)) continue;
                    this.eventFilterSpec.eventTypeId = new String[]{Util.VM_DEST_MIGRATION_EVENT};
                    this.migrationHistoryRequest = true;
                    return;
                }
            }
        }
    }

    private String[] createStringArray(Object[] objectArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            return null;
        }
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    private ManagedObjectReference[] createMORArray(Object[] objectArray) {
        ManagedObjectReference[] managedObjectReferenceArray = new ManagedObjectReference[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            managedObjectReferenceArray[i] = (ManagedObjectReference)objectArray[i];
        }
        return managedObjectReferenceArray;
    }

    private EventFilterSpec.RecursionOption getRecursionOption(String string) {
        if (string.equals("recursion.self")) {
            return EventFilterSpec.RecursionOption.self;
        }
        if (string.equals("recursion.children")) {
            return EventFilterSpec.RecursionOption.children;
        }
        return EventFilterSpec.RecursionOption.all;
    }

    private boolean requiresAllResults(Integer n) {
        return n == null || n == -1;
    }
}

