/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.as.model;

import com.vmware.vide.vwcsdktools.as.parser.AsToken;
import com.vmware.vide.vwcsdktools.as.parser.IdentifierToken;
import com.vmware.vide.vwcsdktools.as.parser.KeywordToken;
import com.vmware.vide.vwcsdktools.as.parser.NumberLiteralToken;
import com.vmware.vide.vwcsdktools.as.parser.StringLiteralToken;

public class MetadataTagParameter {
    IdentifierToken name;
    AsToken value;

    MetadataTagParameter(IdentifierToken name, AsToken value) {
        this.name = name;
        this.value = value;
    }

    public boolean isNamed() {
        return !this.name.getName().equals("_unnamed_");
    }

    public AsToken getName() {
        return this.name;
    }

    public AsToken getValue() {
        return this.value;
    }

    public String getParameterName() {
        return this.name.getName();
    }

    public String getSimpleName() {
        if (this.isNamed()) {
            return this.name.getName();
        }
        return "";
    }

    public String getSimpleValue() {
        if (this.value.isStringLiteral()) {
            return ((StringLiteralToken)this.value).getString();
        }
        if (this.value.isIdentifier()) {
            return ((IdentifierToken)this.value).getName();
        }
        if (this.value.isValueKeyword()) {
            return ((KeywordToken)this.value).getKeyword().getName();
        }
        if (this.value.isNumberLiteral()) {
            return ((NumberLiteralToken)this.value).getNumber();
        }
        return "";
    }
}

