/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.as.parser;

import com.vmware.vide.vwcsdktools.as.model.MetadataTag;
import com.vmware.vide.vwcsdktools.as.parser.AsToken;
import com.vmware.vide.vwcsdktools.as.parser.BufferError;
import com.vmware.vide.vwcsdktools.as.parser.IdentifierToken;
import com.vmware.vide.vwcsdktools.as.parser.Keyword;
import com.vmware.vide.vwcsdktools.as.parser.KeywordToken;
import com.vmware.vide.vwcsdktools.as.parser.Tokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;

public class ActionScriptMetadataTag {
    private static final String ERR_INVALID_TAG_NAME = "Invalid tag name.";
    private static final String ERR_UNMATCH = "Unmatch to tag end.";
    private static final String ERR_BAD_PARAMETER_VALUE = "Bad parameter value.";
    private static final String ERR_MISSING_PARAMETER_VALUE = "Missing parameter value.";
    private static final String ERR_INVALID_CHARACTERS_APPENDED = "Extra characters found. End of annotation character ']' expected.";
    private static final String ERR_MISSING_PARAMETER_END = "Missing close parenthesis for parameters.";
    Tokenizer tokenizer;
    List<AsToken> tokens;
    ListIterator<AsToken> it;
    private final Map<AsToken, String> errors = new HashMap<AsToken, String>();
    AsToken currentTagStart;
    List<MetadataTag> metadataTags = new ArrayList<MetadataTag>();

    public ActionScriptMetadataTag(IFile file) throws IOException, BufferError {
        String filePath = file.getLocation().toOSString();
        this.tokenizer = new Tokenizer(filePath, "UTF-8");
        this.tokenizer.parse();
        this.parse();
    }

    private boolean canHaveInTag(AsToken token) {
        return token.isComma() || token.isComment() || token.isEolSeparator() || token.isEqual() || token.isIdentifier() || token.isNumberLiteral() || token.isStringLiteral() || token.isLeftParenthesis() || token.isRightParenthesis();
    }

    private void skipToMetadataEnd() {
        while (this.it.hasNext()) {
            AsToken token = this.it.next();
            if (token.isMetadataEnd()) {
                return;
            }
            if (this.canHaveInTag(token)) continue;
            this.it.previous();
            break;
        }
        this.getErrors().put(this.currentTagStart, ERR_UNMATCH);
    }

    private boolean lookForMetadataEnd(MetadataTag tag) {
        while (this.it.hasNext()) {
            AsToken token = this.it.next();
            if (token.isComment() || token.isEolSeparator()) continue;
            if (token.isMetadataEnd()) {
                tag.setRange(this.currentTagStart, token);
                return true;
            }
            this.getErrors().put(token, ERR_INVALID_CHARACTERS_APPENDED);
            this.it.previous();
            break;
        }
        return false;
    }

    private void skipToEndOfParameters() {
        AsToken token = null;
        while (this.it.hasNext()) {
            token = this.it.next();
            if (token.isRightParenthesis()) {
                return;
            }
            if (this.canHaveInTag(token)) continue;
            this.it.previous();
            break;
        }
        this.getErrors().put(token, ERR_MISSING_PARAMETER_END);
    }

    private void parseParameters(MetadataTag tag) {
        AsToken nameToken = null;
        ParameterState state = ParameterState.START;
        block9: while (this.it.hasNext()) {
            AsToken token = this.it.next();
            if (token.isComment() || token.isEolSeparator()) continue;
            switch (state) {
                case START: {
                    if (token.isIdentifier()) {
                        state = ParameterState.NAME_OR_VALUE;
                        nameToken = token;
                        break;
                    }
                    if (token.isNumberLiteral() || token.isStringLiteral() || token.isValueKeyword()) {
                        state = ParameterState.VALUE;
                        tag.addUnnamedParameterValue(token);
                        break;
                    }
                    if (token.isRightParenthesis()) {
                        state = ParameterState.END;
                        break;
                    }
                    this.getErrors().put(token, ERR_BAD_PARAMETER_VALUE);
                    break block9;
                }
                case VALUE: {
                    if (token.isComma()) {
                        state = ParameterState.COMMA;
                        break;
                    }
                    if (token.isRightParenthesis()) {
                        state = ParameterState.END;
                        break;
                    }
                    this.getErrors().put(token, ERR_BAD_PARAMETER_VALUE);
                    break block9;
                }
                case NAME_OR_VALUE: {
                    if (token.isComma()) {
                        state = ParameterState.COMMA;
                        tag.addUnnamedParameterValue(nameToken);
                        break;
                    }
                    if (token.isEqual()) {
                        state = ParameterState.EQUAL;
                        break;
                    }
                    if (token.isRightParenthesis()) {
                        state = ParameterState.END;
                        tag.addUnnamedParameterValue(nameToken);
                        break;
                    }
                    this.getErrors().put(token, ERR_BAD_PARAMETER_VALUE);
                    break block9;
                }
                case COMMA: {
                    if (token.isIdentifier()) {
                        state = ParameterState.NAME_OR_VALUE;
                        nameToken = token;
                        break;
                    }
                    if (token.isNumberLiteral() || token.isStringLiteral() || token.isValueKeyword()) {
                        state = ParameterState.VALUE;
                        tag.addUnnamedParameterValue(token);
                        break;
                    }
                    if (token.isRightParenthesis()) {
                        this.getErrors().put(token, ERR_MISSING_PARAMETER_VALUE);
                        return;
                    }
                    this.getErrors().put(token, ERR_BAD_PARAMETER_VALUE);
                    break block9;
                }
                case EQUAL: {
                    if (token.isIdentifier() || token.isNumberLiteral() || token.isStringLiteral() || token.isValueKeyword()) {
                        state = ParameterState.NAMED_VALUE;
                        tag.addNamedParameterValue((IdentifierToken)nameToken, token);
                        break;
                    }
                    if (token.isRightParenthesis()) {
                        this.getErrors().put(token, ERR_MISSING_PARAMETER_VALUE);
                        return;
                    }
                    this.getErrors().put(token, ERR_BAD_PARAMETER_VALUE);
                    break block9;
                }
                case NAMED_VALUE: {
                    if (token.isComma()) {
                        state = ParameterState.COMMA;
                        break;
                    }
                    if (token.isRightParenthesis()) {
                        state = ParameterState.END;
                        break;
                    }
                    this.getErrors().put(token, ERR_BAD_PARAMETER_VALUE);
                    break block9;
                }
                case END: {
                    this.it.previous();
                    if (this.lookForMetadataEnd(tag)) {
                        this.metadataTags.add(tag);
                    }
                    return;
                }
                default: {
                    this.skipToEndOfParameters();
                }
            }
        }
    }

    private void parseMetadata() {
        AsToken token;
        MetadataTag tag = null;
        while (this.it.hasNext()) {
            token = this.it.next();
            if (token.isComment() || token.isEolSeparator()) continue;
            if (token.isIdentifier()) {
                tag = new MetadataTag((IdentifierToken)token);
                break;
            }
            if (token.isMetadataEnd()) {
                return;
            }
            this.getErrors().put(token, ERR_INVALID_TAG_NAME);
            this.skipToMetadataEnd();
            return;
        }
        while (this.it.hasNext()) {
            token = this.it.next();
            if (token.isComment() || token.isEolSeparator()) continue;
            if (token.isMetadataEnd()) {
                tag.setRange(this.currentTagStart, token);
                this.metadataTags.add(tag);
                return;
            }
            if (token.isLeftParenthesis()) {
                this.parseParameters(tag);
                return;
            }
            if (!token.isEqual()) continue;
            while (this.it.hasNext()) {
                token = this.it.next();
                if (token.isComment() || token.isEolSeparator()) continue;
                if (token.isIdentifier() || token.isStringLiteral() || token.isNumberLiteral()) {
                    tag.addUnnamedParameterValue(token);
                    if (this.lookForMetadataEnd(tag)) {
                        this.metadataTags.add(tag);
                    }
                    return;
                }
                if (token.isMetadataEnd()) {
                    this.getErrors().put(token, ERR_MISSING_PARAMETER_VALUE);
                    return;
                }
                this.getErrors().put(token, ERR_BAD_PARAMETER_VALUE);
                this.skipToMetadataEnd();
                return;
            }
        }
    }

    private void parse() {
        List<AsToken> tokens = this.tokenizer.getTokens();
        this.it = tokens.listIterator();
        while (this.it.hasNext()) {
            AsToken token = this.it.next();
            if (token.isMetadataStart()) {
                this.currentTagStart = token;
                this.parseMetadata();
                continue;
            }
            if (token.isKeyword()) {
                KeywordToken kt = (KeywordToken)token;
                Keyword keyword = kt.getKeyword();
                switch (keyword) {
                    case PACKAGE: {
                        break;
                    }
                    case CLASS: {
                        break;
                    }
                    case VAR: {
                        break;
                    }
                }
                continue;
            }
            if (!token.isLeftBrace() && !token.isRightBrace()) continue;
        }
    }

    public List<MetadataTag> getMetadataTags() {
        return this.metadataTags;
    }

    public Map<AsToken, String> getErrors() {
        return this.errors;
    }

    public static IdentifierToken createInternalName(AsToken token) {
        return new IdentifierToken(token.getStartLine(), token.getStartColumn(), 0, "_unnamed_");
    }

    static enum ParameterState {
        START,
        END,
        VALUE,
        COMMA,
        NAME_OR_VALUE,
        EQUAL,
        NAMED_VALUE;

    }
}

