/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.managers;

import com.vmware.vide.vwcsdktools.exceptions.ParseFileException;
import com.vmware.vide.vwcsdktools.managers.CheckRule;
import com.vmware.vide.vwcsdktools.managers.CheckTypeRule;
import com.vmware.vide.vwcsdktools.managers.DiagnosticLevel;
import com.vmware.vide.vwcsdktools.managers.ParameterRule;
import com.vmware.vide.vwcsdktools.processors.CheckType;
import com.vmware.vide.vwcsdktools.utils.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckRuleFileLoader {
    private static final String PARAMETER_RULE_REGEXP = "(white|class|remoteJavaClass)\\[(Error|Warning|Ignore|E|W|I)\\](=([\\w\\d_\\.\\-]+(,[\\w\\d_\\.\\-]+)*))?";
    private static final Pattern parameterRulePattern = Pattern.compile("(white|class|remoteJavaClass)\\[(Error|Warning|Ignore|E|W|I)\\](=([\\w\\d_\\.\\-]+(,[\\w\\d_\\.\\-]+)*))?");
    private final File file;
    private final InputStream is;
    private int line;
    private final Context context = new Context();

    public CheckRuleFileLoader(String fileName) throws FileNotFoundException {
        this(fileName, new FileInputStream(fileName));
    }

    public CheckRuleFileLoader(String fileName, InputStream is) {
        this.file = new File(fileName);
        this.is = is;
        this.line = 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<CheckRule> parse() {
        ArrayList<CheckRule> rules = new ArrayList<CheckRule>();
        BufferedReader br = null;
        try {
            try {
                int cc;
                br = new BufferedReader(new InputStreamReader(this.is, "UTF-8"));
                while ((cc = br.read()) != -1) {
                    if (this.isSpace(cc)) {
                        if (cc == 10) {
                            ++this.line;
                        }
                        this.skipSpaces(br);
                        continue;
                    }
                    if (this.isCommentStart(cc)) {
                        this.skipComments(br);
                        continue;
                    }
                    if (cc != 64) continue;
                    try {
                        this.context.setAnnotationLine(this.line);
                        String[] annotation = new String[1];
                        cc = this.readAnnotation(br, annotation);
                        this.context.setAnnotationName(annotation[0]);
                        CheckRule rule = new CheckRule(annotation[0]);
                        cc = this.processAnnotation(br, rule);
                        rules.add(rule);
                    }
                    catch (ParseFileException e) {
                        Logger.error(e);
                        this.skipToNextRuleEntry(br);
                    }
                }
                return rules;
            }
            catch (FileNotFoundException e) {
                Logger.error(e);
                if (br == null) return rules;
                try {
                    br.close();
                    return rules;
                }
                catch (IOException e2) {
                    Logger.error(e2);
                }
                return rules;
            }
            catch (IOException e) {
                Logger.error(e);
                if (br == null) return rules;
                try {
                    br.close();
                    return rules;
                }
                catch (IOException e3) {
                    Logger.error(e3);
                }
                return rules;
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    Logger.error(e);
                }
            }
        }
    }

    private void skipToNextRuleEntry(BufferedReader br) throws IOException {
        while (true) {
            br.mark(1);
            int cc = br.read();
            if (cc == -1 || cc == 64) break;
            if (cc != 10) continue;
            ++this.line;
        }
        br.reset();
    }

    private int processAnnotation(BufferedReader br, CheckRule rule) throws IOException, ParseFileException {
        int cc;
        br.mark(1);
        while ((cc = br.read()) != -1) {
            if (this.isSpace(cc)) {
                if (cc == 10) {
                    ++this.line;
                }
                this.skipSpaces(br);
                br.mark(1);
                continue;
            }
            if (this.isCommentStart(cc)) {
                this.skipComments(br);
                br.mark(1);
                continue;
            }
            if (cc == 58) {
                this.context.setAnnotationParameterLine(this.line);
                String parameterName = this.readAnnotationParameter(br);
                if (parameterName.isEmpty()) {
                    throw new ParseFileException(String.format("Missing parameter for the annotation [%s]", rule.name), this.file, this.context.lineAnnotation);
                }
                this.context.setAnnotationParameterName(parameterName);
                ParameterRule parameterRule = new ParameterRule(parameterName);
                this.processAnnotationParameterRule(br, parameterRule);
                rule.parameterRules.add(parameterRule);
                br.mark(1);
                continue;
            }
            if (cc == 64) break;
            throw new ParseFileException(String.format("Unexpected character [%c] is used in the parameter in the annotation [%s].", Character.valueOf((char)cc), rule.name), this.file, this.line);
        }
        br.reset();
        return 0;
    }

    private int processAnnotationParameterRule(BufferedReader br, ParameterRule parameterRule) throws IOException, ParseFileException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            br.mark(1);
            int cc = br.read();
            if (this.isSpace(cc)) {
                if (cc == 10) {
                    ++this.line;
                }
                this.skipSpaces(br);
                continue;
            }
            if (this.isCommentStart(cc)) {
                this.skipComments(br);
                continue;
            }
            if (cc == 59) {
                this.processParameterRuleExpression(sb.toString(), parameterRule);
                sb.setLength(0);
                continue;
            }
            if (cc == 58) {
                this.processParameterRuleExpression(sb.toString(), parameterRule);
                break;
            }
            if (cc == 64) {
                this.processParameterRuleExpression(sb.toString(), parameterRule);
                break;
            }
            if (cc == -1) {
                this.processParameterRuleExpression(sb.toString(), parameterRule);
                break;
            }
            this.context.setCheckTypeExpressionLine(this.line);
            sb.append((char)cc);
        }
        br.reset();
        return 0;
    }

    private void processParameterRuleExpression(String parameterRuleExp, ParameterRule parameterRule) throws ParseFileException {
        if (parameterRuleExp.isEmpty()) {
            return;
        }
        Matcher m = parameterRulePattern.matcher(parameterRuleExp);
        if (m.matches()) {
            this.processParameterRuleExpression(parameterRule, m);
            return;
        }
        throw new ParseFileException(String.format("Bad parameter check type expression [%s] in the parameter [%s] of the annotation [%s].", parameterRuleExp, parameterRule.name, this.context.annotationName), this.file, this.context.lineCheckTypeExpression);
    }

    private void processParameterRuleExpression(ParameterRule parameterRule, Matcher m) throws ParseFileException {
        CheckType type = this.getCheckType(m.group(1));
        DiagnosticLevel level = this.getDiagnosticLevel(m.group(2));
        ArrayList<String> options = new ArrayList<String>();
        if (m.group(4) != null) {
            String[] stringArray = m.group(4).split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String op = stringArray[n2];
                options.add(op);
                ++n2;
            }
        }
        CheckTypeRule checkType = new CheckTypeRule(type, level, options);
        parameterRule.checkTypes.add(checkType);
    }

    private String readAnnotationParameter(BufferedReader br) throws IOException, ParseFileException {
        int cc;
        br.mark(1);
        StringBuilder sb = new StringBuilder();
        block0: while ((cc = br.read()) != -1) {
            if (this.isSpace(cc)) {
                if (cc == 10) {
                    ++this.line;
                }
                this.skipSpaces(br);
                continue;
            }
            if (this.isCommentStart(cc)) {
                this.skipComments(br);
                continue;
            }
            if (Character.isJavaIdentifierStart(cc)) {
                this.context.setAnnotationParameterLine(this.line);
                sb.append((char)cc);
                br.mark(1);
                while ((cc = br.read()) != -1) {
                    if (Character.isJavaIdentifierPart(cc)) {
                        br.mark(1);
                        sb.append((char)cc);
                        continue;
                    }
                    if (this.isSpace(cc)) break block0;
                    throw new ParseFileException(String.format("Invalid character [%c] in the parameter of the annotation [%s].", Character.valueOf((char)cc), this.context.annotationName), this.file, this.line);
                }
                break;
            }
            throw new ParseFileException(String.format("The parameter starts with invalid character [%c] in the annotation [%s].", Character.valueOf((char)cc), this.context.annotationName), this.file, this.line);
        }
        br.reset();
        return sb.toString();
    }

    private boolean isSpace(int cc) {
        return cc == 32 || cc == 10 || cc == 13 || cc == 9;
    }

    private boolean isCommentStart(int cc) {
        return cc == 35;
    }

    private int readAnnotation(BufferedReader br, String[] annotation) throws IOException, ParseFileException {
        int cc = br.read();
        if (!Character.isJavaIdentifierStart(cc)) {
            throw new ParseFileException(String.format("Unexpected character [%c] is used in the annotation.", Character.valueOf((char)cc)), this.file, this.line);
        }
        StringBuilder sb = new StringBuilder();
        sb.append((char)cc);
        br.mark(1);
        while ((cc = br.read()) != -1) {
            if (!Character.isJavaIdentifierPart(cc) && cc != 46) break;
            br.mark(1);
            sb.append((char)cc);
        }
        br.reset();
        annotation[0] = sb.toString();
        return cc;
    }

    private int skipSpaces(BufferedReader br) throws IOException {
        int cc;
        br.mark(1);
        while ((cc = br.read()) != -1) {
            if (cc == 32 || cc == 9 || cc == 13) {
                br.mark(1);
                continue;
            }
            if (cc != 10) break;
            ++this.line;
            br.mark(1);
        }
        br.reset();
        return cc;
    }

    private int skipComments(BufferedReader br) throws IOException {
        int cc;
        while ((cc = br.read()) != -1) {
            if (cc != 10) continue;
            ++this.line;
            break;
        }
        return cc;
    }

    private CheckType getCheckType(String type) throws ParseFileException {
        if ("white".equals(type)) {
            return CheckType.WHITE_LIST;
        }
        if ("class".equals(type)) {
            return CheckType.EXIST_CLASSES;
        }
        if ("remoteJavaClass".equals(type)) {
            return CheckType.REMOTE_JAVA_CLASSES;
        }
        throw new ParseFileException(String.format("Bad check type [%s] is specified for the parameter[%s] of the annotation [%s].", type, this.context.parameterName, this.context.annotationName), this.file, this.line);
    }

    private DiagnosticLevel getDiagnosticLevel(String levelName) throws ParseFileException {
        if (this.comparePartial("Error", levelName)) {
            return DiagnosticLevel.ERROR;
        }
        if (this.comparePartial("Warning", levelName)) {
            return DiagnosticLevel.WARNING;
        }
        if (this.comparePartial("Ignore", levelName)) {
            return DiagnosticLevel.IGNORE;
        }
        throw new ParseFileException(String.format("Invalid diagnostic level [%s] for the parameter [%s] of the annotation [%s].", levelName, this.context.parameterName, this.context.annotationName), this.file, this.line);
    }

    private boolean comparePartial(String s1, String s2) {
        if (s1 == null || s1.length() < 1 || s2 == null || s2.length() < 1) {
            return false;
        }
        if (s2.length() > s1.length()) {
            return false;
        }
        int i = 0;
        while (i < s2.length()) {
            if (s2.charAt(i) != s1.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    class Context {
        String annotationName = "";
        int lineAnnotation = -1;
        String parameterName = "";
        int lineParameter = -1;
        int lineCheckTypeExpression = -1;

        Context() {
        }

        void setAnnotationLine(int line) {
            this.lineAnnotation = line;
            this.annotationName = "";
            this.parameterName = "";
            this.lineParameter = -1;
            this.lineCheckTypeExpression = -1;
        }

        void setAnnotationName(String name) {
            this.annotationName = name;
        }

        public void setAnnotationParameterLine(int line) {
            this.lineParameter = line;
            this.parameterName = "";
            this.lineCheckTypeExpression = -1;
        }

        public void setAnnotationParameterName(String name) {
            this.parameterName = name;
        }

        public void setCheckTypeExpressionLine(int line) {
            this.lineCheckTypeExpression = line;
        }
    }
}

