/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.managers;

import com.vmware.vide.vwcsdktools.Activator;
import com.vmware.vide.vwcsdktools.as.checkers.MetadataTagCheckResult;
import com.vmware.vide.vwcsdktools.as.checkers.MetadataTagProblem;
import com.vmware.vide.vwcsdktools.as.checkers.MetadataTagProblemSolution;
import com.vmware.vide.vwcsdktools.as.checkers.MetadataTagProblemType;
import com.vmware.vide.vwcsdktools.as.model.MetadataTagParameter;
import com.vmware.vide.vwcsdktools.as.parser.AsToken;
import com.vmware.vide.vwcsdktools.as.parser.MultiLineToken;
import com.vmware.vide.vwcsdktools.managers.DiagnosticLevel;
import com.vmware.vide.vwcsdktools.managers.MetadataTagProjectDataManager;
import com.vmware.vide.vwcsdktools.managers.ProjectDataManager;
import com.vmware.vide.vwcsdktools.processors.CheckType;
import com.vmware.vide.vwcsdktools.processors.Problem;
import com.vmware.vide.vwcsdktools.processors.Results;
import com.vmware.vide.vwcsdktools.utils.JdtJre;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public enum ReportManager {
    INSTANCE;

    private final String MARKER_TYPE = "com.vmware.vide.vwcsdktools.metadata_tag_problem_marker";
    private ILog logger = Activator.getDefault().getLog();

    public void report(Results results) {
        List<Problem> problems = results.getProblems();
        for (Problem p : problems) {
            IProject project = JdtJre.getProject(p.getElement());
            String annotationName = p.getAnnotationMirror().toString().substring(1);
            String parameterName = p.getExecutableElement().getSimpleName().toString();
            DiagnosticLevel level = ProjectDataManager.INSTANCE.getDiagnosticLevel(project, annotationName, parameterName, p.getCheckType());
            String message = p.getMessage();
            Element element = p.getElement();
            AnnotationMirror am = p.getAnnotationMirror();
            AnnotationValue av = p.getAnnotationValue();
            if (level == DiagnosticLevel.IGNORE) continue;
            p.getMessager().printMessage(level.getKind(), message, element, am, av);
        }
    }

    public void reportMetadataTagParseErrors(IFile file, Map<AsToken, String> errors) {
    }

    public void reportMetadataTagCheckResults(List<MetadataTagCheckResult> results) {
        HashSet<IPath> bufferedPaths = new HashSet<IPath>();
        for (MetadataTagCheckResult result : results) {
            List<MetadataTagProblem> problems = result.getProblems();
            for (MetadataTagProblem problem : problems) {
                IMarker marker;
                DiagnosticLevel level = this.getDiagnosticLevel(problem);
                if (level == DiagnosticLevel.IGNORE || (marker = this.setMarker(problem, level, bufferedPaths)) == null) continue;
                this.setSolution(marker, problem);
            }
        }
        this.disconnectDocuments(bufferedPaths);
    }

    private void setSolution(IMarker marker, MetadataTagProblem problem) {
        if (problem.getCheckType() == CheckType.WHITE_LIST) {
            try {
                marker.setAttribute("metadata_tag_problem_solution_type", MetadataTagProblemSolution.PARAMETER_VALUE_WHITE_LIST.ordinal());
            }
            catch (CoreException coreException) {}
        }
    }

    private void setProblem(IMarker marker, MetadataTagProblem problem) {
        try {
            marker.setAttribute("com.vmware.vide.vwcsdktools.metadata_tag_problem_marker_attr.checktype", problem.getCheckType().ordinal());
            MetadataTagParameter param = problem.getParameter();
            marker.setAttribute("com.vmware.vide.vwcsdktools.metadata_tag_problem_marker_attr.parameter.name", (Object)param.getSimpleName());
            marker.setAttribute("com.vmware.vide.vwcsdktools.metadata_tag_problem_marker_attr.parameter.value", (Object)param.getSimpleValue());
            marker.setAttribute("com.vmware.vide.vwcsdktools.metadata_tag_problem_marker_attr.parameter.value_is_quoted_string", param.getValue().isStringLiteral());
            marker.setAttribute("com.vmware.vide.vwcsdktools.metadata_tag_problem_marker_attr.tag.name", (Object)problem.getTag().getName());
            marker.setAttribute("com.vmware.vide.vwcsdktools.metadata_tag_problem_marker_attr.problem.type", problem.getType().ordinal());
            marker.setAttribute("com.vmware.vide.vwcsdktools.metadata_tag_problem_marker_attr.checkrule.type", problem.getRule().getType().ordinal());
            StringBuilder sb = new StringBuilder();
            List<String> options = problem.getRule().getOptions();
            if (!options.isEmpty()) {
                for (String opt : options) {
                    sb.append(opt);
                    sb.append(',');
                }
                sb.setLength(sb.length() - 1);
            }
            marker.setAttribute("com.vmware.vide.vwcsdktools.metadata_tag_problem_marker_attrcheckrule.options", (Object)sb.toString());
        }
        catch (CoreException e) {
            this.logger.log((IStatus)new Status(4, "com.vmware.vide.vwcsdktools", null, (Throwable)e));
        }
    }

    private IMarker setMarker(MetadataTagProblem problem, DiagnosticLevel level, Set<IPath> bufferedPaths) {
        IMarker marker = null;
        try {
            marker = problem.getFile().createMarker("com.vmware.vide.vwcsdktools.metadata_tag_problem_marker");
            marker.setAttribute("message", (Object)problem.getMessage());
            Range range = this.calculateValueRange(problem, bufferedPaths);
            if (range != null) {
                marker.setAttribute("charStart", range.charStart);
                marker.setAttribute("charEnd", range.charEnd);
            }
            marker.setAttribute("lineNumber", problem.getParameter().getValue().getStartLine() + 1);
            marker.setAttribute("severity", this.getServerity(level));
            marker.setAttribute("location", (Object)problem.getFile().getFullPath().toString());
            this.setProblem(marker, problem);
        }
        catch (CoreException e) {
            this.logger.log((IStatus)new Status(4, "com.vmware.vide.vwcsdktools", null, (Throwable)e));
        }
        return marker;
    }

    private DiagnosticLevel getDiagnosticLevel(MetadataTagProblem problem) {
        IFile file = problem.getFile();
        String tag = problem.getTag().getName();
        String param = problem.getParameter().getParameterName();
        if (problem.getType() == MetadataTagProblemType.NO_JAVA_PROJECT) {
            return DiagnosticLevel.WARNING;
        }
        return MetadataTagProjectDataManager.INSTANCE.getDiagnosticLevel(file, tag, param, problem.getCheckType());
    }

    private int getServerity(DiagnosticLevel level) {
        switch (level) {
            case ERROR: {
                return 2;
            }
            case WARNING: {
                return 1;
            }
        }
        return 0;
    }

    private void disconnectDocuments(Set<IPath> paths) {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        for (IPath path : paths) {
            try {
                manager.disconnect(path, LocationKind.IFILE, null);
            }
            catch (CoreException coreException) {}
        }
    }

    private Range calculateValueRange(MetadataTagProblem problem, Set<IPath> paths) {
        Range range = null;
        IPath path = problem.getFile().getFullPath();
        AsToken token = problem.getParameter().getValue();
        int startLine = token.getStartLine();
        int startColumn = token.getStartColumn();
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        try {
            manager.connect(path, LocationKind.IFILE, null);
            ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.IFILE);
            if (buffer != null) {
                MultiLineToken mt;
                paths.add(path);
                IDocument doc = buffer.getDocument();
                int startLineOffset = doc.getLineOffset(startLine);
                int start = startLineOffset + startColumn;
                int len = token.getLength();
                int end = start + len;
                if (token.isMultiLine() && (mt = (MultiLineToken)token).getLastLine() != startLine) {
                    end = doc.getLineOffset(mt.getLastLine()) + mt.getEndColumn();
                }
                if (token.isStringLiteral()) {
                    ++start;
                    --end;
                }
                range = new Range(start, end);
            }
        }
        catch (CoreException e) {
            this.logger.log((IStatus)new Status(4, "com.vmware.vide.vwcsdktools", null, (Throwable)e));
        }
        catch (BadLocationException e) {
            this.logger.log((IStatus)new Status(4, "com.vmware.vide.vwcsdktools", null, (Throwable)e));
        }
        return range;
    }

    static class Range {
        int charStart;
        int charEnd;

        Range(int start, int end) {
            this.charStart = start;
            this.charEnd = end;
        }
    }
}

