/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.processors;

import com.vmware.vide.vwcsdktools.processors.AnnotationManager;
import com.vmware.vide.vwcsdktools.processors.CheckType;
import com.vmware.vide.vwcsdktools.processors.IChecker;
import com.vmware.vide.vwcsdktools.processors.Results;
import com.vmware.vide.vwcsdktools.utils.JdtJre;
import com.vmware.vide.vwcsdktools.utils.LangUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class Checker
implements IChecker {
    private static final String ARRAY_QUALIFIER = "[]";
    private static final String JAVA_LANG_PACKAGE = "java.lang";
    private static final String STRING_SPLITTER = "\\s*,\\s*";
    private final AnnotationMirror am;
    private final ProcessingEnvironment processingEnv;
    private final RoundEnvironment roundEnv;

    Checker(AnnotationMirror am, ProcessingEnvironment processingEnv, RoundEnvironment roundEnv) {
        this.am = am;
        this.processingEnv = processingEnv;
        this.roundEnv = roundEnv;
    }

    @Override
    public Results run(Element e) {
        Results results = new Results();
        if (AnnotationManager.isCheckParameters(this.am, e)) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> ent : this.am.getElementValues().entrySet()) {
                ExecutableElement ee = ent.getKey();
                AnnotationValue av = ent.getValue();
                List<CheckType> checkTypes = AnnotationManager.getCheckTypes(this.am, ee, e);
                for (CheckType t : checkTypes) {
                    if (t == CheckType.WHITE_LIST) {
                        this.doCheckParameterWhiteList(this.am, e, ee, av, results);
                        continue;
                    }
                    if (t != CheckType.EXIST_CLASSES) continue;
                    this.doCheckParameterExistClasses(this.am, e, ee, av, results);
                }
            }
        }
        return results;
    }

    private void doCheckParameterExistClasses(AnnotationMirror am, Element e, ExecutableElement ee, AnnotationValue av, Results results) {
        IJavaProject javaProject = JdtJre.getJavaProject(e);
        if (javaProject != null) {
            String[] values;
            String[] stringArray = values = this.getValues(ee, av);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                try {
                    String className = this.parseType(value);
                    IType type = javaProject.findType(className);
                    if (type == null) {
                        String msg = String.format("Class [%s] not found on parameter [%s] of annotation [%s].", value, e.getSimpleName().toString(), am.toString());
                        results.add(this.processingEnv.getMessager(), msg, CheckType.EXIST_CLASSES, am, ee, av, e);
                    }
                }
                catch (JavaModelException e1) {
                    e1.printStackTrace();
                }
                ++n2;
            }
        }
    }

    private String parseType(String typeName) {
        while (typeName.endsWith(ARRAY_QUALIFIER)) {
            typeName = typeName.substring(0, typeName.length() - ARRAY_QUALIFIER.length());
        }
        if (this.isJavaLangType(typeName)) {
            return JAVA_LANG_PACKAGE + typeName;
        }
        return typeName;
    }

    private boolean isJavaLangType(String typeName) {
        return LangUtil.isJavaLangType(typeName);
    }

    private void doCheckParameterWhiteList(AnnotationMirror am, Element e, ExecutableElement ee, AnnotationValue av, Results results) {
        String[] values;
        Set<String> whitelist = AnnotationManager.getWhiteList(am, e, ee);
        String[] stringArray = values = this.getValues(ee, av);
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            if (!whitelist.contains(v)) {
                String msg = String.format("Bad parameter value [%s] on parameter [%s] of annotation [%s].", v, e.getSimpleName().toString(), am.toString());
                results.add(this.processingEnv.getMessager(), msg, CheckType.WHITE_LIST, am, ee, av, e);
            }
            ++n2;
        }
    }

    private String[] getValues(ExecutableElement ee, AnnotationValue av) {
        if (ee.getReturnType().getKind() == TypeKind.ARRAY) {
            List a = (List)av.getValue();
            ArrayList<String> results = new ArrayList<String>();
            for (AnnotationValue v : a) {
                results.add((String)v.getValue());
            }
            return results.toArray(new String[results.size()]);
        }
        return av.toString().split(STRING_SPLITTER);
    }
}

