/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.whitelist;

import com.vmware.vide.vwcsdktools.Activator;
import com.vmware.vide.vwcsdktools.exceptions.ParseFileException;
import com.vmware.vide.vwcsdktools.whitelist.WhiteListFileLoader;
import com.vmware.vide.vwcsdktools.whitelist.WhiteListItem;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public enum WhiteListManager {
    ANNOTATION_INSTANCE("/resources/annotations.whitelist", "annotations.whitelist"),
    METADATA_TAG_INSTANCE("/resources/metadata-tags.whitelist", "metadata-tags.whitelist");

    private static ILog logger;
    private String whiteListResourcePath;
    private String whiteListFileName;
    private List<WhiteListItem> whiteList;

    static {
        logger = Activator.getDefault().getLog();
    }

    private WhiteListManager(String whiteListResourcePath, String whiteListFileName) {
        this.whiteListResourcePath = whiteListResourcePath;
        this.whiteListFileName = whiteListFileName;
        this.init();
    }

    private void init() {
        File f = this.getWorkspaceWhiteListFile();
        if (f == null) {
            throw new IllegalStateException("Could not get the white list file in the workspace.");
        }
        List<WhiteListItem> list = this.load(f.getAbsolutePath());
        if (list == null) {
            throw new IllegalStateException("Failed to parse the white list file.");
        }
        this.whiteList = list;
    }

    public List<WhiteListItem> load(String fileName) {
        File f = new File(fileName);
        WhiteListFileLoader loader = null;
        try {
            loader = new WhiteListFileLoader(f);
            return loader.parse();
        }
        catch (ParseFileException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void dump(List<WhiteListItem> items) {
        for (WhiteListItem i : items) {
            i.dump();
            System.out.println();
        }
    }

    private File getWorkspaceWhiteListFile() {
        File f = Activator.getDefault().getStateLocation().append(this.whiteListFileName).toFile();
        if (!f.exists()) {
            try {
                Activator.getDefault().copyFileFromPluginRegistry(f, this.whiteListResourcePath);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return f;
    }

    public List<WhiteListItem> getWorkspaceWhiteList() {
        return this.whiteList;
    }

    public List<WhiteListItem> getDefaultWorkspaceWhiteList() {
        WhiteListFileLoader loader = null;
        try {
            loader = new WhiteListFileLoader(this.whiteListResourcePath, Activator.getDefault().getResourceAsStream(this.whiteListResourcePath));
        }
        catch (ParseFileException e) {
            e.printStackTrace();
            return null;
        }
        return loader.parse();
    }

    public List<WhiteListItem> loadWhiteListFiles(String whitelist_dir) {
        ArrayList<WhiteListItem> items = new ArrayList<WhiteListItem>();
        File dir = new File(whitelist_dir);
        if (dir.isDirectory() && dir.canRead()) {
            Object[] files = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".whitelist") && pathname.isFile();
                }
            });
            Arrays.sort(files);
            Object[] objectArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                Object f = objectArray[n2];
                List<WhiteListItem> l = this.load(((File)f).getAbsolutePath());
                if (l != null) {
                    items.addAll(l);
                }
                ++n2;
            }
        }
        return items;
    }

    public List<WhiteListItem> loadProjectWhiteListFile(IProject project) {
        File f = project.getLocation().append(".vwcsdktools").append(this.whiteListFileName).toFile();
        return this.load(f.getAbsolutePath());
    }

    public void writeToWorkspaceWhiteListFile(Map<String, Set<String>> workspaceWhiteLists) {
        File f = Activator.getDefault().getStateLocation().append(this.whiteListFileName).toFile();
        this.writeToWhiteListFile(f, workspaceWhiteLists);
    }

    private void writeToWhiteListFile(File file, Map<String, Set<String>> workspaceWhiteLists) {
        block18: {
            BufferedWriter writer = null;
            try {
                try {
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                    writer = new BufferedWriter(osw);
                    for (Map.Entry<String, Set<String>> entry : workspaceWhiteLists.entrySet()) {
                        writer.write(entry.getKey());
                        writer.newLine();
                        writer.append('[');
                        writer.newLine();
                        for (String word : entry.getValue()) {
                            if (this.needQuoted(word)) {
                                writer.write(34);
                                writer.write(word);
                                writer.write(34);
                            } else {
                                writer.write(word);
                            }
                            writer.newLine();
                        }
                        writer.write(93);
                        writer.newLine();
                        writer.newLine();
                    }
                    writer.flush();
                }
                catch (IOException e) {
                    logger.log((IStatus)new Status(4, "com.vmware.vide.vwcsdktools", null, (Throwable)e));
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean needQuoted(String word) {
        char cc = word.charAt(0);
        if (cc == '#' || cc == ']' || cc == '$' || Character.isWhitespace(cc)) {
            return true;
        }
        cc = word.charAt(word.length() - 1);
        return Character.isWhitespace(cc);
    }

    public boolean projectWhiteListFileExists(IProject project) {
        File f = project.getLocation().append(".vwcsdktools").append(this.whiteListFileName).toFile();
        return f.exists();
    }

    public void writeToProjectWhiteListFile(IProject project, Map<String, Set<String>> lists) {
        File dir = project.getLocation().append(".vwcsdktools").toFile();
        if (!dir.exists()) {
            dir.mkdir();
        }
        File file = new File(String.valueOf(dir.getAbsolutePath()) + File.separator + this.whiteListFileName);
        this.writeToWhiteListFile(file, lists);
    }
}

