/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.authz;

import com.vmware.cis.authz.PrivilegeDefinitions;
import com.vmware.cis.authz.PrivilegeProvider;
import com.vmware.cis.authz.PrivilegeTypes;
import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;

public class PrivilegeApiInterface
extends ApiInterfaceSkeleton {
    private PrivilegeProvider impl;

    public PrivilegeApiInterface() {
        this((Class<? extends PrivilegeProvider>)null);
    }

    public PrivilegeApiInterface(Class<? extends PrivilegeProvider> clazz) {
        this((PrivilegeProvider)PrivilegeApiInterface.createImplInstance(clazz, (String)"com.vmware.cis.authz.impl.PrivilegeImpl", PrivilegeProvider.class));
    }

    public PrivilegeApiInterface(PrivilegeProvider privilegeProvider) {
        super("com.vmware.cis.authz.privilege");
        Validate.notNull((Object)privilegeProvider);
        this.impl = privilegeProvider;
        this.registerMethod((ApiMethod)new CreateApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new UpdateApiMethod());
        this.registerMethod((ApiMethod)new DeleteApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new QueryApiMethod());
        this.registerMethod((ApiMethod)new BatchQueryApiMethod());
        this.registerMethod((ApiMethod)new HasPrivilegesApiMethod());
        this.registerMethod((ApiMethod)new BatchHasPrivilegesApiMethod());
    }

    private class BatchHasPrivilegesApiMethod
    extends ApiMethodSkeleton {
        public BatchHasPrivilegesApiMethod() {
            super(PrivilegeApiInterface.this.getIdentifier(), "batch_has_privileges", PrivilegeDefinitions.__batchHasPrivilegesInput, PrivilegeDefinitions.__batchHasPrivilegesOutput, PrivilegeApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PrivilegeDefinitions.__batchHasPrivilegesInput, PrivilegeApiInterface.this.getTypeConverter());
            PrivilegeTypes.BatchQuerySpec batchQuerySpec = (PrivilegeTypes.BatchQuerySpec)structValueExtractor.valueForField("query_spec");
            List list = (List)structValueExtractor.valueForField("privilege_ids");
            PrivilegeApiInterface.this.impl.batchHasPrivileges(batchQuerySpec, list, (AsyncContext<List<Boolean>>)new AsyncContextImpl(PrivilegeApiInterface.this.getTypeConverter(), PrivilegeDefinitions.__batchHasPrivilegesOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class HasPrivilegesApiMethod
    extends ApiMethodSkeleton {
        public HasPrivilegesApiMethod() {
            super(PrivilegeApiInterface.this.getIdentifier(), "has_privileges", PrivilegeDefinitions.__hasPrivilegesInput, PrivilegeDefinitions.__hasPrivilegesOutput, PrivilegeApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PrivilegeDefinitions.__hasPrivilegesInput, PrivilegeApiInterface.this.getTypeConverter());
            PrivilegeTypes.QuerySpec querySpec = (PrivilegeTypes.QuerySpec)structValueExtractor.valueForField("query_spec");
            List list = (List)structValueExtractor.valueForField("privilege_ids");
            PrivilegeApiInterface.this.impl.hasPrivileges(querySpec, list, (AsyncContext<Boolean>)new AsyncContextImpl(PrivilegeApiInterface.this.getTypeConverter(), PrivilegeDefinitions.__hasPrivilegesOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class BatchQueryApiMethod
    extends ApiMethodSkeleton {
        public BatchQueryApiMethod() {
            super(PrivilegeApiInterface.this.getIdentifier(), "batch_query", PrivilegeDefinitions.__batchQueryInput, PrivilegeDefinitions.__batchQueryOutput, PrivilegeApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PrivilegeDefinitions.__batchQueryInput, PrivilegeApiInterface.this.getTypeConverter());
            PrivilegeTypes.BatchQuerySpec batchQuerySpec = (PrivilegeTypes.BatchQuerySpec)structValueExtractor.valueForField("query_specs");
            PrivilegeApiInterface.this.impl.batchQuery(batchQuerySpec, (AsyncContext<List<List<String>>>)new AsyncContextImpl(PrivilegeApiInterface.this.getTypeConverter(), PrivilegeDefinitions.__batchQueryOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class QueryApiMethod
    extends ApiMethodSkeleton {
        public QueryApiMethod() {
            super(PrivilegeApiInterface.this.getIdentifier(), "query", PrivilegeDefinitions.__queryInput, PrivilegeDefinitions.__queryOutput, PrivilegeApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PrivilegeDefinitions.__queryInput, PrivilegeApiInterface.this.getTypeConverter());
            PrivilegeTypes.QuerySpec querySpec = (PrivilegeTypes.QuerySpec)structValueExtractor.valueForField("query_spec");
            PrivilegeApiInterface.this.impl.query(querySpec, (AsyncContext<List<String>>)new AsyncContextImpl(PrivilegeApiInterface.this.getTypeConverter(), PrivilegeDefinitions.__queryOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(PrivilegeApiInterface.this.getIdentifier(), "list", PrivilegeDefinitions.__listInput, PrivilegeDefinitions.__listOutput, PrivilegeApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            PrivilegeApiInterface.this.impl.list((AsyncContext<List<String>>)new AsyncContextImpl(PrivilegeApiInterface.this.getTypeConverter(), PrivilegeDefinitions.__listOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class DeleteApiMethod
    extends ApiMethodSkeleton {
        public DeleteApiMethod() {
            super(PrivilegeApiInterface.this.getIdentifier(), "delete", PrivilegeDefinitions.__deleteInput, PrivilegeDefinitions.__deleteOutput, PrivilegeApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PrivilegeDefinitions.__deleteInput, PrivilegeApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("id");
            PrivilegeApiInterface.this.impl.delete(string, (AsyncContext<Void>)new AsyncContextImpl(PrivilegeApiInterface.this.getTypeConverter(), PrivilegeDefinitions.__deleteOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class UpdateApiMethod
    extends ApiMethodSkeleton {
        public UpdateApiMethod() {
            super(PrivilegeApiInterface.this.getIdentifier(), "update", PrivilegeDefinitions.__updateInput, PrivilegeDefinitions.__updateOutput, PrivilegeApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PrivilegeDefinitions.__updateInput, PrivilegeApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("id");
            PrivilegeTypes.UpdateSpec updateSpec = (PrivilegeTypes.UpdateSpec)structValueExtractor.valueForField("update_spec");
            PrivilegeApiInterface.this.impl.update(string, updateSpec, (AsyncContext<Void>)new AsyncContextImpl(PrivilegeApiInterface.this.getTypeConverter(), PrivilegeDefinitions.__updateOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(PrivilegeApiInterface.this.getIdentifier(), "get", PrivilegeDefinitions.__getInput, PrivilegeDefinitions.__getOutput, PrivilegeApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PrivilegeDefinitions.__getInput, PrivilegeApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("id");
            PrivilegeApiInterface.this.impl.get(string, (AsyncContext<PrivilegeTypes.Info>)new AsyncContextImpl(PrivilegeApiInterface.this.getTypeConverter(), PrivilegeDefinitions.__getOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class CreateApiMethod
    extends ApiMethodSkeleton {
        public CreateApiMethod() {
            super(PrivilegeApiInterface.this.getIdentifier(), "create", PrivilegeDefinitions.__createInput, PrivilegeDefinitions.__createOutput, PrivilegeApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.alreadyExists;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, PrivilegeDefinitions.__createInput, PrivilegeApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("id");
            PrivilegeTypes.CreateSpec createSpec = (PrivilegeTypes.CreateSpec)structValueExtractor.valueForField("create_spec");
            PrivilegeApiInterface.this.impl.create(string, createSpec, (AsyncContext<Void>)new AsyncContextImpl(PrivilegeApiInterface.this.getTypeConverter(), PrivilegeDefinitions.__createOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }
}

