/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.chassisRackVSphere;

import com.vmware.samples.chassisRackVSphere.ChassisRackVSphereDataAdapter;
import com.vmware.samples.chassisRackVSphere.ModelObjectUriResolver;
import com.vmware.samples.chassisRackVSphere.model.Chassis;
import com.vmware.samples.chassisRackVSphere.model.ChassisInfo;
import com.vmware.samples.chassisRackVSphere.model.ModelObject;
import com.vmware.samples.chassisRackVSphere.model.Rack;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.vim.data.VimObjectReferenceService;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectStore {
    private static final int CHASSIS_COUNT = 10;
    private static final int RACK_COUNT = 3;
    private static final String CHASSIS_TYPE = ChassisRackVSphereDataAdapter.CHASSIS_TYPE;
    private static final String RACK_TYPE = ChassisRackVSphereDataAdapter.RACK_TYPE;
    private final Map<String, Chassis> _chassisMap = new HashMap<String, Chassis>(10);
    private final Map<String, Rack> _rackMap = new HashMap<String, Rack>(3);
    private static int _index = 0;
    private final VimObjectReferenceService _vimObjectRefService;
    private final ModelObjectUriResolver _uriResolver;

    private static boolean mapContainsName(Map<String, Chassis> map, String string) {
        for (String string2 : map.keySet()) {
            Chassis chassis = map.get(string2);
            if (!string.equals(chassis.getName())) continue;
            return true;
        }
        return false;
    }

    public ObjectStore(ModelObjectUriResolver modelObjectUriResolver, VimObjectReferenceService vimObjectReferenceService) {
        this._uriResolver = modelObjectUriResolver;
        this._vimObjectRefService = vimObjectReferenceService;
    }

    public void init() {
        Rack[] rackArray = new Rack[3];
        for (int i = 0; i < 3; ++i) {
            rackArray[i] = this.createRack("Rack " + (i + 1), "37.40, -122.14");
        }
        Chassis[] chassisArray = new Chassis[10];
        for (int i = 0; i < 10; ++i) {
            String[] stringArray = new String[]{"Chassis " + (i + 1), "Server_Type " + i % 3, "20in x 30in x 17in"};
            Rack rack = rackArray[i % 2];
            chassisArray[i] = this.createChassis(new ChassisInfo(stringArray), rack, false);
        }
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, ModelObject> getAllChassis() {
        Map<String, Chassis> map = this._chassisMap;
        synchronized (map) {
            return new HashMap<String, ModelObject>(this._chassisMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, ModelObject> getAllRacks() {
        Map<String, Rack> map = this._rackMap;
        synchronized (map) {
            return new HashMap<String, ModelObject>(this._rackMap);
        }
    }

    ModelObject getModelObject(URI uRI) {
        String string = this._uriResolver.getResourceType(uRI);
        String string2 = this._uriResolver.getUid(uRI);
        if (CHASSIS_TYPE.equals(string)) {
            return this.getChassis(string2);
        }
        if (RACK_TYPE.equals(string)) {
            return this.getRack(string2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Chassis getChassis(String string) {
        Map<String, Chassis> map = this._chassisMap;
        synchronized (map) {
            return this._chassisMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Rack getRack(String string) {
        Map<String, Rack> map = this._rackMap;
        synchronized (map) {
            return this._rackMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Chassis removeChassis(String string) {
        Map<String, Chassis> map = this._chassisMap;
        synchronized (map) {
            Rack rack;
            Chassis chassis = this._chassisMap.remove(string);
            if (chassis != null && (rack = chassis.getRack()) != null) {
                rack.removeChassis(chassis);
            }
            return chassis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Chassis createChassis(ChassisInfo chassisInfo, Rack rack, boolean bl) {
        Map<String, Chassis> map = this._chassisMap;
        synchronized (map) {
            if (bl && ObjectStore.mapContainsName(this._chassisMap, chassisInfo.name)) {
                return null;
            }
            String string = this._uriResolver.createResourceId("server1", "chassis-" + _index++);
            Chassis chassis = new Chassis(chassisInfo, rack, string);
            if (rack != null) {
                rack.addChassis(chassis);
            }
            URI uRI = chassis.getUri(this._uriResolver);
            String string2 = this._uriResolver.getUid(uRI);
            this._chassisMap.put(string2, chassis);
            return chassis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean replaceChassis(String string, ChassisInfo chassisInfo) {
        Map<String, Chassis> map = this._chassisMap;
        synchronized (map) {
            if (!this._chassisMap.containsKey(string)) {
                return false;
            }
            Chassis chassis = this._chassisMap.get(string);
            Rack rack = chassis.getRack();
            String string2 = chassis.getId();
            Chassis chassis2 = new Chassis(chassisInfo, rack, string2);
            assert (string.equals(this._uriResolver.getUid(chassis2.getUri(this._uriResolver))));
            this._chassisMap.put(string, chassis2);
            if (rack != null) {
                rack.replaceChassis(chassis, chassis2);
            }
            Object[] objectArray = chassis.getHosts();
            for (int i = 0; i < objectArray.length; ++i) {
                this.addHostToChassis(objectArray[i], string);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addHostToChassis(Object object, String string) {
        Map<String, Chassis> map = this._chassisMap;
        synchronized (map) {
            Chassis chassis = this._chassisMap.get(string);
            if (chassis == null) {
                return false;
            }
            for (Chassis chassis2 : this._chassisMap.values()) {
                if (chassis2 != chassis && chassis2.removeHost(object, (ObjectReferenceService)this._vimObjectRefService)) break;
            }
            return chassis.addHost(object, (ObjectReferenceService)this._vimObjectRefService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rack createRack(String string, String string2) {
        Map<String, Rack> map = this._rackMap;
        synchronized (map) {
            String string3 = this._uriResolver.createResourceId("server1", "rack-" + _index++);
            Rack rack = new Rack(string, string2, string3);
            URI uRI = rack.getUri(this._uriResolver);
            String string4 = this._uriResolver.getUid(uRI);
            this._rackMap.put(string4, rack);
            return rack;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> getObjectsByPropertyValue(String string, String string2, String string3) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (CHASSIS_TYPE.equals(string)) {
            Map<String, Chassis> map = this._chassisMap;
            synchronized (map) {
                for (Chassis chassis : this._chassisMap.values()) {
                    String string4;
                    Object object = chassis.getProperty(string2);
                    if (!(object instanceof String) || (string4 = ((String)object).toLowerCase()).indexOf(string3) < 0) continue;
                    arrayList.add(chassis);
                }
            }
        }
        if (RACK_TYPE.equals(string)) {
            Map<String, Rack> map = this._rackMap;
            synchronized (map) {
                for (Rack rack : this._rackMap.values()) {
                    String string5;
                    Object object = rack.getProperty(string2);
                    if (!(object instanceof String) || (string5 = ((String)object).toLowerCase()).indexOf(string3) < 0) continue;
                    arrayList.add(rack);
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelObject getRelationSource(String string, String string2, String string3) {
        assert (string != null && string2 != null && string3 != null);
        if (CHASSIS_TYPE.equals(string3)) {
            Map<String, Chassis> map = this._chassisMap;
            synchronized (map) {
                for (Chassis chassis : this._chassisMap.values()) {
                    Object object = chassis.getProperty(string);
                    if (!this.isOrContains(object, string2)) continue;
                    return chassis;
                }
            }
        }
        if (RACK_TYPE.equals(string3)) {
            Map<String, Rack> map = this._rackMap;
            synchronized (map) {
                for (Rack rack : this._rackMap.values()) {
                    Object object = rack.getProperty(string);
                    if (!this.isOrContains(object, string2)) continue;
                    return rack;
                }
            }
        }
        return null;
    }

    private boolean isOrContains(Object object, String string) {
        assert (object != null);
        if (!object.getClass().isArray()) {
            return this.representSameObject(object, string);
        }
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            if (!this.representSameObject(object2, string)) continue;
            return true;
        }
        return false;
    }

    private boolean representSameObject(Object object, String string) {
        assert (object != null);
        String string2 = this._vimObjectRefService.getUid(object);
        if (string2 != null) {
            return string2.equals(string);
        }
        return false;
    }
}

