/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.tagging;

import com.vmware.cis.tagging.CategoryDefinitions;
import com.vmware.cis.tagging.CategoryModel;
import com.vmware.cis.tagging.CategoryProvider;
import com.vmware.cis.tagging.CategoryTypes;
import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;

public class CategoryApiInterface
extends ApiInterfaceSkeleton {
    private CategoryProvider impl;

    public CategoryApiInterface() {
        this((Class<? extends CategoryProvider>)null);
    }

    public CategoryApiInterface(Class<? extends CategoryProvider> clazz) {
        this((CategoryProvider)CategoryApiInterface.createImplInstance(clazz, (String)"com.vmware.cis.tagging.impl.CategoryImpl", CategoryProvider.class));
    }

    public CategoryApiInterface(CategoryProvider categoryProvider) {
        super("com.vmware.cis.tagging.category");
        Validate.notNull((Object)categoryProvider);
        this.impl = categoryProvider;
        this.registerMethod((ApiMethod)new CreateApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new UpdateApiMethod());
        this.registerMethod((ApiMethod)new DeleteApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new ListUsedCategoriesApiMethod());
        this.registerMethod((ApiMethod)new AddToUsedByApiMethod());
        this.registerMethod((ApiMethod)new RemoveFromUsedByApiMethod());
        this.registerMethod((ApiMethod)new RevokePropagatingPermissionsApiMethod());
    }

    private class RevokePropagatingPermissionsApiMethod
    extends ApiMethodSkeleton {
        public RevokePropagatingPermissionsApiMethod() {
            super(CategoryApiInterface.this.getIdentifier(), "revoke_propagating_permissions", CategoryDefinitions.__revokePropagatingPermissionsInput, CategoryDefinitions.__revokePropagatingPermissionsOutput, CategoryApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, CategoryDefinitions.__revokePropagatingPermissionsInput, CategoryApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("category_id");
            CategoryApiInterface.this.impl.revokePropagatingPermissions(string, (AsyncContext<Void>)new AsyncContextImpl(CategoryApiInterface.this.getTypeConverter(), CategoryDefinitions.__revokePropagatingPermissionsOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class RemoveFromUsedByApiMethod
    extends ApiMethodSkeleton {
        public RemoveFromUsedByApiMethod() {
            super(CategoryApiInterface.this.getIdentifier(), "remove_from_used_by", CategoryDefinitions.__removeFromUsedByInput, CategoryDefinitions.__removeFromUsedByOutput, CategoryApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, CategoryDefinitions.__removeFromUsedByInput, CategoryApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("category_id");
            String string2 = (String)structValueExtractor.valueForField("used_by_entity");
            CategoryApiInterface.this.impl.removeFromUsedBy(string, string2, (AsyncContext<Void>)new AsyncContextImpl(CategoryApiInterface.this.getTypeConverter(), CategoryDefinitions.__removeFromUsedByOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class AddToUsedByApiMethod
    extends ApiMethodSkeleton {
        public AddToUsedByApiMethod() {
            super(CategoryApiInterface.this.getIdentifier(), "add_to_used_by", CategoryDefinitions.__addToUsedByInput, CategoryDefinitions.__addToUsedByOutput, CategoryApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, CategoryDefinitions.__addToUsedByInput, CategoryApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("category_id");
            String string2 = (String)structValueExtractor.valueForField("used_by_entity");
            CategoryApiInterface.this.impl.addToUsedBy(string, string2, (AsyncContext<Void>)new AsyncContextImpl(CategoryApiInterface.this.getTypeConverter(), CategoryDefinitions.__addToUsedByOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListUsedCategoriesApiMethod
    extends ApiMethodSkeleton {
        public ListUsedCategoriesApiMethod() {
            super(CategoryApiInterface.this.getIdentifier(), "list_used_categories", CategoryDefinitions.__listUsedCategoriesInput, CategoryDefinitions.__listUsedCategoriesOutput, CategoryApiInterface.this.getTypeConverter(), null, MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, CategoryDefinitions.__listUsedCategoriesInput, CategoryApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("used_by_entity");
            CategoryApiInterface.this.impl.listUsedCategories(string, (AsyncContext<List<String>>)new AsyncContextImpl(CategoryApiInterface.this.getTypeConverter(), CategoryDefinitions.__listUsedCategoriesOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(CategoryApiInterface.this.getIdentifier(), "list", CategoryDefinitions.__listInput, CategoryDefinitions.__listOutput, CategoryApiInterface.this.getTypeConverter(), null, MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            CategoryApiInterface.this.impl.list((AsyncContext<List<String>>)new AsyncContextImpl(CategoryApiInterface.this.getTypeConverter(), CategoryDefinitions.__listOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class DeleteApiMethod
    extends ApiMethodSkeleton {
        public DeleteApiMethod() {
            super(CategoryApiInterface.this.getIdentifier(), "delete", CategoryDefinitions.__deleteInput, CategoryDefinitions.__deleteOutput, CategoryApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, CategoryDefinitions.__deleteInput, CategoryApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("category_id");
            CategoryApiInterface.this.impl.delete(string, (AsyncContext<Void>)new AsyncContextImpl(CategoryApiInterface.this.getTypeConverter(), CategoryDefinitions.__deleteOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class UpdateApiMethod
    extends ApiMethodSkeleton {
        public UpdateApiMethod() {
            super(CategoryApiInterface.this.getIdentifier(), "update", CategoryDefinitions.__updateInput, CategoryDefinitions.__updateOutput, CategoryApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.alreadyExists;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, CategoryDefinitions.__updateInput, CategoryApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("category_id");
            CategoryTypes.UpdateSpec updateSpec = (CategoryTypes.UpdateSpec)structValueExtractor.valueForField("update_spec");
            CategoryApiInterface.this.impl.update(string, updateSpec, (AsyncContext<Void>)new AsyncContextImpl(CategoryApiInterface.this.getTypeConverter(), CategoryDefinitions.__updateOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(CategoryApiInterface.this.getIdentifier(), "get", CategoryDefinitions.__getInput, CategoryDefinitions.__getOutput, CategoryApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, CategoryDefinitions.__getInput, CategoryApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("category_id");
            CategoryApiInterface.this.impl.get(string, (AsyncContext<CategoryModel>)new AsyncContextImpl(CategoryApiInterface.this.getTypeConverter(), CategoryDefinitions.__getOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class CreateApiMethod
    extends ApiMethodSkeleton {
        public CreateApiMethod() {
            super(CategoryApiInterface.this.getIdentifier(), "create", CategoryDefinitions.__createInput, CategoryDefinitions.__createOutput, CategoryApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.alreadyExists;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, CategoryDefinitions.__createInput, CategoryApiInterface.this.getTypeConverter());
            CategoryTypes.CreateSpec createSpec = (CategoryTypes.CreateSpec)structValueExtractor.valueForField("create_spec");
            CategoryApiInterface.this.impl.create(createSpec, (AsyncContext<String>)new AsyncContextImpl(CategoryApiInterface.this.getTypeConverter(), CategoryDefinitions.__createOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }
}

