/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.tagging;

import com.vmware.cis.tagging.TagAssociationDefinitions;
import com.vmware.cis.tagging.TagAssociationProvider;
import com.vmware.cis.tagging.TagAssociationTypes;
import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.DynamicID;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;

public class TagAssociationApiInterface
extends ApiInterfaceSkeleton {
    private TagAssociationProvider impl;

    public TagAssociationApiInterface() {
        this((Class<? extends TagAssociationProvider>)null);
    }

    public TagAssociationApiInterface(Class<? extends TagAssociationProvider> clazz) {
        this((TagAssociationProvider)TagAssociationApiInterface.createImplInstance(clazz, (String)"com.vmware.cis.tagging.impl.TagAssociationImpl", TagAssociationProvider.class));
    }

    public TagAssociationApiInterface(TagAssociationProvider tagAssociationProvider) {
        super("com.vmware.cis.tagging.tag_association");
        Validate.notNull((Object)tagAssociationProvider);
        this.impl = tagAssociationProvider;
        this.registerMethod((ApiMethod)new AttachApiMethod());
        this.registerMethod((ApiMethod)new AttachMultipleTagsToObjectApiMethod());
        this.registerMethod((ApiMethod)new AttachTagToMultipleObjectsApiMethod());
        this.registerMethod((ApiMethod)new DetachApiMethod());
        this.registerMethod((ApiMethod)new DetachMultipleTagsFromObjectApiMethod());
        this.registerMethod((ApiMethod)new DetachTagFromMultipleObjectsApiMethod());
        this.registerMethod((ApiMethod)new ListAttachedObjectsApiMethod());
        this.registerMethod((ApiMethod)new ListAttachedObjectsOnTagsApiMethod());
        this.registerMethod((ApiMethod)new ListAttachedTagsApiMethod());
        this.registerMethod((ApiMethod)new ListAttachedTagsOnObjectsApiMethod());
        this.registerMethod((ApiMethod)new ListAttachableTagsApiMethod());
    }

    private class ListAttachableTagsApiMethod
    extends ApiMethodSkeleton {
        public ListAttachableTagsApiMethod() {
            super(TagAssociationApiInterface.this.getIdentifier(), "list_attachable_tags", TagAssociationDefinitions.__listAttachableTagsInput, TagAssociationDefinitions.__listAttachableTagsOutput, TagAssociationApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagAssociationDefinitions.__listAttachableTagsInput, TagAssociationApiInterface.this.getTypeConverter());
            DynamicID dynamicID = (DynamicID)structValueExtractor.valueForField("object_id");
            TagAssociationApiInterface.this.impl.listAttachableTags(dynamicID, (AsyncContext<List<String>>)new AsyncContextImpl(TagAssociationApiInterface.this.getTypeConverter(), TagAssociationDefinitions.__listAttachableTagsOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListAttachedTagsOnObjectsApiMethod
    extends ApiMethodSkeleton {
        public ListAttachedTagsOnObjectsApiMethod() {
            super(TagAssociationApiInterface.this.getIdentifier(), "list_attached_tags_on_objects", TagAssociationDefinitions.__listAttachedTagsOnObjectsInput, TagAssociationDefinitions.__listAttachedTagsOnObjectsOutput, TagAssociationApiInterface.this.getTypeConverter(), null, MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagAssociationDefinitions.__listAttachedTagsOnObjectsInput, TagAssociationApiInterface.this.getTypeConverter());
            List list = (List)structValueExtractor.valueForField("object_ids");
            TagAssociationApiInterface.this.impl.listAttachedTagsOnObjects(list, (AsyncContext<List<TagAssociationTypes.ObjectToTags>>)new AsyncContextImpl(TagAssociationApiInterface.this.getTypeConverter(), TagAssociationDefinitions.__listAttachedTagsOnObjectsOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListAttachedTagsApiMethod
    extends ApiMethodSkeleton {
        public ListAttachedTagsApiMethod() {
            super(TagAssociationApiInterface.this.getIdentifier(), "list_attached_tags", TagAssociationDefinitions.__listAttachedTagsInput, TagAssociationDefinitions.__listAttachedTagsOutput, TagAssociationApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagAssociationDefinitions.__listAttachedTagsInput, TagAssociationApiInterface.this.getTypeConverter());
            DynamicID dynamicID = (DynamicID)structValueExtractor.valueForField("object_id");
            TagAssociationApiInterface.this.impl.listAttachedTags(dynamicID, (AsyncContext<List<String>>)new AsyncContextImpl(TagAssociationApiInterface.this.getTypeConverter(), TagAssociationDefinitions.__listAttachedTagsOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListAttachedObjectsOnTagsApiMethod
    extends ApiMethodSkeleton {
        public ListAttachedObjectsOnTagsApiMethod() {
            super(TagAssociationApiInterface.this.getIdentifier(), "list_attached_objects_on_tags", TagAssociationDefinitions.__listAttachedObjectsOnTagsInput, TagAssociationDefinitions.__listAttachedObjectsOnTagsOutput, TagAssociationApiInterface.this.getTypeConverter(), null, MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagAssociationDefinitions.__listAttachedObjectsOnTagsInput, TagAssociationApiInterface.this.getTypeConverter());
            List list = (List)structValueExtractor.valueForField("tag_ids");
            TagAssociationApiInterface.this.impl.listAttachedObjectsOnTags(list, (AsyncContext<List<TagAssociationTypes.TagToObjects>>)new AsyncContextImpl(TagAssociationApiInterface.this.getTypeConverter(), TagAssociationDefinitions.__listAttachedObjectsOnTagsOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListAttachedObjectsApiMethod
    extends ApiMethodSkeleton {
        public ListAttachedObjectsApiMethod() {
            super(TagAssociationApiInterface.this.getIdentifier(), "list_attached_objects", TagAssociationDefinitions.__listAttachedObjectsInput, TagAssociationDefinitions.__listAttachedObjectsOutput, TagAssociationApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagAssociationDefinitions.__listAttachedObjectsInput, TagAssociationApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("tag_id");
            TagAssociationApiInterface.this.impl.listAttachedObjects(string, (AsyncContext<List<DynamicID>>)new AsyncContextImpl(TagAssociationApiInterface.this.getTypeConverter(), TagAssociationDefinitions.__listAttachedObjectsOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class DetachTagFromMultipleObjectsApiMethod
    extends ApiMethodSkeleton {
        public DetachTagFromMultipleObjectsApiMethod() {
            super(TagAssociationApiInterface.this.getIdentifier(), "detach_tag_from_multiple_objects", TagAssociationDefinitions.__detachTagFromMultipleObjectsInput, TagAssociationDefinitions.__detachTagFromMultipleObjectsOutput, TagAssociationApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagAssociationDefinitions.__detachTagFromMultipleObjectsInput, TagAssociationApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("tag_id");
            List list = (List)structValueExtractor.valueForField("object_ids");
            TagAssociationApiInterface.this.impl.detachTagFromMultipleObjects(string, list, (AsyncContext<TagAssociationTypes.BatchResult>)new AsyncContextImpl(TagAssociationApiInterface.this.getTypeConverter(), TagAssociationDefinitions.__detachTagFromMultipleObjectsOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class DetachMultipleTagsFromObjectApiMethod
    extends ApiMethodSkeleton {
        public DetachMultipleTagsFromObjectApiMethod() {
            super(TagAssociationApiInterface.this.getIdentifier(), "detach_multiple_tags_from_object", TagAssociationDefinitions.__detachMultipleTagsFromObjectInput, TagAssociationDefinitions.__detachMultipleTagsFromObjectOutput, TagAssociationApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagAssociationDefinitions.__detachMultipleTagsFromObjectInput, TagAssociationApiInterface.this.getTypeConverter());
            DynamicID dynamicID = (DynamicID)structValueExtractor.valueForField("object_id");
            List list = (List)structValueExtractor.valueForField("tag_ids");
            TagAssociationApiInterface.this.impl.detachMultipleTagsFromObject(dynamicID, list, (AsyncContext<TagAssociationTypes.BatchResult>)new AsyncContextImpl(TagAssociationApiInterface.this.getTypeConverter(), TagAssociationDefinitions.__detachMultipleTagsFromObjectOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class DetachApiMethod
    extends ApiMethodSkeleton {
        public DetachApiMethod() {
            super(TagAssociationApiInterface.this.getIdentifier(), "detach", TagAssociationDefinitions.__detachInput, TagAssociationDefinitions.__detachOutput, TagAssociationApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagAssociationDefinitions.__detachInput, TagAssociationApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("tag_id");
            DynamicID dynamicID = (DynamicID)structValueExtractor.valueForField("object_id");
            TagAssociationApiInterface.this.impl.detach(string, dynamicID, (AsyncContext<Void>)new AsyncContextImpl(TagAssociationApiInterface.this.getTypeConverter(), TagAssociationDefinitions.__detachOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class AttachTagToMultipleObjectsApiMethod
    extends ApiMethodSkeleton {
        public AttachTagToMultipleObjectsApiMethod() {
            super(TagAssociationApiInterface.this.getIdentifier(), "attach_tag_to_multiple_objects", TagAssociationDefinitions.__attachTagToMultipleObjectsInput, TagAssociationDefinitions.__attachTagToMultipleObjectsOutput, TagAssociationApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagAssociationDefinitions.__attachTagToMultipleObjectsInput, TagAssociationApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("tag_id");
            List list = (List)structValueExtractor.valueForField("object_ids");
            TagAssociationApiInterface.this.impl.attachTagToMultipleObjects(string, list, (AsyncContext<TagAssociationTypes.BatchResult>)new AsyncContextImpl(TagAssociationApiInterface.this.getTypeConverter(), TagAssociationDefinitions.__attachTagToMultipleObjectsOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class AttachMultipleTagsToObjectApiMethod
    extends ApiMethodSkeleton {
        public AttachMultipleTagsToObjectApiMethod() {
            super(TagAssociationApiInterface.this.getIdentifier(), "attach_multiple_tags_to_object", TagAssociationDefinitions.__attachMultipleTagsToObjectInput, TagAssociationDefinitions.__attachMultipleTagsToObjectOutput, TagAssociationApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagAssociationDefinitions.__attachMultipleTagsToObjectInput, TagAssociationApiInterface.this.getTypeConverter());
            DynamicID dynamicID = (DynamicID)structValueExtractor.valueForField("object_id");
            List list = (List)structValueExtractor.valueForField("tag_ids");
            TagAssociationApiInterface.this.impl.attachMultipleTagsToObject(dynamicID, list, (AsyncContext<TagAssociationTypes.BatchResult>)new AsyncContextImpl(TagAssociationApiInterface.this.getTypeConverter(), TagAssociationDefinitions.__attachMultipleTagsToObjectOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class AttachApiMethod
    extends ApiMethodSkeleton {
        public AttachApiMethod() {
            super(TagAssociationApiInterface.this.getIdentifier(), "attach", TagAssociationDefinitions.__attachInput, TagAssociationDefinitions.__attachOutput, TagAssociationApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagAssociationDefinitions.__attachInput, TagAssociationApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("tag_id");
            DynamicID dynamicID = (DynamicID)structValueExtractor.valueForField("object_id");
            TagAssociationApiInterface.this.impl.attach(string, dynamicID, (AsyncContext<Void>)new AsyncContextImpl(TagAssociationApiInterface.this.getTypeConverter(), TagAssociationDefinitions.__attachOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }
}

