/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.tagging;

import com.vmware.cis.tagging.TagDefinitions;
import com.vmware.cis.tagging.TagSyncProvider;
import com.vmware.cis.tagging.TagTypes;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class TagSyncApiInterface
extends ApiInterfaceSkeleton {
    private TagSyncProvider impl;

    public TagSyncApiInterface() {
        this((Class<? extends TagSyncProvider>)null);
    }

    public TagSyncApiInterface(Class<? extends TagSyncProvider> clazz) {
        this((TagSyncProvider)TagSyncApiInterface.createImplInstance(clazz, (String)"com.vmware.cis.tagging.impl.TagImpl", TagSyncProvider.class));
    }

    public TagSyncApiInterface(TagSyncProvider tagSyncProvider) {
        super("com.vmware.cis.tagging.tag");
        Validate.notNull((Object)tagSyncProvider);
        this.impl = tagSyncProvider;
        this.registerMethod((ApiMethod)new CreateApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new UpdateApiMethod());
        this.registerMethod((ApiMethod)new DeleteApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new ListUsedTagsApiMethod());
        this.registerMethod((ApiMethod)new ListTagsForCategoryApiMethod());
        this.registerMethod((ApiMethod)new AddToUsedByApiMethod());
        this.registerMethod((ApiMethod)new RemoveFromUsedByApiMethod());
        this.registerMethod((ApiMethod)new RevokePropagatingPermissionsApiMethod());
    }

    private class RevokePropagatingPermissionsApiMethod
    extends ApiMethodSkeleton {
        public RevokePropagatingPermissionsApiMethod() {
            super(TagSyncApiInterface.this.getIdentifier(), "revoke_propagating_permissions", TagDefinitions.__revokePropagatingPermissionsInput, TagDefinitions.__revokePropagatingPermissionsOutput, TagSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagDefinitions.__revokePropagatingPermissionsInput, TagSyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("tag_id");
            try {
                TagSyncApiInterface.this.impl.revokePropagatingPermissions(string, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class RemoveFromUsedByApiMethod
    extends ApiMethodSkeleton {
        public RemoveFromUsedByApiMethod() {
            super(TagSyncApiInterface.this.getIdentifier(), "remove_from_used_by", TagDefinitions.__removeFromUsedByInput, TagDefinitions.__removeFromUsedByOutput, TagSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagDefinitions.__removeFromUsedByInput, TagSyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("tag_id");
            String string2 = (String)structValueExtractor.valueForField("used_by_entity");
            try {
                TagSyncApiInterface.this.impl.removeFromUsedBy(string, string2, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class AddToUsedByApiMethod
    extends ApiMethodSkeleton {
        public AddToUsedByApiMethod() {
            super(TagSyncApiInterface.this.getIdentifier(), "add_to_used_by", TagDefinitions.__addToUsedByInput, TagDefinitions.__addToUsedByOutput, TagSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagDefinitions.__addToUsedByInput, TagSyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("tag_id");
            String string2 = (String)structValueExtractor.valueForField("used_by_entity");
            try {
                TagSyncApiInterface.this.impl.addToUsedBy(string, string2, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class ListTagsForCategoryApiMethod
    extends ApiMethodSkeleton {
        public ListTagsForCategoryApiMethod() {
            super(TagSyncApiInterface.this.getIdentifier(), "list_tags_for_category", TagDefinitions.__listTagsForCategoryInput, TagDefinitions.__listTagsForCategoryOutput, TagSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagDefinitions.__listTagsForCategoryInput, TagSyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("category_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)TagSyncApiInterface.this.getTypeConverter().convertToVapi(TagSyncApiInterface.this.impl.listTagsForCategory(string, invocationContext), TagDefinitions.__listTagsForCategoryOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class ListUsedTagsApiMethod
    extends ApiMethodSkeleton {
        public ListUsedTagsApiMethod() {
            super(TagSyncApiInterface.this.getIdentifier(), "list_used_tags", TagDefinitions.__listUsedTagsInput, TagDefinitions.__listUsedTagsOutput, TagSyncApiInterface.this.getTypeConverter(), null, MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagDefinitions.__listUsedTagsInput, TagSyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("used_by_entity");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)TagSyncApiInterface.this.getTypeConverter().convertToVapi(TagSyncApiInterface.this.impl.listUsedTags(string, invocationContext), TagDefinitions.__listUsedTagsOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(TagSyncApiInterface.this.getIdentifier(), "list", TagDefinitions.__listInput, TagDefinitions.__listOutput, TagSyncApiInterface.this.getTypeConverter(), null, MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)TagSyncApiInterface.this.getTypeConverter().convertToVapi(TagSyncApiInterface.this.impl.list(invocationContext), TagDefinitions.__listOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class DeleteApiMethod
    extends ApiMethodSkeleton {
        public DeleteApiMethod() {
            super(TagSyncApiInterface.this.getIdentifier(), "delete", TagDefinitions.__deleteInput, TagDefinitions.__deleteOutput, TagSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagDefinitions.__deleteInput, TagSyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("tag_id");
            try {
                TagSyncApiInterface.this.impl.delete(string, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class UpdateApiMethod
    extends ApiMethodSkeleton {
        public UpdateApiMethod() {
            super(TagSyncApiInterface.this.getIdentifier(), "update", TagDefinitions.__updateInput, TagDefinitions.__updateOutput, TagSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.alreadyExists;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagDefinitions.__updateInput, TagSyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("tag_id");
            TagTypes.UpdateSpec updateSpec = (TagTypes.UpdateSpec)structValueExtractor.valueForField("update_spec");
            try {
                TagSyncApiInterface.this.impl.update(string, updateSpec, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(TagSyncApiInterface.this.getIdentifier(), "get", TagDefinitions.__getInput, TagDefinitions.__getOutput, TagSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagDefinitions.__getInput, TagSyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("tag_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)TagSyncApiInterface.this.getTypeConverter().convertToVapi((Object)TagSyncApiInterface.this.impl.get(string, invocationContext), TagDefinitions.__getOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class CreateApiMethod
    extends ApiMethodSkeleton {
        public CreateApiMethod() {
            super(TagSyncApiInterface.this.getIdentifier(), "create", TagDefinitions.__createInput, TagDefinitions.__createOutput, TagSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.alreadyExists;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagDefinitions.__createInput, TagSyncApiInterface.this.getTypeConverter());
            TagTypes.CreateSpec createSpec = (TagTypes.CreateSpec)structValueExtractor.valueForField("create_spec");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)TagSyncApiInterface.this.getTypeConverter().convertToVapi((Object)TagSyncApiInterface.this.impl.create(createSpec, invocationContext), TagDefinitions.__createOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }
}

