/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.messaging.amf.vim;

import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventEx;
import com.vmware.vim.binding.vim.event.ExtendedEvent;
import com.vmware.vim.binding.vim.event.VmEventArgument;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.core.model.BooleanDataObject;
import com.vmware.vise.core.model.DateDataObject;
import com.vmware.vise.core.model.NumberDataObject;
import com.vmware.vise.core.model.StringDataObject;
import com.vmware.vise.messaging.amf.DataObjectProxy;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventProxy
extends DataObjectProxy {
    static final long serialVersionUID = -4141214967245211278L;
    static final String FT_PRIMARY_NAME_SUFFIX = "\\p";
    static final String FT_SECONDARY_NAME_SUFFIX = "\\s";
    private static final Log _logger = LogFactory.getLog(EventProxy.class);

    public EventProxy() {
        this(null);
    }

    public EventProxy(Object object) {
        super(object);
    }

    public Object getInstanceToSerialize(Object object) {
        if (object instanceof Event) {
            Object object2;
            Event event = (Event)object;
            String string = null;
            KeyAnyValue[] keyAnyValueArray = null;
            String string2 = this.fixupFTVmName(event.getVm());
            if (event instanceof ExtendedEvent) {
                object2 = (ExtendedEvent)event;
                string = object2.getEventTypeId() + ".fullFormat";
            } else if (event instanceof EventEx) {
                object2 = (EventEx)event;
                string = object2.getEventTypeId() + ".fullFormat";
                keyAnyValueArray = object2.getArguments();
            } else {
                string = event.getClass().getSimpleName() + ".fullFormat";
            }
            if (string != null) {
                if (string.startsWith("Vmomi.Event.")) {
                    string = string.substring("Vmomi.Event.".length());
                }
                if ((object2 = this.formatMessage(LocalizationUtil.getLocalizedMessage((String)string, (KeyAnyValue[])keyAnyValueArray), object)) != null) {
                    event.setFullFormattedMessage((String)object2);
                }
            }
            if (string2 != null && (object2 = event.getVm()) != null) {
                object2.setName(string2);
            }
        }
        return object;
    }

    private String formatMessage(String string, Object object) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        int n2 = -1;
        int n3 = string.length();
        block4: for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '{': {
                    n = i;
                    continue block4;
                }
                case '}': {
                    if (n == -1) continue block4;
                    n2 = i;
                    String string2 = string.substring(n + 1, n2);
                    n = -1;
                    stringBuffer.append(this.resolveValue(object, string2.split("\\.")));
                    continue block4;
                }
                default: {
                    if (n != -1) continue block4;
                    stringBuffer.append(c);
                }
            }
        }
        if (n != -1) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    private String resolveValue(Object object, String[] stringArray) {
        if (object == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return this.toStringValue(object);
        }
        String string = stringArray[0];
        try {
            object = this.getValue(object, string);
            if (stringArray.length == 1) {
                return this.toStringValue(object);
            }
        }
        catch (Exception exception) {
            _logger.warn((Object)("Failed to resolve path " + Arrays.toString(stringArray)));
            return null;
        }
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
        return this.resolveValue(object, stringArray2);
    }

    private String toStringValue(Object object) {
        String string = "";
        if (object instanceof StringDataObject) {
            string = ((StringDataObject)object).getValue();
        } else if (object instanceof BooleanDataObject) {
            BooleanDataObject booleanDataObject = (BooleanDataObject)object;
            if (!booleanDataObject.getIsUnset()) {
                string = String.valueOf(booleanDataObject.isValue());
            }
        } else if (object instanceof NumberDataObject) {
            NumberDataObject numberDataObject = (NumberDataObject)object;
            if (!numberDataObject.getIsUnset()) {
                string = String.valueOf(numberDataObject.getValue());
            }
        } else {
            string = object instanceof DateDataObject ? String.valueOf(((DateDataObject)object).getValue()) : String.valueOf(object);
        }
        return string;
    }

    private String fixupFTVmName(VmEventArgument vmEventArgument) {
        String string;
        String string2;
        if (vmEventArgument == null) {
            return null;
        }
        String string3 = string2 = vmEventArgument.getName();
        int n = string2.indexOf(FT_PRIMARY_NAME_SUFFIX);
        if (n >= 0 && (string = LocalizationUtil.getLocalizedMessage((String)"enum.ft.primary.suffix", null)) != null) {
            string2 = string2.replace(FT_PRIMARY_NAME_SUFFIX, string);
        }
        if ((n = string2.indexOf(FT_SECONDARY_NAME_SUFFIX)) >= 0 && (string = LocalizationUtil.getLocalizedMessage((String)"enum.ft.primary.suffix", null)) != null) {
            string2 = string2.replace(FT_SECONDARY_NAME_SUFFIX, string);
        }
        vmEventArgument.setName(string2);
        return string3;
    }
}

