/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcha.command;

import com.vmware.vise.data.query.DataService;
import com.vmware.vsphere.client.common.compositecommand.BaseCommand;
import com.vmware.vsphere.client.common.compositecommand.CommandFactory;
import com.vmware.vsphere.client.common.compositecommand.DummyCommand;
import com.vmware.vsphere.client.common.compositecommand.api.spec.BaseCommandSpec;
import com.vmware.vsphere.client.common.compositecommand.api.spec.DummyCommandSpec;
import com.vmware.vsphere.client.vcha.command.VchaDeleteVmCommand;
import com.vmware.vsphere.client.vcha.command.VchaPowerOffVmCommand;
import com.vmware.vsphere.client.vcha.command.VchaRemoveCommand;
import com.vmware.vsphere.client.vcha.command.VchaSetModeCommand;
import com.vmware.vsphere.client.vcha.specs.VchaDeleteVmCommandSpec;
import com.vmware.vsphere.client.vcha.specs.VchaPowerOffVmCommandSpec;
import com.vmware.vsphere.client.vcha.specs.VchaRemoveCommandSpec;
import com.vmware.vsphere.client.vcha.specs.VchaSetModeCommandSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VchaCommandFactory
extends CommandFactory {
    private static final Log _logger = LogFactory.getLog(VchaCommandFactory.class);

    public BaseCommand createCommand(BaseCommandSpec commandSpec, BaseCommand parentCommand, DataService dataService) {
        try {
            if (commandSpec instanceof DummyCommandSpec) {
                return this.createConcreteCommand((DummyCommandSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof VchaSetModeCommandSpec) {
                return this.createConcreteCommand((VchaSetModeCommandSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof VchaRemoveCommandSpec) {
                return this.createConcreteCommand((VchaRemoveCommandSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof VchaPowerOffVmCommandSpec) {
                return this.createConcreteCommand((VchaPowerOffVmCommandSpec)commandSpec, parentCommand);
            }
            if (commandSpec instanceof VchaDeleteVmCommandSpec) {
                return this.createConcreteCommand((VchaDeleteVmCommandSpec)commandSpec, parentCommand);
            }
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
        }
        return null;
    }

    private BaseCommand createConcreteCommand(DummyCommandSpec commandSpec, BaseCommand parentCommand) {
        this.resolveCommandSpec((BaseCommandSpec)commandSpec, parentCommand, null);
        return new DummyCommand(commandSpec);
    }

    private BaseCommand createConcreteCommand(VchaSetModeCommandSpec commandSpec, BaseCommand parentCommand) {
        this.resolveCommandSpec(commandSpec, parentCommand, null);
        return new VchaSetModeCommand(commandSpec);
    }

    private BaseCommand createConcreteCommand(VchaRemoveCommandSpec commandSpec, BaseCommand parentCommand) {
        this.resolveCommandSpec(commandSpec, parentCommand, null);
        return new VchaRemoveCommand(commandSpec);
    }

    private BaseCommand createConcreteCommand(VchaPowerOffVmCommandSpec commandSpec, BaseCommand parentCommand) {
        this.resolveCommandSpec(commandSpec, parentCommand, null);
        return new VchaPowerOffVmCommand(commandSpec);
    }

    private BaseCommand createConcreteCommand(VchaDeleteVmCommandSpec commandSpec, BaseCommand parentCommand) {
        this.resolveCommandSpec(commandSpec, parentCommand, null);
        return new VchaDeleteVmCommand(commandSpec);
    }
}

