/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcha.impl;

import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vsphere.client.vcha.impl.VchaMockDataProvider;
import com.vmware.vsphere.client.vcha.util.VchaUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VchaCompatibilityProvider
implements PropertyProviderBean {
    private static final String PROPERTY_VC_URI = "vchaVcNodeUri";
    private static final String PROPERTY_DEPLOYMENT_TYPE = "deploymentType";
    private static final String VC_OPTION_KEY_DB_TYPE = "config.vpxd.odbc.dbtype";
    private static final String VC_OPTION_VALUE_DB_EMBEDDED = "embedded";
    private static final String VC_OS_CLASS_WIN = "win";
    private static final String VC_NODE_TYPE = "management";
    private static final Log _logger = LogFactory.getLog(VchaCompatibilityProvider.class);
    private final QueryExecutor _queryExecutor;
    private final VchaMockDataProvider _mockDataProvider;
    private final FeatureStateService _featureStateService;

    public VchaCompatibilityProvider(QueryExecutor queryExecutor, VchaMockDataProvider mockDataProvider, FeatureStateService featureStateService) {
        this._queryExecutor = queryExecutor;
        this._mockDataProvider = mockDataProvider;
        this._featureStateService = featureStateService;
    }

    @type(value="Folder")
    public boolean getVchaIsEmbeddedDbInUse(ManagedObjectReference rootFolderRef) throws Exception {
        if (this._mockDataProvider.getUseMockData("vchaIsEmbeddedDbInUse")) {
            return this._mockDataProvider.getVchaIsEmbeddedDbInUse();
        }
        Object val = VchaUtil.getVcOption(rootFolderRef, VC_OPTION_KEY_DB_TYPE);
        if (val instanceof String) {
            return VC_OPTION_VALUE_DB_EMBEDDED.equalsIgnoreCase((String)val);
        }
        return false;
    }

    @type(value="Folder")
    public boolean getVchaIsOnCloudVm(ManagedObjectReference rootFolderRef) throws Exception {
        if (this._mockDataProvider.getUseMockData("vchaIsOnCloudVm")) {
            return this._mockDataProvider.getVchaIsOnCloudVm();
        }
        ServiceInstanceContent serviceContent = VchaUtil.getServiceContent(rootFolderRef);
        if (serviceContent != null && serviceContent.about != null && serviceContent.about.osType != null) {
            return !serviceContent.about.osType.contains(VC_OS_CLASS_WIN);
        }
        throw new Exception("VC OS type cannot be retrieved.");
    }

    @type(value="Folder")
    public boolean getVchaIsExternalInfraNodeInUse(ManagedObjectReference rootFolderRef) throws Exception {
        return true;
    }
}

