/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcha.impl;

import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.vcha.FailoverClusterConfigurator;
import com.vmware.vim.binding.vim.vm.check.Result;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.vcha.model.VchaClusterVmInfo;
import com.vmware.vsphere.client.vcha.specs.VchaDeployNodeSpec;
import com.vmware.vsphere.client.vcha.specs.VchaDeploySpec;
import com.vmware.vsphere.client.vcha.specs.VchaPrepareSpec;
import com.vmware.vsphere.client.vcha.util.VchaUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VchaValidationProvider
implements MutationProvider {
    private static String IS_CONFIG_PREPARED_PROP = "vchaIsConfigPrepared";
    private static String SUCCESS = "success";
    private static final Log _logger = LogFactory.getLog(VchaValidationProvider.class);
    private static final String PROPERTY_VCHA_CLUSTERVM = "vchaClusterVmSingleDomain";
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_PARENT = "parent";
    private static final String PROPERTY_HOST = "standalonehost";
    private static final String PROPERTY_RESOURCE_POOL = "resourcePool";
    private static final String PROPERTY_DATASTORE = "datastore";
    private static final String PROPERTY_VCHA_NETWORK = "vchaVmNicNetwork";
    private static final String PROPERTY_UNIQUE_NAME = "vchaVmUniqueName";
    private static final String PROPERTY_DATASTORE_FREESPACE = "summary.freeSpace";
    private static final String PROPERTY_VM_COMMITTEDSPACE = "summary.storage.committed";
    private static final String PROPERTY_VM_UNCOMMITTEDSPACE = "summary.storage.uncommitted";
    private static final String PRIVILEGE_CREATEFROMVM = "VirtualMachine.Inventory.CreateFromExisting";
    private static final String PRIVILEGE_POWERON = "VirtualMachine.Interact.PowerOn";
    private static final String PRIVILEGE_POOLASSIGN = "Resource.AssignVMToPool";
    private static final String PRIVILEGE_ALLOCATESPACE = "Datastore.AllocateSpace";
    private static final String PRIVILEGE_NETASSIGN = "Network.Assign";
    private static final int VALIDATION_PIPELINE_THREADS_COUNT = 2;
    private QuerySpecBuilder _querySpecBuilder;
    private QueryExecutor _queryExecutor;
    private TaskMonitor _taskMonitor;
    private LegacyAuthorizationService _authorizationService;

    public VchaValidationProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder, TaskMonitor taskMonitor, LegacyAuthorizationService authorizationService) {
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
        this._taskMonitor = taskMonitor;
        this._authorizationService = authorizationService;
    }

    public ValidationResult validate(ManagedObjectReference rootFolderRef, VchaDeploySpec spec) throws Exception {
        _logger.debug((Object)spec);
        long start = 0L;
        long end = 0L;
        long elapsedMs = 0L;
        if (_logger.isDebugEnabled()) {
            start = System.nanoTime();
        }
        ValidationResult valResult = new ValidationResult();
        this.validateLocation(valResult, rootFolderRef, spec);
        if (_logger.isDebugEnabled()) {
            end = System.nanoTime();
            elapsedMs = (end - start) / 1000000L;
            _logger.debug((Object)("VCHA DeploySpec validation took (ms): " + elapsedMs));
        }
        _logger.debug((Object)valResult);
        return valResult;
    }

    public ValidationResult validate(ManagedObjectReference rootFolderRef, VchaPrepareSpec spec) throws Exception {
        ValidationResult result = new ValidationResult();
        result.entity = rootFolderRef;
        TaskInfo taskInfo = null;
        try {
            FailoverClusterConfigurator fcConfigurator = VchaUtil.getFailoverClusterConfigurator(rootFolderRef);
            Boolean isConfigPrepared = (Boolean)this._queryExecutor.getProperty((Object)rootFolderRef, IS_CONFIG_PREPARED_PROP);
            if (!isConfigPrepared.booleanValue()) {
                ManagedObjectReference taskRef = fcConfigurator.prepare(spec.networkSpec);
                taskInfo = this._taskMonitor.monitorTask(taskRef);
                if (taskInfo.state == TaskInfo.State.success) {
                    result.result = SUCCESS;
                } else {
                    _logger.error((Object)("Prepare VCHA task failed" + taskInfo.error.getMessage()));
                    MethodFault fault = new MethodFault();
                    fault.initCause((Throwable)taskInfo.error);
                    result.error = fault;
                }
            } else {
                _logger.debug((Object)"Prepare VCHA is not run - the cluster is already prepared.");
                result.result = SUCCESS;
            }
        }
        catch (Exception ex) {
            _logger.error((Object)("Error preparing the VCHA nodes: " + ex.getMessage()));
            result.error = MixedUtil.getMethodFault((Throwable)ex);
            return result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateLocation(ValidationResult valResult, ManagedObjectReference rootFolderRef, VchaDeploySpec spec) throws Exception {
        if (spec.sourceVm == null) {
            this.warmUpAuthZ(rootFolderRef);
            return;
        }
        ValidationContextInternal passiveValCtx = spec.passiveNodeSpec != null ? new ValidationContextInternal(false) : null;
        ValidationContextInternal witnessValCtx = spec.witnessNodeSpec != null ? new ValidationContextInternal(true) : null;
        this.initValContext(passiveValCtx, witnessValCtx, rootFolderRef, spec);
        if (passiveValCtx != null && witnessValCtx != null) {
            ExecutorService executor = Executors.newFixedThreadPool(2);
            try {
                Runnable passiveNodeValTask = this.createNodeLocationValTask(passiveValCtx);
                Runnable witnessNodeValTask = this.createNodeLocationValTask(witnessValCtx);
                ArrayList<Runnable> taskList = new ArrayList<Runnable>();
                taskList.add(passiveNodeValTask);
                taskList.add(witnessNodeValTask);
                ExecutorUtil.executeTasks(taskList, (Executor)executor);
            }
            finally {
                executor.shutdown();
            }
        } else {
            if (passiveValCtx != null) {
                this.validateNodeLocation(passiveValCtx);
            }
            if (witnessValCtx != null) {
                this.validateNodeLocation(witnessValCtx);
            }
        }
        valResult.result = new ValidationResult[]{passiveValCtx != null ? passiveValCtx.getValidationResult() : null, witnessValCtx != null ? witnessValCtx.getValidationResult() : null};
    }

    private Runnable createNodeLocationValTask(final ValidationContextInternal valResult) throws Exception {
        Runnable nodaValTask = new Runnable(){

            @Override
            public void run() {
                try {
                    VchaValidationProvider.this.validateNodeLocation(valResult);
                }
                catch (Exception e) {
                    _logger.error((Object)e);
                }
            }
        };
        return nodaValTask;
    }

    private void validateNodeLocation(ValidationContextInternal valResult) throws Exception {
        this.validateLocationIsSet(valResult);
        this.validateNodeNameIsUnique(valResult);
        this.validateLocationIsCompatible(valResult);
        this.validateClusterCompatibility(valResult);
        this.validatePrivilege(valResult);
        this.validateDatastoreSpace(valResult);
    }

    private void validateLocationIsSet(ValidationContextInternal valCtx) {
        if (StringUtils.isEmpty((String)valCtx.thisVmLocation.vmName)) {
            valCtx.addErrorKey("valmsg.error.noVmName");
        }
        if (valCtx.thisVmLocation.vmFolder == null) {
            valCtx.addErrorKey("valmsg.error.noVmFolder");
        }
        if (valCtx.thisVmLocation.host == null && valCtx.thisVmLocation.resourcePool == null) {
            valCtx.addErrorKey("valmsg.error.noCompute");
        }
        if (valCtx.thisVmLocation.datastore == null) {
            valCtx.addErrorKey("valmsg.error.noDatastore");
        }
        if (!valCtx.isWitness && valCtx.thisVmLocation.publicNetwork == null) {
            valCtx.addErrorKey("valmsg.error.noPublicNetwork");
        }
        if (valCtx.thisVmLocation.clusterNetwork == null) {
            valCtx.addErrorKey("valmsg.error.noClusterNetwork");
        }
    }

    private void validateNodeNameIsUnique(ValidationContextInternal valCtx) throws Exception {
        String vmName = valCtx.thisVmLocation.vmName;
        if (StringUtils.isEmpty((String)vmName) || valCtx.thisVmLocation.vmFolder == null) {
            return;
        }
        if (vmName.equals(valCtx.otherVmLocation.vmName) || vmName.equals(valCtx.sourceVmLocation.vmName)) {
            valCtx.addErrorKey("valmsg.error.notUniqueNameInVchaCluster");
            return;
        }
        PropertySpec propertySpec = VchaUtil.createPropertySpecWithParam(this._querySpecBuilder, Folder.class.getSimpleName(), PROPERTY_UNIQUE_NAME, vmName);
        ResourceSpec resourceSpec = this._querySpecBuilder.createEmptyResourceSpec();
        resourceSpec.constraint = this._querySpecBuilder.createObjectIdentityConstraint((Object)valCtx.otherVmLocation.vmFolder);
        resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
        QuerySpec querySpec = new QuerySpec();
        querySpec.resourceSpec = resourceSpec;
        ResultSet resultSet = this._queryExecutor.getData(querySpec);
        String uniqueName = VchaUtil.getPropertyValue(resultSet, PROPERTY_UNIQUE_NAME, String.class);
        if (!vmName.equals(uniqueName)) {
            valCtx.addErrorKey("valmsg.error.notUniqueNameInVmFolder");
        }
    }

    private void validateLocationIsCompatible(ValidationContextInternal valCtx) throws Exception {
        if (valCtx.thisVmLocation.vmFolder != null) {
            String sourceVmSrvGuid = valCtx.sourceVmLocation.vm.getServerGuid();
            String vmFolderSrvGuid = valCtx.thisVmLocation.vmFolder.getServerGuid();
            if (!vmFolderSrvGuid.equals(sourceVmSrvGuid)) {
                valCtx.addErrorKey("valmsg.error.notSameVc");
            }
        }
        if (valCtx.thisVmLocation.datastore != null && valCtx.thisVmLocation.datastoreParent != null && StoragePod.class.getSimpleName().equals(valCtx.thisVmLocation.datastoreParent.getType())) {
            valCtx.addErrorKey("valmsg.error.onStoragePod");
        }
        if (valCtx.thisVmLocation.resourcePool != null && VirtualApp.class.getSimpleName().equals(valCtx.thisVmLocation.resourcePool.getType())) {
            valCtx.addErrorKey("valmsg.error.onVApp");
        }
    }

    private void validateClusterCompatibility(ValidationContextInternal valCtx) throws Exception {
        if (valCtx.sourceVmLocation.host != null && valCtx.otherVmLocation.host != null && valCtx.thisVmLocation.host != null && (valCtx.thisVmLocation.host.equals((Object)valCtx.sourceVmLocation.host) || valCtx.thisVmLocation.host.equals((Object)valCtx.otherVmLocation.host))) {
            valCtx.addWarningKey("valmsg.warning.onSameHost");
        }
        if (valCtx.sourceVmLocation.datastore != null && valCtx.otherVmLocation.datastore != null && valCtx.thisVmLocation.datastore != null && (valCtx.thisVmLocation.datastore.equals((Object)valCtx.sourceVmLocation.datastore) || valCtx.thisVmLocation.datastore.equals((Object)valCtx.otherVmLocation.datastore))) {
            valCtx.addWarningKey("valmsg.warning.onSameDatastore");
        }
        if (valCtx.thisVmLocation.publicNetwork != null && valCtx.thisVmLocation.clusterNetwork != null && valCtx.thisVmLocation.publicNetwork.equals((Object)valCtx.thisVmLocation.clusterNetwork)) {
            valCtx.addWarningKey("valmsg.warning.onSameNetwork");
        }
    }

    private void validateDatastoreSpace(ValidationContextInternal valCtx) throws Exception {
        long requiredVmSpace = valCtx.thisVmLocation.vmCommittedSpace + valCtx.thisVmLocation.vmUncommittedSpace;
        if (valCtx.otherVmLocation.vm == null && valCtx.otherVmLocation.datastore != null && valCtx.otherVmLocation.datastore.equals((Object)valCtx.thisVmLocation.datastore)) {
            requiredVmSpace = requiredVmSpace + valCtx.otherVmLocation.vmCommittedSpace + valCtx.otherVmLocation.vmUncommittedSpace;
        }
        if (valCtx.thisVmLocation.datastoreFreeSpace < requiredVmSpace) {
            valCtx.addWarningKey("valmsg.warning.insufficientDatastoreSpace");
        }
    }

    private void validatePrivilege(ValidationContextInternal valCtx) throws Exception {
        this.checkPrivilege(valCtx, valCtx.thisVmLocation.vmFolder, new String[]{PRIVILEGE_CREATEFROMVM, PRIVILEGE_POWERON}, "valmsg.error.noFolderPriv");
        this.checkPrivilege(valCtx, valCtx.thisVmLocation.resourcePool, new String[]{PRIVILEGE_POOLASSIGN}, "valmsg.error.noResourcePoolPriv");
        this.checkPrivilege(valCtx, valCtx.thisVmLocation.datastore, new String[]{PRIVILEGE_ALLOCATESPACE}, "valmsg.error.noDatastorePriv");
        this.checkPrivilege(valCtx, valCtx.thisVmLocation.publicNetwork, new String[]{PRIVILEGE_NETASSIGN}, "valmsg.error.noPublicNetworkPriv");
        this.checkPrivilege(valCtx, valCtx.thisVmLocation.clusterNetwork, new String[]{PRIVILEGE_NETASSIGN}, "valmsg.error.noClusterNetworkPriv");
    }

    private void initValContext(ValidationContextInternal passiveValCtx, ValidationContextInternal witnessValCtx, ManagedObjectReference rootFolderRef, VchaDeploySpec spec) throws Exception {
        VchaClusterVmInfo clusterVmInfo;
        if (spec.passiveNodeSpec != null && spec.witnessNodeSpec != null) {
            clusterVmInfo = new VchaClusterVmInfo();
            clusterVmInfo.activeVm = spec.sourceVm;
        } else {
            clusterVmInfo = (VchaClusterVmInfo)((Object)this._queryExecutor.getProperty((Object)rootFolderRef, PROPERTY_VCHA_CLUSTERVM));
        }
        VmLocationInfoInternal activeVmLocation = new VmLocationInfoInternal();
        activeVmLocation.vm = clusterVmInfo.activeVm;
        VmLocationInfoInternal passiveVmLocation = new VmLocationInfoInternal();
        if (spec.passiveNodeSpec != null) {
            this.populateLocation(passiveVmLocation, spec.passiveNodeSpec);
        } else {
            passiveVmLocation.vm = clusterVmInfo.passiveVm;
        }
        VmLocationInfoInternal witnessVmLocation = new VmLocationInfoInternal();
        if (spec.witnessNodeSpec != null) {
            this.populateLocation(witnessVmLocation, spec.witnessNodeSpec);
        } else {
            witnessVmLocation.vm = clusterVmInfo.witnessVm;
        }
        this.retrieveLocation(new VmLocationInfoInternal[]{activeVmLocation, passiveVmLocation, witnessVmLocation});
        if (spec.passiveNodeSpec != null) {
            passiveVmLocation.vmCommittedSpace = activeVmLocation.vmCommittedSpace;
            passiveVmLocation.vmUncommittedSpace = activeVmLocation.vmUncommittedSpace;
        }
        if (spec.witnessNodeSpec != null) {
            witnessVmLocation.vmCommittedSpace = activeVmLocation.vmCommittedSpace;
            witnessVmLocation.vmUncommittedSpace = activeVmLocation.vmUncommittedSpace;
        }
        if (passiveValCtx != null) {
            passiveValCtx.sourceVmLocation = activeVmLocation;
            passiveValCtx.thisVmLocation = passiveVmLocation;
            passiveValCtx.otherVmLocation = witnessVmLocation;
        }
        if (witnessValCtx != null) {
            witnessValCtx.sourceVmLocation = activeVmLocation;
            witnessValCtx.thisVmLocation = witnessVmLocation;
            witnessValCtx.otherVmLocation = passiveVmLocation;
        }
    }

    private void populateLocation(VmLocationInfoInternal locationInfo, VchaDeployNodeSpec nodeSpec) {
        locationInfo.vmName = nodeSpec.vmName;
        locationInfo.vmFolder = nodeSpec.vmFolder;
        locationInfo.host = nodeSpec.host;
        locationInfo.resourcePool = nodeSpec.resourcePool;
        locationInfo.datastore = nodeSpec.datastore;
        locationInfo.publicNetwork = nodeSpec.publicNetwork;
        locationInfo.clusterNetwork = nodeSpec.clusterNetwork;
    }

    private void retrieveLocation(VmLocationInfoInternal[] locationInfos) throws Exception {
        if (ArrayUtils.isEmpty((Object[])locationInfos)) {
            return;
        }
        ArrayList<ManagedObjectReference> vmList = new ArrayList<ManagedObjectReference>();
        for (VmLocationInfoInternal locationInfo : locationInfos) {
            if (locationInfo.vm == null) continue;
            vmList.add(locationInfo.vm);
        }
        PropertyValue[] pv = this._queryExecutor.getProperties((Object[])vmList.toArray(new ManagedObjectReference[vmList.size()]), new String[]{PROPERTY_NAME, PROPERTY_PARENT, PROPERTY_HOST, PROPERTY_RESOURCE_POOL, PROPERTY_DATASTORE, PROPERTY_VCHA_NETWORK, PROPERTY_VM_COMMITTEDSPACE, PROPERTY_VM_UNCOMMITTEDSPACE});
        for (VmLocationInfoInternal locationInfo : locationInfos) {
            ManagedObjectReference[] networks;
            if (locationInfo.vm == null) continue;
            locationInfo.vmName = VchaUtil.getPropertyValue(pv, PROPERTY_NAME, String.class, locationInfo.vm);
            locationInfo.vmFolder = VchaUtil.getPropertyValue(pv, PROPERTY_PARENT, ManagedObjectReference.class, locationInfo.vm);
            locationInfo.host = VchaUtil.getPropertyValue(pv, PROPERTY_HOST, ManagedObjectReference.class, locationInfo.vm);
            locationInfo.resourcePool = VchaUtil.getPropertyValue(pv, PROPERTY_RESOURCE_POOL, ManagedObjectReference.class, locationInfo.vm);
            Object[] datastores = (ManagedObjectReference[])VchaUtil.getPropertyValue(pv, PROPERTY_DATASTORE, Object.class, locationInfo.vm);
            if (!ArrayUtils.isEmpty((Object[])datastores)) {
                locationInfo.datastore = datastores[0];
            }
            if ((networks = (ManagedObjectReference[])VchaUtil.getPropertyValue(pv, PROPERTY_VCHA_NETWORK, Object.class, locationInfo.vm)) != null) {
                if (networks.length > 0) {
                    locationInfo.publicNetwork = networks[0];
                }
                if (networks.length > 1) {
                    locationInfo.clusterNetwork = networks[1];
                }
            }
            locationInfo.vmCommittedSpace = VchaUtil.getPropertyValue(pv, PROPERTY_VM_COMMITTEDSPACE, Long.class, locationInfo.vm);
            locationInfo.vmUncommittedSpace = VchaUtil.getPropertyValue(pv, PROPERTY_VM_UNCOMMITTEDSPACE, Long.class, locationInfo.vm);
        }
        this.retrieveDatastore(locationInfos);
    }

    private void retrieveDatastore(VmLocationInfoInternal[] locationInfos) throws Exception {
        if (ArrayUtils.isEmpty((Object[])locationInfos)) {
            return;
        }
        ArrayList<ManagedObjectReference> dsList = new ArrayList<ManagedObjectReference>();
        for (VmLocationInfoInternal locationInfo : locationInfos) {
            if (locationInfo.datastore == null) continue;
            dsList.add(locationInfo.datastore);
        }
        PropertyValue[] pv = this._queryExecutor.getProperties((Object[])dsList.toArray(new ManagedObjectReference[dsList.size()]), new String[]{PROPERTY_DATASTORE_FREESPACE, PROPERTY_PARENT});
        for (VmLocationInfoInternal locationInfo : locationInfos) {
            if (locationInfo.datastore == null) continue;
            locationInfo.datastoreFreeSpace = VchaUtil.getPropertyValue(pv, PROPERTY_DATASTORE_FREESPACE, Long.class, locationInfo.datastore);
            locationInfo.datastoreParent = VchaUtil.getPropertyValue(pv, PROPERTY_PARENT, ManagedObjectReference.class, locationInfo.datastore);
        }
    }

    private void checkPrivilege(ValidationContextInternal valCtx, ManagedObjectReference moRef, String[] privIds, String valMsgKey) throws Exception {
        if (moRef == null) {
            return;
        }
        if (!this._authorizationService.checkPrivileges(new ManagedObjectReference[]{moRef}, privIds)) {
            valCtx.addErrorKey(valMsgKey);
        }
    }

    private void warmUpAuthZ(ManagedObjectReference folderRef) throws Exception {
        Boolean result = this._authorizationService.checkPrivileges(new ManagedObjectReference[]{folderRef}, new String[]{PRIVILEGE_CREATEFROMVM});
        _logger.debug((Object)"AtZ warm up done.");
        _logger.debug((Object)result);
    }

    private class ValidationContextInternal {
        public boolean isWitness;
        public VmLocationInfoInternal sourceVmLocation;
        public VmLocationInfoInternal thisVmLocation;
        public VmLocationInfoInternal otherVmLocation;
        private final List<String> _errors = new ArrayList<String>();
        private final List<String> _warnings = new ArrayList<String>();

        public ValidationContextInternal(boolean isWitness) {
            this.isWitness = isWitness;
        }

        public void addErrorKey(String key) {
            this._errors.add(String.format(VchaUtil.getLocalizedString(key), this.getVmName()));
        }

        public void addWarningKey(String key) {
            this._warnings.add(String.format(VchaUtil.getLocalizedString(key), this.getVmName()));
        }

        public ValidationResult getValidationResult() {
            ValidationResult valResult = new ValidationResult();
            valResult.entity = this.sourceVmLocation.vm;
            Result[] results = new Result[]{new Result()};
            results[0].error = this.getIssues(this._errors);
            results[0].warning = this.getIssues(this._warnings);
            valResult.result = results;
            return valResult;
        }

        private Exception[] getIssues(List<String> issueStringList) {
            if (ArrayUtil.isNullOrEmpty(issueStringList)) {
                return null;
            }
            Exception[] issues = new Exception[issueStringList.size()];
            int i = 0;
            for (String issueString : issueStringList) {
                issues[i++] = new Exception(issueString);
            }
            return issues;
        }

        private String getVmName() {
            String vmName = this.thisVmLocation.vmName;
            if (StringUtil.isNullOrEmpty((String)vmName)) {
                vmName = !this.isWitness ? VchaUtil.getLocalizedString("passive.defaultVmName") : VchaUtil.getLocalizedString("witness.defaultVmName");
            }
            return vmName;
        }
    }

    private class VmLocationInfoInternal {
        public ManagedObjectReference vm;
        public String vmName;
        public long vmCommittedSpace;
        public long vmUncommittedSpace;
        public ManagedObjectReference vmFolder;
        public ManagedObjectReference host;
        public ManagedObjectReference resourcePool;
        public ManagedObjectReference datastore;
        public ManagedObjectReference datastoreParent;
        public long datastoreFreeSpace;
        public ManagedObjectReference publicNetwork;
        public ManagedObjectReference clusterNetwork;

        private VmLocationInfoInternal() {
        }
    }
}

