/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcha.impl;

import com.vmware.vim.binding.vim.OpaqueNetwork;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.vm.customization.FixedIp;
import com.vmware.vim.binding.vim.vm.customization.FixedIpV6;
import com.vmware.vim.binding.vim.vm.customization.IPSettings;
import com.vmware.vim.binding.vim.vm.customization.IpV6Generator;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.cloudvm.DnsServerConfig;
import com.vmware.vise.vim.cloudvm.IPv4Config;
import com.vmware.vise.vim.cloudvm.IPv6Address;
import com.vmware.vise.vim.cloudvm.IPv6Config;
import com.vmware.vise.vim.cloudvm.NetworkInterfaceInfo;
import com.vmware.vsphere.client.vcha.impl.VchaMockDataProvider;
import com.vmware.vsphere.client.vcha.model.VchaGuestOsNetworkInfo;
import com.vmware.vsphere.client.vcha.model.VchaGuestOsNicInfo;
import com.vmware.vsphere.client.vcha.util.VchaUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VchaVmNetworkProvider
implements PropertyProviderBean {
    private static final String PROPERTY_VC_URI = "vchaVcNodeUri";
    private static final String PROPERTY_NICS = "nics";
    private static final String PROPERTY_IPV4_CONFIG = "ipv4Config";
    private static final String PROPERTY_IPV6_CONFIG = "ipv6Config";
    private static final String PROPERTY_DNS_CONFIG = "dnsConfig";
    private static final int NIC_CLUSTER_IDX = 1;
    private static final int NIC_PUBLIC_IDX = 0;
    private static final String IPV6_LINK_LOCAL_PREFIX = "fe80";
    private static final String PROPERTY_VM_DEVICES = "config.hardware.device";
    private static final String PROPERTY_VM_ALLNETWORKS = "allNetwork";
    private static final String PROPERTY_DVPG_KEY = "key";
    private static final String PROPERTY_DVPG_DVSUUID = "dvsUuid";
    private static final String PROPERTY_OPNET_SUMMARY = "summary";
    private static final Log _logger = LogFactory.getLog(VchaVmNetworkProvider.class);
    private QueryExecutor _queryExecutor;
    private QuerySpecBuilder _querySpecBuilder;
    private VchaMockDataProvider _mockDataProvider;

    public VchaVmNetworkProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder, VchaMockDataProvider mockDataProvider) {
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
        this._mockDataProvider = mockDataProvider;
    }

    @type(value="Folder")
    public VchaGuestOsNetworkInfo getVchaGuestOsNetworkInfo(ManagedObjectReference rootFolderRef) throws Exception {
        VchaGuestOsNetworkInfo networkInfo = new VchaGuestOsNetworkInfo();
        PropertyValue[] propValues = null;
        if (this._mockDataProvider.getUseMockData("vchaGuestOsNetworkInfo")) {
            propValues = this._mockDataProvider.getVchaGuestOsNetworkInfoPropertyValues();
        } else {
            try {
                URI vcServerNodeUri = (URI)this._queryExecutor.getProperty((Object)rootFolderRef, PROPERTY_VC_URI);
                if (vcServerNodeUri == null) {
                    if (VchaUtil.isUserSysConfigAuthorized()) {
                        _logger.error((Object)"VC Server Node URI cannot be retrieved.");
                        networkInfo.errorCode = 1;
                    } else {
                        _logger.warn((Object)"Insufficient privileges to retrieve VC Server Node URI");
                        networkInfo.errorCode = 2;
                    }
                    return networkInfo;
                }
                propValues = this._queryExecutor.getProperties((Object)vcServerNodeUri, new String[]{PROPERTY_NICS, PROPERTY_IPV4_CONFIG, PROPERTY_IPV6_CONFIG, PROPERTY_DNS_CONFIG});
            }
            catch (Exception e) {
                _logger.error((Object)e);
                networkInfo.errorCode = 1;
                return networkInfo;
            }
        }
        NicInternal[] nicConfigs = this.getNicGuestOsConfigInternal(propValues);
        this.sortNicsById(nicConfigs);
        NicInternal clusterNicConfig = null;
        if (nicConfigs.length > 1 && nicConfigs[1] != null) {
            clusterNicConfig = nicConfigs[1];
        }
        networkInfo.clusterNetworkNic = this.getGuestOsNicInfo((NicGuestOsConfigInternal)clusterNicConfig);
        NicInternal publicNicConfig = null;
        if (nicConfigs.length > 0 && nicConfigs[0] != null) {
            publicNicConfig = nicConfigs[0];
        }
        networkInfo.publicNetworkNic = this.getGuestOsNicInfo((NicGuestOsConfigInternal)publicNicConfig);
        boolean bl = networkInfo.otherNicsPresent = nicConfigs.length > 2;
        if (networkInfo.otherNicsPresent) {
            networkInfo.otherNetworkNic = new VchaGuestOsNicInfo[nicConfigs.length - 2];
            for (int i = 2; i < nicConfigs.length; ++i) {
                networkInfo.otherNetworkNic[i - 2] = this.getGuestOsNicInfo((NicGuestOsConfigInternal)nicConfigs[i]);
            }
        }
        return networkInfo;
    }

    @type(value="VirtualMachine")
    public ManagedObjectReference[] getVchaVmNicNetwork(ManagedObjectReference vm) throws Exception {
        ResultSet result = this._queryExecutor.getData(this._querySpecBuilder.buildQuerySpec((Object)vm, new String[]{PROPERTY_VM_DEVICES, PROPERTY_VM_ALLNETWORKS}));
        VirtualDevice[] vmDevices = null;
        ManagedObjectReference[] vmNetworks = null;
        if (result != null && !ArrayUtil.isNullOrEmpty((Object[])result.items)) {
            for (ResultItem item : result.items) {
                if (ArrayUtil.isNullOrEmpty((Object[])item.properties)) continue;
                PropertyValue[] propertyValueArray = item.properties;
                int n = propertyValueArray.length;
                for (int i = 0; i < n; ++i) {
                    PropertyValue pv = propertyValueArray[i];
                    if (PROPERTY_VM_DEVICES.equals(pv.propertyName)) {
                        vmDevices = (VirtualDevice[])pv.value;
                        continue;
                    }
                    if (!PROPERTY_VM_ALLNETWORKS.equals(pv.propertyName)) continue;
                    vmNetworks = (ManagedObjectReference[])pv.value;
                }
            }
        }
        NetworkConfigInternal[] networkConfigs = this.getNetworkConfigInternal(vmNetworks);
        NicInternal[] nicConfigs = this.getNicDeviceConfigInternal(vmDevices);
        this.sortNicsById(nicConfigs);
        ArrayList<ManagedObjectReference> orderedNetworks = new ArrayList<ManagedObjectReference>();
        for (NicInternal nicConfig : nicConfigs) {
            if (((NicDeviceConfigInternal)nicConfig).standardNetwork != null) {
                orderedNetworks.add(((NicDeviceConfigInternal)nicConfig).standardNetwork);
                continue;
            }
            if (!StringUtil.isNullOrEmpty((String)((NicDeviceConfigInternal)nicConfig).portgroupKey)) {
                orderedNetworks.add(this.findPortGroup(networkConfigs, ((NicDeviceConfigInternal)nicConfig).portgroupKey, ((NicDeviceConfigInternal)nicConfig).switchUuid));
                continue;
            }
            if (!StringUtil.isNullOrEmpty((String)((NicDeviceConfigInternal)nicConfig).opaqueNetworkId) && !StringUtil.isNullOrEmpty((String)((NicDeviceConfigInternal)nicConfig).opaqueNetworkType)) {
                orderedNetworks.add(this.findOpaqueNetwork(networkConfigs, ((NicDeviceConfigInternal)nicConfig).opaqueNetworkId, ((NicDeviceConfigInternal)nicConfig).opaqueNetworkType));
                continue;
            }
            orderedNetworks.add(null);
        }
        return orderedNetworks.toArray(new ManagedObjectReference[orderedNetworks.size()]);
    }

    private NicGuestOsConfigInternal[] getNicGuestOsConfigInternal(PropertyValue[] propValues) {
        if (ArrayUtils.isEmpty((Object[])propValues)) {
            _logger.error((Object)"Required properties not retrieved.");
            return new NicGuestOsConfigInternal[0];
        }
        Object[] ipv4Configs = null;
        Object[] ipv6Configs = null;
        DnsServerConfig dnsConfig = null;
        NetworkInterfaceInfo[] nics = null;
        for (PropertyValue propValue : propValues) {
            if (propValue == null || propValue.value == null) continue;
            if (propValue.propertyName == PROPERTY_NICS) {
                nics = (NetworkInterfaceInfo[])propValue.value;
                continue;
            }
            if (propValue.propertyName == PROPERTY_IPV4_CONFIG) {
                ipv4Configs = (IPv4Config[])propValue.value;
                continue;
            }
            if (propValue.propertyName == PROPERTY_IPV6_CONFIG) {
                ipv6Configs = (IPv6Config[])propValue.value;
                continue;
            }
            if (propValue.propertyName != PROPERTY_DNS_CONFIG) continue;
            dnsConfig = (DnsServerConfig)propValue.value;
        }
        if (ArrayUtils.isEmpty(nics)) {
            _logger.warn((Object)"No OS network interfaces found.");
            return new NicGuestOsConfigInternal[0];
        }
        NicGuestOsConfigInternal[] nicOsConfigs = new NicGuestOsConfigInternal[nics.length];
        for (int i = 0; i < nics.length; ++i) {
            nicOsConfigs[i] = new NicGuestOsConfigInternal();
            nicOsConfigs[i].id = this.getId(nics[i].name);
            nicOsConfigs[i].nic = nics[i];
            if (!ArrayUtils.isEmpty((Object[])ipv4Configs)) {
                for (Object ipv4Config : ipv4Configs) {
                    if (ipv4Config == null || !((IPv4Config)ipv4Config).nic.equals(nics[i].name)) continue;
                    nicOsConfigs[i].ipv4Config = ipv4Config;
                    break;
                }
            }
            if (!ArrayUtils.isEmpty((Object[])ipv6Configs)) {
                for (Object ipv6Config : ipv6Configs) {
                    if (ipv6Config == null || !((IPv6Config)ipv6Config).nic.equals(nics[i].name)) continue;
                    nicOsConfigs[i].ipv6Config = ipv6Config;
                    break;
                }
            }
            nicOsConfigs[i].dnsConfig = dnsConfig;
        }
        return nicOsConfigs;
    }

    private VchaGuestOsNicInfo getGuestOsNicInfo(NicGuestOsConfigInternal nicConfig) {
        VchaGuestOsNicInfo nicInfo = new VchaGuestOsNicInfo();
        boolean bl = nicInfo.isNicPresent = nicConfig != null;
        if (nicInfo.isNicPresent && nicConfig.nic != null) {
            nicInfo.isNicUp = NetworkInterfaceInfo.NetworkInterfaceStatus.UP.equals((Object)nicConfig.nic.status);
            nicInfo.nicName = nicConfig.nic.name;
        }
        if (nicInfo.isNicUp) {
            boolean bl2 = nicInfo.isIpv4Supported = nicConfig.ipv4Config != null && !IPv4Config.Ipv4Mode.UNCONFIGURED.equals((Object)nicConfig.ipv4Config.mode);
        }
        if (nicInfo.isIpv4Supported) {
            nicInfo.isIpv4DynamicEnabled = IPv4Config.Ipv4Mode.DHCP.equals((Object)nicConfig.ipv4Config.mode);
            boolean bl3 = nicInfo.isIpv4StaticConfigured = IPv4Config.Ipv4Mode.STATIC.equals((Object)nicConfig.ipv4Config.mode) && !StringUtil.isNullOrEmpty((String)nicConfig.ipv4Config.address) && nicConfig.ipv4Config.prefix > 0;
        }
        if (nicInfo.isNicUp) {
            boolean bl4 = nicInfo.isIpv6Supported = nicConfig.ipv6Config != null && nicConfig.ipv6Config.addresses != null;
        }
        if (nicInfo.isIpv6Supported) {
            int validStaticOriginCount = 0;
            int nonStaticOriginCount = 0;
            IPv6Address[] iPv6AddressArray = nicConfig.ipv6Config.addresses;
            int n = iPv6AddressArray.length;
            for (int i = 0; i < n; ++i) {
                IPv6Address ipv6Addr = iPv6AddressArray[i];
                if (IPv6Address.Ipv6Origin.MANUAL.equals((Object)ipv6Addr.origin)) {
                    if (StringUtil.isNullOrEmpty((String)ipv6Addr.address) || ipv6Addr.prefix <= 0) continue;
                    ++validStaticOriginCount;
                    continue;
                }
                if (!StringUtil.isNullOrEmpty((String)ipv6Addr.address) && ipv6Addr.address.startsWith(IPV6_LINK_LOCAL_PREFIX)) continue;
                ++nonStaticOriginCount;
            }
            nicInfo.isIpv6DynamicEnabled = nicConfig.ipv6Config.dhcp || nonStaticOriginCount > 0;
            nicInfo.isIpv6StaticConfigured = validStaticOriginCount > 0;
            nicInfo.isIpv6SingleStaticConfigured = validStaticOriginCount == 1;
        }
        nicInfo.ipSettings = new IPSettings();
        if (nicInfo.isIpv4Supported && nicInfo.isIpv4StaticConfigured) {
            nicInfo.ipSettings.ip = new FixedIp(nicConfig.ipv4Config.address);
            nicInfo.ipSettings.subnetMask = VchaUtil.convertPrefixToSubnetMask(nicConfig.ipv4Config.prefix);
            nicInfo.ipSettings.gateway = new String[]{nicConfig.ipv4Config.defaultGateway};
        }
        if (nicInfo.isIpv6Supported && nicInfo.isIpv6StaticConfigured) {
            ArrayList<FixedIpV6> ipv6Gens = new ArrayList<FixedIpV6>();
            for (IPv6Address ipv6Addr : nicConfig.ipv6Config.addresses) {
                if (!IPv6Address.Ipv6Origin.MANUAL.equals((Object)ipv6Addr.origin)) continue;
                ipv6Gens.add(new FixedIpV6(ipv6Addr.address, ipv6Addr.prefix));
            }
            if (ipv6Gens.size() > 0 || !StringUtil.isNullOrEmpty((String)nicConfig.ipv6Config.defaultGateway)) {
                nicInfo.ipSettings.ipV6Spec = new IPSettings.IpV6AddressSpec();
                if (ipv6Gens.size() > 0) {
                    nicInfo.ipSettings.ipV6Spec.ip = (IpV6Generator[])ipv6Gens.toArray(new FixedIpV6[ipv6Gens.size()]);
                }
                if (!StringUtil.isNullOrEmpty((String)nicConfig.ipv6Config.defaultGateway)) {
                    nicInfo.ipSettings.ipV6Spec.gateway = new String[]{nicConfig.ipv6Config.defaultGateway};
                }
            }
        }
        if (nicInfo.isNicPresent && nicConfig.dnsConfig != null) {
            nicInfo.ipSettings.dnsServerList = nicConfig.dnsConfig.servers;
        }
        return nicInfo;
    }

    private NicDeviceConfigInternal[] getNicDeviceConfigInternal(VirtualDevice[] vmDevices) {
        ArrayList<NicDeviceConfigInternal> nicConfigList = new ArrayList<NicDeviceConfigInternal>();
        for (VirtualDevice vmDevice : vmDevices) {
            if (!(vmDevice instanceof VirtualEthernetCard)) continue;
            NicDeviceConfigInternal nicConfig = new NicDeviceConfigInternal();
            nicConfigList.add(nicConfig);
            nicConfig.id = this.getDeviceId(vmDevice);
            VirtualEthernetCard vmNic = (VirtualEthernetCard)vmDevice;
            if (vmNic.backing instanceof VirtualEthernetCard.NetworkBackingInfo) {
                VirtualEthernetCard.NetworkBackingInfo standardMetworkBacking = (VirtualEthernetCard.NetworkBackingInfo)vmNic.backing;
                nicConfig.standardNetwork = standardMetworkBacking.network;
                continue;
            }
            if (vmNic.backing instanceof VirtualEthernetCard.DistributedVirtualPortBackingInfo) {
                VirtualEthernetCard.DistributedVirtualPortBackingInfo dvPgBacking = (VirtualEthernetCard.DistributedVirtualPortBackingInfo)vmNic.backing;
                if (dvPgBacking.port != null && !StringUtil.isNullOrEmpty((String)dvPgBacking.port.portgroupKey) && !StringUtil.isNullOrEmpty((String)dvPgBacking.port.switchUuid)) {
                    nicConfig.portgroupKey = dvPgBacking.port.portgroupKey;
                    nicConfig.switchUuid = dvPgBacking.port.switchUuid;
                    continue;
                }
                _logger.info((Object)"Standalone port or missing network backing found.");
                continue;
            }
            if (!(vmNic.backing instanceof VirtualEthernetCard.OpaqueNetworkBackingInfo)) continue;
            VirtualEthernetCard.OpaqueNetworkBackingInfo opaqueNetworkBacking = (VirtualEthernetCard.OpaqueNetworkBackingInfo)vmNic.backing;
            nicConfig.opaqueNetworkId = opaqueNetworkBacking.opaqueNetworkId;
            nicConfig.opaqueNetworkType = opaqueNetworkBacking.opaqueNetworkType;
        }
        return nicConfigList.toArray(new NicDeviceConfigInternal[nicConfigList.size()]);
    }

    private NetworkConfigInternal[] getNetworkConfigInternal(ManagedObjectReference[] networks) throws Exception {
        if (ArrayUtil.isNullOrEmpty((Object[])networks)) {
            return new NetworkConfigInternal[0];
        }
        ArrayList<String> networkPropList = new ArrayList<String>();
        Hashtable<ManagedObjectReference, NetworkConfigInternal> networkConfigMap = new Hashtable<ManagedObjectReference, NetworkConfigInternal>();
        for (ManagedObjectReference vmNetwork : networks) {
            if (DistributedVirtualPortgroup.class.getSimpleName().equals(vmNetwork.getType())) {
                networkPropList.add(PROPERTY_DVPG_KEY);
                networkPropList.add(PROPERTY_DVPG_DVSUUID);
            } else if (OpaqueNetwork.class.getSimpleName().equals(vmNetwork.getType())) {
                networkPropList.add(PROPERTY_OPNET_SUMMARY);
            }
            NetworkConfigInternal networkConfigHelper = new NetworkConfigInternal();
            networkConfigHelper.vmNetwork = vmNetwork;
            networkConfigMap.put(vmNetwork, networkConfigHelper);
        }
        ResultSet result = this._queryExecutor.getData(this._querySpecBuilder.buildQuerySpec((Object[])networkConfigMap.keySet().toArray(new ManagedObjectReference[networkConfigMap.size()]), networkPropList.toArray(new String[networkPropList.size()])));
        if (result != null && !ArrayUtil.isNullOrEmpty((Object[])result.items)) {
            for (ResultItem item : result.items) {
                if (ArrayUtil.isNullOrEmpty((Object[])item.properties)) continue;
                for (PropertyValue pv : item.properties) {
                    if (PROPERTY_DVPG_KEY.equals(pv.propertyName)) {
                        ((NetworkConfigInternal)networkConfigMap.get((Object)item.resourceObject)).portgroupKey = (String)pv.value;
                        continue;
                    }
                    if (PROPERTY_DVPG_DVSUUID.equals(pv.propertyName)) {
                        ((NetworkConfigInternal)networkConfigMap.get((Object)item.resourceObject)).dvsUuid = (String)pv.value;
                        continue;
                    }
                    if (!PROPERTY_OPNET_SUMMARY.equals(pv.propertyName)) continue;
                    ((NetworkConfigInternal)networkConfigMap.get((Object)item.resourceObject)).opaqueNetworkSummary = (OpaqueNetwork.Summary)pv.value;
                }
            }
        }
        return networkConfigMap.values().toArray(new NetworkConfigInternal[networkConfigMap.size()]);
    }

    private int getDeviceId(VirtualDevice device) {
        int id = -1;
        if (device.deviceInfo != null && !StringUtil.isNullOrEmpty((String)device.deviceInfo.label)) {
            id = this.getId(device.deviceInfo.label);
        }
        return id;
    }

    private ManagedObjectReference findPortGroup(NetworkConfigInternal[] networkConfigs, String portgroupKey, String switchUuid) {
        if (StringUtil.isNullOrEmpty((String)portgroupKey) || StringUtil.isNullOrEmpty((String)switchUuid) || ArrayUtil.isNullOrEmpty((Object[])networkConfigs)) {
            return null;
        }
        for (NetworkConfigInternal networkConfig : networkConfigs) {
            if (!portgroupKey.equals(networkConfig.portgroupKey) || !switchUuid.equals(networkConfig.dvsUuid)) continue;
            return networkConfig.vmNetwork;
        }
        return null;
    }

    private ManagedObjectReference findOpaqueNetwork(NetworkConfigInternal[] networkConfigs, String opaqueNetworkId, String opaqueNetworkType) {
        if (StringUtil.isNullOrEmpty((String)opaqueNetworkId) || StringUtil.isNullOrEmpty((String)opaqueNetworkType) || ArrayUtil.isNullOrEmpty((Object[])networkConfigs)) {
            return null;
        }
        for (NetworkConfigInternal networkConfig : networkConfigs) {
            if (!opaqueNetworkId.equals(networkConfig.opaqueNetworkSummary.opaqueNetworkId) || !opaqueNetworkType.equals(networkConfig.opaqueNetworkSummary.opaqueNetworkType)) continue;
            return networkConfig.vmNetwork;
        }
        return null;
    }

    private int getId(String name) {
        int id = -1;
        String idStr = name.replaceAll("[^0123456789]", "");
        try {
            id = Integer.parseInt(idStr);
        }
        catch (NumberFormatException e) {
            _logger.error((Object)e);
        }
        return id;
    }

    private boolean verifyAllIdsSet(NicInternal[] nics) {
        if (ArrayUtils.isEmpty((Object[])nics)) {
            return false;
        }
        for (NicInternal nic : nics) {
            if (nic.id > -1) continue;
            return false;
        }
        return true;
    }

    private void sortNicsById(NicInternal[] nics) {
        if (this.verifyAllIdsSet(nics)) {
            Arrays.sort(nics, new Comparator<NicInternal>(){

                @Override
                public int compare(NicInternal o1, NicInternal o2) {
                    return Integer.compare(o1.id, o2.id);
                }
            });
        } else {
            _logger.warn((Object)"NICs might not be sorted by ID");
        }
    }

    private class NicGuestOsConfigInternal
    extends NicInternal {
        public NetworkInterfaceInfo nic;
        public IPv4Config ipv4Config;
        public IPv6Config ipv6Config;
        public DnsServerConfig dnsConfig;

        private NicGuestOsConfigInternal() {
        }
    }

    private class NicDeviceConfigInternal
    extends NicInternal {
        public ManagedObjectReference standardNetwork;
        public String portgroupKey;
        public String switchUuid;
        public String opaqueNetworkId;
        public String opaqueNetworkType;

        private NicDeviceConfigInternal() {
        }
    }

    private class NicInternal {
        public int id;

        private NicInternal() {
        }
    }

    private class NetworkConfigInternal {
        public ManagedObjectReference vmNetwork;
        public String portgroupKey;
        public String dvsUuid;
        public OpaqueNetwork.Summary opaqueNetworkSummary;

        private NetworkConfigInternal() {
        }
    }
}

