/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.cm.common.testhelper;

import com.vmware.cis.cm.common.testhelper.TestHelperRequest;
import com.vmware.cis.services.common.sso.StsCertManager;
import com.vmware.cis.services.common.sso.StsCertManagerImpl;
import com.vmware.cis.services.common.util.SpringApplicationContext;
import com.vmware.vim.sso.client.util.codec.Base64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.springframework.context.ApplicationContext;

public class ChangeStsCertsRequest
extends TestHelperRequest {
    private static final Log _log = LogFactory.getLog(ChangeStsCertsRequest.class);
    private Arguments _args;

    public ChangeStsCertsRequest() {
    }

    public ChangeStsCertsRequest(Arguments args) {
        this.setArguments(args);
    }

    public void setArguments(Arguments args) {
        this._args = args;
    }

    public Arguments getArguments() {
        return this._args;
    }

    @Override
    public void serializeArguments(JsonGenerator jg) throws IOException {
        _jsonMapper.writeValue(jg, (Object)this.getArguments());
    }

    @Override
    public void deserializeArguments(JsonParser jp) throws IOException {
        this.setArguments((Arguments)_jsonMapper.readValue(jp, Arguments.class));
    }

    @Override
    public void execute() {
        ApplicationContext appContext = SpringApplicationContext.getInstance().getApplicationContext();
        StsCertManager stsCertManager = (StsCertManager)appContext.getBean("stsCertManager");
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        for (String s : this.getArguments().getCertsBase64()) {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                certs.add((X509Certificate)cf.generateCertificate(new ByteArrayInputStream(Base64.decodeBase64((String)s))));
            }
            catch (CertificateException e) {
                _log.error((Object)String.format("Failed to decode certificate: %s", s), (Throwable)e);
            }
        }
        ((StsCertManagerImpl)stsCertManager).setStsCertificates(certs, this._args.getDisableRefetch());
    }

    public static class Arguments {
        private boolean _disableRefetch;
        private String[] _certsBase64;

        public Arguments() {
        }

        public Arguments(boolean disableRefetch, String[] certsBase64) {
            this();
            this.setDisableRefetch(disableRefetch);
            this.setCertsBase64(certsBase64);
        }

        public void setDisableRefetch(boolean disableRefetch) {
            this._disableRefetch = disableRefetch;
        }

        public boolean getDisableRefetch() {
            return this._disableRefetch;
        }

        public void setCertsBase64(String[] certsBase64) {
            this._certsBase64 = certsBase64 == null ? null : Arrays.copyOf(certsBase64, certsBase64.length);
        }

        public String[] getCertsBase64() {
            return this._certsBase64 == null ? null : Arrays.copyOf(this._certsBase64, this._certsBase64.length);
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass()) && this._disableRefetch == ((Arguments)obj).getDisableRefetch() && Arrays.equals(this._certsBase64, ((Arguments)obj).getCertsBase64());
        }

        public int hashCode() {
            int hc;
            int n = hc = this._disableRefetch ? 1 : 0;
            if (this._certsBase64 != null) {
                for (String c : this._certsBase64) {
                    hc += c.hashCode();
                }
            }
            return hc;
        }
    }
}

