/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.help.signpost.impl;

import com.vmware.vise.extensionfw.ExtensionListener;
import com.vmware.vise.extensionfw.PluginPackageEvent;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.help.signpost.SignpostManager;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SignpostHelpExtensionListenerImpl
implements ExtensionListener {
    private static final Log _logger = LogFactory.getLog(SignpostHelpExtensionListenerImpl.class);

    public void handleEvent(PluginPackageEvent pluginPackageEvent) {
        PluginPackageInfo[] pluginPackageInfoArray = pluginPackageEvent.getPluginPackageInfos();
        if (pluginPackageInfoArray == null || pluginPackageInfoArray.length == 0) {
            return;
        }
        String string = pluginPackageEvent.getType();
        for (PluginPackageInfo pluginPackageInfo : pluginPackageInfoArray) {
            File file = pluginPackageInfo.getDirectory();
            _logger.debug((Object)("Loading signpost from " + file));
            try {
                if ("pluginPackageDeployed".equals(string)) {
                    SignpostManager.INSTANCE.processSignPostsFromPackage(file, true);
                    continue;
                }
                if (!"pluginPackageUndeployed".equals(string)) continue;
                SignpostManager.INSTANCE.processSignPostsFromPackage(file, false);
            }
            catch (Exception exception) {
                _logger.error((Object)("Error loading signpost " + file), (Throwable)exception);
            }
        }
    }
}

